/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.BookSubProvider;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;

public abstract class AddToBookSubProvider
extends ModonomiconProviderBase
implements BookSubProvider {
    protected BookModel book = null;
    protected String bookId;
    protected int currentSortIndex;

    public AddToBookSubProvider(ResourceLocation targetBook, BiConsumer<String, String> defaultLang) {
        this(targetBook, defaultLang, Map.of());
    }

    public AddToBookSubProvider(ResourceLocation targetBook, BiConsumer<String, String> defaultLang, Map<String, BiConsumer<String, String>> translations) {
        super(targetBook.getNamespace(), defaultLang, translations, new BookContextHelper(targetBook.getNamespace()), new ConditionHelper());
        this.bookId = targetBook.getPath();
        this.currentSortIndex = 0;
    }

    public String bookId() {
        return this.bookId;
    }

    protected void registerDefaultMacro(String macro, String value) {
        this.registerMacro(macro, value);
    }

    protected void currentSortIndex(int index) {
        this.currentSortIndex = index;
    }

    protected BookCategoryModel add(BookCategoryModel category) {
        if (category.getSortNumber() == -1) {
            category.withSortNumber(this.currentSortIndex++);
        }
        this.book.withCategory(category);
        return category;
    }

    @Override
    public void generate(BiConsumer<ResourceLocation, BookModel> consumer, HolderLookup.Provider registries) {
        this.registries(registries);
        this.registerDefaultMacros();
        this.context().book(this.bookId());
        this.book = BookModel.create(this.modLoc(this.bookId), this.context().bookName());
        this.book.withDontGenerateJson(true);
        this.generateCategories();
        consumer.accept(this.book.getId(), this.book);
    }

    protected abstract void registerDefaultMacros();

    protected abstract void generateCategories();
}

