/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.event;

import cy.jdkdigital.productivemetalworks.ProductiveMetalworks;
import cy.jdkdigital.productivemetalworks.client.render.block.CastingBlockEntityRenderer;
import cy.jdkdigital.productivemetalworks.client.render.block.FoundryControllerBlockEntityRenderer;
import cy.jdkdigital.productivemetalworks.client.render.block.FoundryTankBlockEntityRenderer;
import cy.jdkdigital.productivemetalworks.client.render.block.FoundryTapBlockEntityRenderer;
import cy.jdkdigital.productivemetalworks.client.screen.FoundryControllerScreen;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.client.Camera;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@EventBusSubscriber(modid="productivemetalworks", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void registerMenus(RegisterMenuScreensEvent event) {
        event.register((MenuType)MetalworksRegistrator.FOUNDRY_CONTROLLER_CONTAINER.get(), FoundryControllerScreen::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)MetalworksRegistrator.FOUNDRY_CONTROLLER_BLOCK_ENTITY.get(), FoundryControllerBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MetalworksRegistrator.FOUNDRY_TANK_BLOCK_ENTITY.get(), FoundryTankBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MetalworksRegistrator.FOUNDRY_TAP_BLOCK_ENTITY.get(), FoundryTapBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MetalworksRegistrator.CASTING_BLOCK_ENTITY.get(), CastingBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        ProductiveMetalworks.FLUID_TYPES.getEntries().forEach(fluidHolder -> event.registerFluidType(new IClientFluidTypeExtensions((DeferredHolder)fluidHolder){
            final /* synthetic */ DeferredHolder val$fluidHolder;
            {
                this.val$fluidHolder = deferredHolder;
            }

            @NotNull
            public ResourceLocation getStillTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/fluid/molten_metal");
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/fluid/molten_metal_flow");
            }

            public ResourceLocation getOverlayTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/fluid/molten_metal");
            }

            public int getTintColor() {
                return MetalworksRegistrator.FLUID_COLORS.get(this.val$fluidHolder.getId().getPath());
            }

            @NotNull
            public Vector3f modifyFogColor(@NotNull Camera camera, float partialTick, @NotNull ClientLevel level, int renderDistance, float darkenWorldAmount, @NotNull Vector3f fluidFogColor) {
                Integer fluidColor = MetalworksRegistrator.FLUID_COLORS.get(this.val$fluidHolder.getId().getPath());
                return new Vector3f((float)(fluidColor >> 16 & 0xFF), (float)(fluidColor >> 8 & 0xFF), (float)(fluidColor & 0xFF)).div(255.0f).mul(0.2f);
            }
        }, new FluidType[]{(FluidType)fluidHolder.get()}));
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        ProductiveMetalworks.ITEMS.getEntries().forEach(itemHolder -> {
            if (itemHolder.getId().getPath().contains("_bucket")) {
                event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{(ItemLike)itemHolder.get()});
            }
        });
    }
}

