/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.screen;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivelib.util.FluidContainerUtil;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.common.menu.FoundryControllerContainer;
import cy.jdkdigital.productivemetalworks.network.MoveFoundryFluidData;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.registry.ModTags;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import cy.jdkdigital.productivemetalworks.util.TickingSlotInventoryHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class FoundryControllerScreen
extends AbstractContainerScreen<FoundryControllerContainer> {
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/container/foundry_controller.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private boolean isScrolling;
    private float scrollOffs;
    private int fuelTanks = 0;
    Map<Integer, Pair<Integer, Integer>> fluidPositions = new HashMap<Integer, Pair<Integer, Integer>>();

    public FoundryControllerScreen(FoundryControllerContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.imageWidth = 202;
    }

    protected void init() {
        super.init();
        if (((FoundryControllerContainer)this.menu).blockEntity.getMultiblockData() != null) {
            ((FoundryControllerContainer)this.menu).scrollTo(this.scrollOffs);
            this.fuelTanks = (int)((FoundryControllerContainer)this.menu).blockEntity.getMultiblockData().peripherals().stream().filter(blockPos -> ((FoundryControllerContainer)this.menu).blockEntity.getLevel().getBlockState(blockPos).is(ModTags.Blocks.FOUNDRY_TANKS)).count();
        }
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(GUI, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        IItemHandler iItemHandler = ((FoundryControllerContainer)this.menu).blockEntity.getItemHandler();
        if (iItemHandler instanceof TickingSlotInventoryHandler) {
            TickingSlotInventoryHandler itemHandler = (TickingSlotInventoryHandler)iItemHandler;
            int rowIndex = ((FoundryControllerContainer)this.menu).getRowIndexForScroll(this.scrollOffs);
            int slotsAfterScroll = itemHandler.getSlots() - rowIndex * FoundryControllerContainer.COLUMNS;
            int rows = ((FoundryControllerContainer)this.menu).calculateRowCount(rowIndex);
            for (int row = 0; row < Math.min(3, rows); ++row) {
                for (int i = 0; i < FoundryControllerContainer.COLUMNS; ++i) {
                    int slot = row * FoundryControllerContainer.COLUMNS + rowIndex * FoundryControllerContainer.COLUMNS + i;
                    if (row * FoundryControllerContainer.COLUMNS + i >= slotsAfterScroll || slot >= itemHandler.getSlots() || !((Slot)((FoundryControllerContainer)this.menu).slots.get(slot)).isActive()) continue;
                    int slotX = this.getGuiLeft() + 79 + i * 18;
                    int slotY = this.getGuiTop() + 16 + row * 18;
                    guiGraphics.blit(GUI, slotX, slotY, 202, 0, 18, 18);
                    ItemStack stack = itemHandler.getStackInSlot(slot);
                    if (stack.isEmpty()) continue;
                    Pair<Integer, Integer> ticker = itemHandler.getTicker(slot);
                    if ((Integer)ticker.getSecond() != 0 && !((Integer)ticker.getFirst()).equals(ticker.getSecond())) {
                        int progress = (int)(18.0f - (float)((Integer)ticker.getFirst()).intValue() / (float)((Integer)ticker.getSecond()).intValue() * 18.0f);
                        guiGraphics.blit(GUI, slotX, slotY + (18 - progress), 202, 36 - progress, 18, progress);
                        continue;
                    }
                    guiGraphics.blit(GUI, slotX, slotY, 202, 36, 18, 18);
                }
            }
        }
        guiGraphics.blitSprite(SCROLLER_SPRITE, this.getGuiLeft() + 156, this.getGuiTop() + 17 + (int)(37.0f * this.scrollOffs), 12, 15);
        if (!((FoundryControllerContainer)this.menu).blockEntity.fuel.isEmpty()) {
            FluidContainerUtil.renderFluidTank((GuiGraphics)guiGraphics, (AbstractContainerScreen)this, (FluidStack)((FoundryControllerContainer)this.menu).blockEntity.fuel, (int)(this.fuelTanks * 4000), (int)57, (int)17, (int)16, (int)52);
        }
        int tankCapacity = ((FoundryControllerContainer)this.menu).blockEntity.fluidHandler.getCapacity();
        if (this.fluidPositions.size() != ((FoundryControllerContainer)this.menu).blockEntity.fluidHandler.getTanks()) {
            this.fluidPositions.clear();
        }
        int nextFluidOffsetFraction = 0;
        for (int tank = 0; tank < ((FoundryControllerContainer)this.menu).blockEntity.fluidHandler.getTanks(); ++tank) {
            FluidStack fluidStack = ((FoundryControllerContainer)this.menu).blockEntity.fluidHandler.getFluidInTank(tank);
            if (fluidStack.isEmpty()) continue;
            int adjustedAmount = Math.max(fluidStack.getAmount(), tankCapacity / 52);
            double fluidHeight = Math.floor(52.0 * ((double)adjustedAmount / (double)tankCapacity)) + (double)(tank > 0 ? 1 : 0);
            this.fluidPositions.put(tank, (Pair<Integer, Integer>)Pair.of((Object)nextFluidOffsetFraction, (Object)((int)fluidHeight)));
            FluidContainerUtil.renderFluidTank((GuiGraphics)guiGraphics, (AbstractContainerScreen)this, (FluidStack)fluidStack, (int)(adjustedAmount + (tank > 0 ? tankCapacity / 52 : 0)), (int)tankCapacity, (int)8, (int)17, (int)42, (int)52, (int)0, (int)0, (int)(-1 * nextFluidOffsetFraction));
            nextFluidOffsetFraction += (int)fluidHeight;
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tank;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
        if (this.insideFuelTank(mouseX, mouseY) && !((FoundryControllerContainer)this.menu).blockEntity.fuel.isEmpty()) {
            FuelMap fuelData = (FuelMap)((FoundryControllerContainer)this.menu).blockEntity.fuel.getFluidHolder().getData(MetalworksRegistrator.FUEL_MAP);
            tooltipList.add(Component.literal((String)(((FoundryControllerContainer)this.menu).blockEntity.fuel.getAmount() + "mb " + Component.translatable((String)((FoundryControllerContainer)this.menu).blockEntity.fuel.getFluid().getFluidType().getDescriptionId()).getString())).getVisualOrderText());
            if (fuelData != null) {
                tooltipList.add(Component.translatable((String)"gui.productivemetalworks.temperature", (Object[])new Object[]{fuelData.temperature()}).getVisualOrderText());
            }
        }
        if (this.insideTank(mouseX, mouseY) && (tank = this.getHoveredTank(mouseX, mouseY)) >= 0) {
            FluidStack fluidStack = ((FoundryControllerContainer)this.menu).blockEntity.fluidHandler.getFluidInTank(tank);
            tooltipList.add(Component.literal((String)(fluidStack.getAmount() + "mb " + Component.translatable((String)fluidStack.getFluid().getFluidType().getDescriptionId()).getString())).getVisualOrderText());
            tooltipList.addAll(FluidHelper.formatTooltip(fluidStack).stream().map(Component::getVisualOrderText).toList());
        }
        if (!tooltipList.isEmpty()) {
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.insideTank(mouseX, mouseY)) {
            int tank = this.getHoveredTank(mouseX, mouseY);
            PacketDistributor.sendToServer((CustomPacketPayload)new MoveFoundryFluidData(((FoundryControllerContainer)this.menu).blockEntity.getBlockPos(), tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (this.insideScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollOffs = ((float)mouseY - (float)this.getGuiTop() - 24.5f) / 37.0f;
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            ((FoundryControllerContainer)this.menu).scrollTo(this.scrollOffs);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.insideScrollbar(mouseX, mouseY) || this.insideContainer(mouseX, mouseY)) {
            this.scrollOffs = ((FoundryControllerContainer)this.menu).subtractInputFromScroll(this.scrollOffs, scrollY);
            ((FoundryControllerContainer)this.menu).scrollTo(this.scrollOffs);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private int getHoveredTank(double mouseX, double mouseY) {
        if (this.insideTank(mouseX, mouseY)) {
            for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.fluidPositions.entrySet()) {
                Pair<Integer, Integer> o = entry.getValue();
                if (!this.isHovering(8, 69 - (Integer)o.getFirst() - (Integer)o.getSecond(), 42, (Integer)o.getSecond(), mouseX, mouseY)) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    private boolean insideContainer(double mouseX, double mouseY) {
        return this.isHovering(80, 17, 88, 52, mouseX, mouseY);
    }

    private boolean insideFuelTank(double mouseX, double mouseY) {
        return this.isHovering(57, 17, 16, 52, mouseX, mouseY);
    }

    private boolean insideTank(double mouseX, double mouseY) {
        return this.isHovering(8, 17, 42, 52, mouseX, mouseY);
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        return this.isHovering(156, 17, 12, 52, mouseX, mouseY);
    }
}

