/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;

public class ExperienceParticle
extends TextureSheetParticle {
    protected ExperienceParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.pickSprite(sprites);
        this.yd *= (double)0.2f;
        if (xSpeed == 0.0 && zSpeed == 0.0) {
            this.xd *= (double)0.1f;
            this.zd *= (double)0.1f;
        }
        this.quadSize *= 0.3f;
        this.lifetime = (int)(8.0 / (this.random.nextDouble() * 0.8 + 0.2));
        this.hasPhysics = true;
        this.alpha = 0.5f;
        this.gravity = 0.3f;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        float f = ((float)this.age + partialTicks) / 2.0f;
        this.rCol = (Mth.sin((float)(f + 0.0f)) + 1.0f) * 0.5f;
        this.gCol = 1.0f;
        this.bCol = (Mth.sin((float)(f + 4.1887903f)) + 1.0f) * 0.1f;
        super.render(buffer, camera, partialTicks);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ExperienceParticle particle = new ExperienceParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
            particle.setPower(options.f());
            return particle;
        }
    }
}

