/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.tickers.entity_tickers.EntityTicker;
import einstein.subtle_effects.util.EntityTickersGetter;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class ClientEntityMixin
implements EntityTickersGetter {
    @Unique
    private final Entity subtleEffects$me = (Entity)this;
    @Unique
    private final Int2ObjectMap<EntityTicker<?>> subtleEffects$tickers = new Int2ObjectOpenHashMap();

    @Inject(method={"playEntityOnFireExtinguishedSound"}, at={@At(value="TAIL")})
    private void addExtinguishParticles(CallbackInfo ci) {
        Level level = this.subtleEffects$me.level();
        if (level.isClientSide() && ModConfigs.ENTITIES.burning.extinguishSteam) {
            AABB boundingBox = this.subtleEffects$me.getBoundingBox();
            RandomSource random = this.subtleEffects$me.getRandom();
            for (int x = Mth.floor((double)boundingBox.minX); x < Mth.ceil((double)boundingBox.maxX); ++x) {
                for (int y = Mth.floor((double)boundingBox.minY); y < Mth.ceil((double)boundingBox.maxY); ++y) {
                    for (int z = Mth.floor((double)boundingBox.minZ); z < Mth.ceil((double)boundingBox.maxZ); ++z) {
                        BlockPos abovePos;
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!level.getFluidState(pos).is((Fluid)Fluids.WATER) || Util.isSolidOrNotEmpty(level, abovePos = pos.above())) continue;
                        for (int i = 0; i < 5; ++i) {
                            level.addParticle((ParticleOptions)ModParticles.STEAM.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.875 + MathUtil.nextDouble(random, 0.5), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Int2ObjectMap<EntityTicker<?>> subtleEffects$getTickers() {
        return this.subtleEffects$tickers;
    }
}

