/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;

public class ModDamageListeners {
    public static final Map<EntityType<?>, EntityProvider<?>> REGISTERED = new HashMap();

    public static void init() {
        ModDamageListeners.register(EntityType.CHICKEN, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attacked.chickenFeathers) {
                for (int i = 0; i < 10; ++i) {
                    level.addParticle((ParticleOptions)ModParticles.CHICKEN_FEATHER.get(), entity.getX(), entity.getY(0.5), entity.getZ(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.PARROT, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attacked.parrotFeathers) {
                SimpleParticleType particle = switch (entity.getVariant()) {
                    default -> throw new MatchException(null, null);
                    case Parrot.Variant.BLUE -> ModParticles.BLUE_PARROT_FEATHER.get();
                    case Parrot.Variant.GRAY -> ModParticles.GRAY_PARROT_FEATHER.get();
                    case Parrot.Variant.GREEN -> ModParticles.GREEN_PARROT_FEATHER.get();
                    case Parrot.Variant.RED_BLUE -> ModParticles.RED_BLUE_PARROT_FEATHER.get();
                    case Parrot.Variant.YELLOW_BLUE -> ModParticles.YELLOW_BLUE_PARROT_FEATHER.get();
                };
                for (int i = 0; i < 5; ++i) {
                    level.addParticle((ParticleOptions)particle, entity.getX(), entity.getY(0.5), entity.getZ(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.SNOW_GOLEM, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attacked.snowGolemSnowflakes) {
                for (int i = 0; i < 20; ++i) {
                    level.addParticle((ParticleOptions)ModParticles.SNOW.get(), entity.getX(), entity.getY((double)random.nextFloat()), entity.getZ(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
    }

    private static <T extends Entity> void register(EntityType<T> type, EntityProvider<T> provider) {
        REGISTERED.put(type, provider);
    }
}

