/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import einstein.subtle_effects.SubtleEffects;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class EinsteinSolarSystemModel
extends Model {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(SubtleEffects.loc("einstein_solar_system"), "main");
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final ModelPart head;
    private final ModelPart hat;

    public EinsteinSolarSystemModel(ModelPart rootPart) {
        super(RenderType::entityCutout);
        this.head = rootPart.getChild("head");
        this.hat = rootPart.getChild("hat");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float partialTicks, AbstractClientPlayer player) {
        int headCount = HEAD_ROTATIONS.length;
        for (int i = 0; i < headCount; ++i) {
            float i1 = i + 1;
            float spin = EinsteinSolarSystemModel.getSpin(partialTicks, player, i) * ((float)headCount / i1);
            Vector3f rotation = HEAD_ROTATIONS[i];
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f - Mth.rotLerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot)));
            poseStack.mulPose(Axis.YP.rotation(spin));
            poseStack.translate(0.7 * (double)i1, player.isCrouching() ? 0.0 : -0.25, 0.0);
            poseStack.scale(0.8f, 0.8f, 0.8f);
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(rotation.x()));
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation.y()));
            poseStack.mulPose(Axis.ZP.rotationDegrees(rotation.z()));
            poseStack.mulPose(Axis.YP.rotation(spin));
            this.head.render(poseStack, consumer, packedLight, packedOverlay);
            this.hat.render(poseStack, consumer, packedLight, packedOverlay);
            poseStack.popPose();
            poseStack.popPose();
        }
    }

    public static float getSpin(float partialTicks, AbstractClientPlayer player, float speed) {
        return ((float)player.tickCount + partialTicks) / 20.0f + (float)Math.PI * speed;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
    }
}

