/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Matrix4f;

public abstract class RadialMenuRenderer<T> {
    private static final float DRAWS = 300.0f;
    public static final float INNER = 40.0f;
    public static final float OUTER = 100.0f;
    public static final float MIDDLE_DISTANCE = 70.0f;
    private int[] hoverGrows = new int[0];
    private long lastUpdate = System.currentTimeMillis();

    public abstract List<T> getEntries();

    public abstract int getCurrentlySelected();

    public abstract Component getTitle(T var1);

    public abstract ItemStack getIcon(T var1);

    public boolean trackOffCircleMouse() {
        return true;
    }

    public void render(GuiGraphics guiGraphics, boolean trackMouse) {
        List<T> entries = this.getEntries();
        if (entries.isEmpty()) {
            return;
        }
        if (this.hoverGrows.length < entries.size()) {
            this.hoverGrows = ArrayUtils.addAll((int[])this.hoverGrows, (int[])IntStream.range(0, entries.size() - this.hoverGrows.length).map(i -> 0).toArray());
        }
        int count = entries.size();
        float angleSize = 360.0f / (float)count;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float centerX = (float)guiGraphics.guiWidth() / 2.0f;
        float centerY = (float)guiGraphics.guiHeight() / 2.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(centerX, centerY, 0.0f);
        int hot = this.getCurrentlySelected();
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            float startAngle = -90.0f + 360.0f * (-0.5f + (float)i2) / (float)count;
            RadialMenuRenderer.drawTorus(guiGraphics, startAngle, angleSize, 40.0f, 100.0f + 10.0f * ((float)this.hoverGrows[i2] / 10.0f), hot == i2 ? 0.7f : 0.3f, hot == i2 ? 0.4f : 0.3f, hot == i2 ? 0.45f : 0.3f, hot == i2 ? 0.7f : 0.6f);
        }
        if (trackMouse && !Minecraft.getInstance().mouseHandler.isMouseGrabbed()) {
            int underMouse = this.getElementUnderMouse(!this.trackOffCircleMouse());
            long current = System.currentTimeMillis();
            if (current >= this.lastUpdate + 25L) {
                this.lastUpdate = current;
                for (int i3 = 0; i3 < entries.size(); ++i3) {
                    if (i3 == underMouse) {
                        if (this.hoverGrows[i3] >= 10) continue;
                        int n = i3;
                        this.hoverGrows[n] = this.hoverGrows[n] + 1;
                        continue;
                    }
                    if (this.hoverGrows[i3] <= 0) continue;
                    int n = i3;
                    this.hoverGrows[n] = this.hoverGrows[n] - 1;
                }
            }
        }
        record PositionedText(float x, float y, Component text) {
        }
        ArrayList<PositionedText> textToDraw = new ArrayList<PositionedText>(entries.size());
        float position = 0.0f;
        for (T key : entries) {
            float f = position;
            position = f + 1.0f;
            float degrees = 270.0f + 360.0f * (f / (float)count);
            float angle = (float)Math.PI / 180 * degrees;
            float x = Mth.cos((float)angle) * 70.0f;
            float y = Mth.sin((float)angle) * 70.0f;
            ItemStack icon = this.getIcon(key);
            if (!icon.isEmpty()) {
                textToDraw.add(new PositionedText(x, y, this.getTitle(key)));
                guiGraphics.renderItem(icon, Math.round(x - 8.0f), Math.round(y - 8.0f - 2.0f - 9.0f));
                continue;
            }
            textToDraw.add(new PositionedText(x, y - 4.0f, this.getTitle(key)));
        }
        if (!textToDraw.isEmpty()) {
            Font font = Minecraft.getInstance().font;
            for (PositionedText toDraw : textToDraw) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(toDraw.x, toDraw.y, 0.0f);
                guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
                Component text = toDraw.text;
                guiGraphics.drawString(font, text.getVisualOrderText(), (float)(-font.width((FormattedText)text)) / 2.0f, 8.0f, -855638017, true);
                guiGraphics.pose().popPose();
            }
        }
        guiGraphics.pose().popPose();
        RenderSystem.disableBlend();
    }

    public MousePos getMousePos() {
        MouseHandler mouse = Minecraft.getInstance().mouseHandler;
        double mouseX = mouse.xpos() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth();
        double mouseY = mouse.ypos() * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight();
        return new MousePos(mouseX, mouseY);
    }

    protected int getElementUnderMouse(boolean upperboundRadius) {
        float centerY;
        double yDiff;
        MousePos mouse = this.getMousePos();
        double mouseX = mouse.x;
        double mouseY = mouse.y;
        int count = this.getEntries().size();
        Window window = Minecraft.getInstance().getWindow();
        float centerX = (float)window.getGuiScaledWidth() / 2.0f;
        double xDiff = mouseX - (double)centerX;
        double distanceFromCenter = Mth.length((double)xDiff, (double)(yDiff = mouseY - (double)(centerY = (float)window.getGuiScaledHeight() / 2.0f)));
        if (distanceFromCenter > 10.0) {
            if (upperboundRadius && distanceFromCenter > 100.0) {
                return -1;
            }
            float angle = (float)(57.2957763671875 * Mth.atan2((double)yDiff, (double)xDiff));
            float modeSize = 180.0f / (float)count;
            float selectionAngle = RadialMenuRenderer.wrapDegrees(angle + modeSize + 90.0f);
            return (int)(selectionAngle * ((float)count / 360.0f));
        }
        return -1;
    }

    protected void clearState() {
        this.hoverGrows = new int[0];
    }

    private static void drawTorus(GuiGraphics guiGraphics, float startAngle, float sizeAngle, float inner, float outer, float red, float green, float blue, float alpha) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        float draws = 300.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float degrees = startAngle + (float)i / 300.0f * 360.0f;
            float angle = (float)Math.PI / 180 * degrees;
            float cos = Mth.cos((float)angle);
            float sin = Mth.sin((float)angle);
            vertexBuffer.addVertex(matrix4f, outer * cos, outer * sin, 0.0f).setColor(red, green, blue, alpha);
            vertexBuffer.addVertex(matrix4f, inner * cos, inner * sin, 0.0f).setColor(red, green, blue, alpha);
            ++i;
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
    }

    public static float wrapDegrees(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public record MousePos(double x, double y) {
    }
}

