/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.render;

import com.matyrobbrt.keybindbundles.KeyBindBundle;
import com.matyrobbrt.keybindbundles.KeyBindBundleManager;
import com.matyrobbrt.keybindbundles.KeyMappingUtil;
import com.matyrobbrt.keybindbundles.render.AutoCompleteEditBox;
import com.matyrobbrt.keybindbundles.render.RadialMenuRenderer;
import com.matyrobbrt.keybindbundles.util.SearchTreeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class KeyBundleModificationScreen
extends Screen {
    public static KeyBindBundle currentlySelecting;
    private static final KeyBindBundle.KeyEntry ADD_ENTRY;
    private static final List<Component> TOOLTIPS;
    private static final WidgetSprites CROSS_BUTTON_SPRITES;
    private final RadialMenuRenderer<KeyBindBundle.KeyEntry> renderer = new RadialMenuRenderer<KeyBindBundle.KeyEntry>(){

        @Override
        public List<KeyBindBundle.KeyEntry> getEntries() {
            return KeyBundleModificationScreen.this.entries;
        }

        @Override
        public int getCurrentlySelected() {
            return KeyBundleModificationScreen.this.bundle.getBookmark();
        }

        @Override
        public Component getTitle(KeyBindBundle.KeyEntry entry) {
            return Component.literal((String)entry.title());
        }

        @Override
        public ItemStack getIcon(KeyBindBundle.KeyEntry entry) {
            return entry.icon();
        }

        @Override
        public boolean trackOffCircleMouse() {
            return false;
        }
    };
    private final KeyBindBundle bundle;
    private List<KeyBindBundle.KeyEntry> entries = List.of();

    public KeyBundleModificationScreen(KeyBindBundle bundle) {
        super((Component)Component.translatable((String)"title.keybindbundles.editing_keybundle", (Object[])new Object[]{Component.literal((String)bundle.name).withStyle(ChatFormatting.GOLD)}));
        this.bundle = bundle;
    }

    protected void init() {
        super.init();
        this.entries = new ArrayList<KeyBindBundle.KeyEntry>(this.bundle.getEntries());
        this.entries.add(ADD_ENTRY);
        ImageButton deleteButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.width - 18, this.height - 18, 14, 14, CROSS_BUTTON_SPRITES, but -> Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(click -> {
            if (click) {
                currentlySelecting = null;
                Minecraft.getInstance().setScreen(null);
                KeyBindBundleManager.delete(this.bundle);
            } else {
                Minecraft.getInstance().setScreen((Screen)this);
            }
        }, (Component)Component.translatable((String)"title.keybindbundles.confirm_deletion"), (Component)Component.translatable((String)"message.keybindbundles.confirm_deletion"))), (Component)Component.translatable((String)"button.keybindbundles.delete")));
        deleteButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.keybindbundles.delete_bundle")));
    }

    public void onClose() {
        KeyBindBundleManager.write();
        currentlySelecting = null;
        super.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int element;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.getTitle(), this.width / 2 - this.font.width((FormattedText)this.getTitle()) / 2, 10, -1);
        boolean render = Minecraft.getInstance().screen == this;
        this.renderer.render(guiGraphics, render);
        if (render && (element = this.renderer.getElementUnderMouse(true)) >= 0 && element < this.entries.size() - 1) {
            guiGraphics.renderTooltip(this.font, TOOLTIPS, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int element = this.renderer.getElementUnderMouse(true);
        if (element < 0) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (element == this.entries.size() - 1) {
            currentlySelecting = this.bundle;
            Minecraft.getInstance().setScreen((Screen)new KeyBindsScreen((Screen)this, Minecraft.getInstance().options));
        } else if (button == 0) {
            if (Screen.hasShiftDown()) {
                if (this.bundle.getBookmark() == element) {
                    this.bundle.setBookmark(-1);
                }
                this.entries.remove(element);
                this.bundle.getEntries().remove(element);
            } else {
                KeyMapping key = KeyMappingUtil.getByName(this.bundle.getEntries().get(element).key());
                Minecraft.getInstance().pushGuiLayer((Screen)new EditKeyScreen(element, (Component)(key == null ? Component.empty() : Component.translatable((String)"title.keybindbundles.editing_key", (Object[])new Object[]{key.kbb$getDisplayName().copy().withStyle(ChatFormatting.GOLD)}))));
            }
        } else {
            int newPos;
            if (Screen.hasShiftDown()) {
                newPos = element - 1;
                if (newPos < 0) {
                    newPos = this.bundle.getEntries().size() - 1;
                }
            } else {
                newPos = element + 1;
                if (newPos >= this.bundle.getEntries().size()) {
                    newPos = 0;
                }
            }
            Collections.swap(this.entries, element, newPos);
            Collections.swap(this.bundle.getEntries(), element, newPos);
        }
        return true;
    }

    static {
        ADD_ENTRY = new KeyBindBundle.KeyEntry("add", "Add Entry", ItemStack.EMPTY);
        TOOLTIPS = List.of(Component.translatable((String)"tooltip.keybindbundles.bundle.edit_entry"), Component.translatable((String)"tooltip.keybindbundles.bundle.delete_entry"), Component.translatable((String)"tooltip.keybindbundles.bundle.move_clockwise"), Component.translatable((String)"tooltip.keybindbundles.bundle.move_counterclockwise"));
        CROSS_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/cross_button"), ResourceLocation.withDefaultNamespace((String)"widget/cross_button_highlighted"));
    }

    public class EditKeyScreen
    extends Screen {
        private final int key;
        private int middlePos;
        private EditBox title;
        private AutoCompleteEditBox<ItemStack> icon;

        protected EditKeyScreen(int key, Component title) {
            super(title);
            this.key = key;
        }

        protected void init() {
            Font font = Minecraft.getInstance().font;
            this.middlePos = this.height / 2 - 20;
            this.title = new EnterEditBox(font, this.width / 2 - 120, this.middlePos - 2 - 20, 240, 20, (Component)Component.translatable((String)"box.keybindbundles.key_title")){

                @Override
                protected void onEnter() {
                    EditKeyScreen.this.setFocused((GuiEventListener)EditKeyScreen.this.icon);
                }
            };
            this.title.setValue(this.getEntry().title());
            SearchTree<ItemStack> tree = SearchTreeManager.getSearchTree();
            this.icon = new AutoCompleteEditBox<ItemStack>(this, font, this.width / 2 - 120, this.middlePos + 2 + 9 + 2, 240, 20, 16, 18, 5, (Component)Component.translatable((String)"box.keybindbundles.key_icon_id"), tree, i -> i.getItemHolder().getKey().location()){

                @Override
                public void renderItem(GuiGraphics graphics, int x, int y, ItemStack item) {
                    graphics.renderItem(item, x, y);
                }
            };
            this.icon.setMaxLength(512);
            if (!this.getEntry().icon().isEmpty()) {
                this.icon.setValue(this.getEntry().icon().getItemHolder().getRegisteredName());
            }
            this.addRenderableWidget((GuiEventListener)this.title);
            this.addRenderableWidget((GuiEventListener)this.icon);
            this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_DONE, p -> this.onClose()).pos(this.width / 2 - 120, this.icon.autoComplete().getY() + this.icon.autoComplete().getHeight() + 10).size(240, 20).build());
            this.addRenderableWidget((GuiEventListener)this.icon.autoComplete());
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, this.getTitle(), this.width / 2 - font.width((FormattedText)this.getTitle()) / 2, 30, -1);
            MutableComponent title = Component.translatable((String)"box.keybindbundles.key_title");
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)title, this.width / 2 - font.width((FormattedText)title) / 2, this.middlePos - 2 - 20 - 2 - 9, -1);
            MutableComponent icon = Component.translatable((String)"box.keybindbundles.key_icon");
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)icon, this.width / 2 - font.width((FormattedText)icon) / 2, this.middlePos + 2, -1);
            if (!this.icon.getValue().isEmpty()) {
                ResourceLocation parsed = ResourceLocation.tryParse((String)this.icon.getValue());
                if (parsed == null) {
                    return;
                }
                Item item = (Item)BuiltInRegistries.ITEM.get(parsed);
                if (item != Items.AIR) {
                    guiGraphics.renderItem(item.getDefaultInstance(), this.icon.getX() + this.icon.getWidth() + 2, this.middlePos + 1 + 9 + 2 + 2);
                }
            }
        }

        public void onClose() {
            KeyBindBundle.KeyEntry old = this.getEntry();
            ResourceLocation parsed = ResourceLocation.tryParse((String)this.icon.getValue());
            KeyBindBundle.KeyEntry newEntry = new KeyBindBundle.KeyEntry(old.key(), this.title.getValue(), parsed == null ? ItemStack.EMPTY : ((Item)BuiltInRegistries.ITEM.get(parsed)).getDefaultInstance());
            KeyBundleModificationScreen.this.entries.set(this.key, newEntry);
            KeyBundleModificationScreen.this.bundle.getEntries().set(this.key, newEntry);
            Minecraft.getInstance().setScreen((Screen)KeyBundleModificationScreen.this);
        }

        public KeyBindBundle.KeyEntry getEntry() {
            return KeyBundleModificationScreen.this.entries.get(this.key);
        }

        protected class EnterEditBox
        extends EditBox {
            public EnterEditBox(Font font, int x, int y, int width, int height, Component message) {
                super(font, x, y, width, height, message);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257) {
                    this.onEnter();
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }

            protected void onEnter() {
                EditKeyScreen.this.onClose();
            }
        }
    }
}

