/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.network;

import glitchcore.config.ConfigSync;
import glitchcore.network.CustomPacket;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.FriendlyByteBuf;

public class SyncConfigPacket
implements CustomPacket<SyncConfigPacket> {
    private String path;
    private byte[] data;

    public SyncConfigPacket(String path, byte[] data) {
        this.path = path;
        this.data = data;
    }

    public SyncConfigPacket() {
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.path);
        buf.writeByteArray(this.data);
    }

    @Override
    public SyncConfigPacket decode(FriendlyByteBuf buf) {
        return new SyncConfigPacket(buf.readUtf(), buf.readByteArray());
    }

    @Override
    public void handle(SyncConfigPacket data, CustomPacket.Context context) {
        if (context.isServerSide()) {
            return;
        }
        ConfigSync.reload(data.path, new String(data.data, StandardCharsets.UTF_8));
    }

    @Override
    public CustomPacket.Phase getPhase() {
        return CustomPacket.Phase.CONFIGURATION;
    }
}

