/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.init.ArphexModItems;
import net.arphex.procedures.AscendantStaffItemIsCraftedsmeltedProcedure;
import net.arphex.procedures.VortexDevastatorEntitySwingsItemProcedure;
import net.arphex.procedures.VortexDevastatorRightclickedProcedure;
import net.arphex.procedures.VortexDevastatorToolInHandTickProcedure;
import net.arphex.procedures.VortexDevastatorToolInInventoryTickProcedure;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class VortexDevastatorItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 0;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_STONE_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public VortexDevastatorItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)3.0f, (float)-3.0f)).fireResistant());
    }

    @SubscribeEvent
    public static void handleToolDamage(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)ArphexModItems.VORTEX_DEVASTATOR.get(), builder -> builder.remove(DataComponents.MAX_DAMAGE));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        VortexDevastatorRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a74Provides devastating telekinetic abilities for both offense and defense"));
        list.add((Component)Component.literal((String)"- \u00a7dLeft click to shoot a vortex blast projectile, dealing devastating damage to any enemies near its collision position"));
        list.add((Component)Component.literal((String)"- \u00a79Right click to power jump in the direction you are moving, with fall immunity during cooldown"));
        list.add((Component)Component.literal((String)"Bonus: Crouch while holding to use the vortex shield - this shield has unlimited usage but recharges for a few seconds each time it blocks an attack"));
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        AscendantStaffItemIsCraftedsmeltedProcedure.execute((LevelAccessor)world, itemstack);
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        VortexDevastatorEntitySwingsItemProcedure.execute((Entity)entity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            VortexDevastatorToolInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
        VortexDevastatorToolInInventoryTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }
}

