/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.SpiderMothPortalRightclickedProcedure;
import net.arphex.procedures.SpiderMothSummonInventoryProcedure;
import net.arphex.procedures.SpiderMothSummonerEntitySwingsItemProcedure;
import net.arphex.procedures.SpiderMothSummonerItemInHandTickProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SpiderMothSummonerItem
extends Item {
    public SpiderMothSummonerItem() {
        super(new Item.Properties().stacksTo(64).fireResistant().rarity(Rarity.EPIC));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a74Spider Moth Container, an overwhelmingly powerful and nightmarish ally"));
        list.add((Component)Component.literal((String)"- \u00a7cRight click the ground to summon, or right click again to recall (one summon at a time per player - name follows item name)"));
        list.add((Component)Component.literal((String)"- Summon is rideable"));
        list.add((Component)Component.literal((String)"- \u00a7dLeft click while riding to wither nearby entities"));
        list.add((Component)Component.literal((String)"Bonus: Regenerates health while stored in item"));
        list.add((Component)Component.literal((String)"\u00a77Drops from Monstrous Spider Moth [DUNGEON BOSS]"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        SpiderMothPortalRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        SpiderMothSummonerEntitySwingsItemProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            SpiderMothSummonerItemInHandTickProcedure.execute(entity, itemstack);
        }
        SpiderMothSummonInventoryProcedure.execute(entity, itemstack);
    }
}

