/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.ChaosGauntletHeldProcedure;
import net.arphex.procedures.ForceGauntletEntitySwingsItemProcedure;
import net.arphex.procedures.ForceGauntletItemInInventoryTickProcedure;
import net.arphex.procedures.ForceGauntletItemIsCraftedsmeltedProcedure;
import net.arphex.procedures.ForceGauntletItemIsDroppedByPlayerProcedure;
import net.arphex.procedures.ForceGauntletRightclickedProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ChaosGauntletItem
extends Item {
    public ChaosGauntletItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 300;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a75Gauntlet with the power to control chaos and temporarily turn entities on each other"));
        list.add((Component)Component.literal((String)"- \u00a7dRight click towards an entity to control or remove control (purple particles) - Stronger mobs are less controllable, forcing an early cooldown and shorter control time - or unlimited time in creative mode (usable for mob battles)"));
        list.add((Component)Component.literal((String)"- \u00a7cLeft click towards an entity to set or remove it as a target (red particles). Control and targeting only work for entities that can have potion effects "));
        list.add((Component)Component.literal((String)"- \u00a7eHit the ground while crouching to clear nearby controls/targets"));
        list.add((Component)Component.literal((String)"Bonus: Hit ground to create a shockwave that knocks nearby mobs away"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        ForceGauntletRightclickedProcedure.execute((Entity)entity);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        ForceGauntletItemIsDroppedByPlayerProcedure.execute((Entity)entity);
        return retval;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        ForceGauntletEntitySwingsItemProcedure.execute((LevelAccessor)entity.level(), (Entity)entity);
        return retval;
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        ForceGauntletItemIsCraftedsmeltedProcedure.execute((LevelAccessor)world, itemstack);
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            ChaosGauntletHeldProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
        ForceGauntletItemInInventoryTickProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player entity) {
        ForceGauntletItemIsDroppedByPlayerProcedure.execute((Entity)entity);
        return true;
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        ForceGauntletItemIsDroppedByPlayerProcedure.execute((Entity)entity);
    }
}

