/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.AscendantStaffEntitySwingsItemProcedure;
import net.arphex.procedures.AscendantStaffItemIsCraftedsmeltedProcedure;
import net.arphex.procedures.AscendantStaffRightclickedProcedure;
import net.arphex.procedures.AscendantStaffToolInHandTickProcedure;
import net.arphex.procedures.AscendantStaffToolInInventoryTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AscendantStaffItem
extends Item {
    public AscendantStaffItem() {
        super(new Item.Properties().fireResistant().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState blockstate) {
        return 1.0f;
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        return true;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(2, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        AscendantStaffRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public int getEnchantmentValue() {
        return 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a7dStaff of levitation, providing fall immunity and temporary flight powers"));
        list.add((Component)Component.literal((String)"- \u00a7bRight click to levitate into the air (combine with ethereal staff in off-hand for unlimited flight)"));
        list.add((Component)Component.literal((String)"- \u00a7dEnemies attacked with the staff will levitate away, or left click in the air to shoot a levitation projectile dealing armour-piercing damage"));
        list.add((Component)Component.literal((String)"- \u00a7eHit the ground to create a temporary levitation trap "));
        list.add((Component)Component.literal((String)"Bonus: Immunity to levitation when held and not using the ability "));
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        AscendantStaffItemIsCraftedsmeltedProcedure.execute((LevelAccessor)world, itemstack);
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        AscendantStaffEntitySwingsItemProcedure.execute((LevelAccessor)entity.level(), (Entity)entity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            AscendantStaffToolInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
        AscendantStaffToolInInventoryTickProcedure.execute((LevelAccessor)world, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }
}

