/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.init;

import net.arphex.potion.AbFlightMobEffect;
import net.arphex.potion.AbyssalDetectorMobEffect;
import net.arphex.potion.BlockingEffectMobEffect;
import net.arphex.potion.BreathlessMobEffect;
import net.arphex.potion.ChaoLockMobEffect;
import net.arphex.potion.ChaosControlledMobEffect;
import net.arphex.potion.ChaosTargetMobEffect;
import net.arphex.potion.ConstrictedMobEffect;
import net.arphex.potion.CrawlingMobEffect;
import net.arphex.potion.DebugEffectMobEffect;
import net.arphex.potion.DespawnImmunityMobEffect;
import net.arphex.potion.DisplayTormentorInitialMobEffect;
import net.arphex.potion.EternalEvasionMobEffect;
import net.arphex.potion.EtherealChargeMobEffect;
import net.arphex.potion.FatigueShowMobEffect;
import net.arphex.potion.ForceLiftMobEffect;
import net.arphex.potion.ForcePowerMobEffect;
import net.arphex.potion.HealthAnalysisMobEffect;
import net.arphex.potion.InvincibilityTempMobEffect;
import net.arphex.potion.MothCurseMobEffect;
import net.arphex.potion.NecrosisMobEffect;
import net.arphex.potion.RepulsionMobEffect;
import net.arphex.potion.SpiderSilkTouchMobEffect;
import net.arphex.potion.ThunderSenseMobEffect;
import net.arphex.potion.TormentMobEffect;
import net.arphex.potion.TormentSpiralMobEffect;
import net.arphex.potion.TormentorPrimaryTargetMobEffect;
import net.arphex.potion.VoidCooldownMobEffect;
import net.arphex.potion.VoidProtectionMobEffect;
import net.arphex.potion.VoidRepulsionMobEffect;
import net.arphex.potion.VoidlasherChaosControlMobEffect;
import net.arphex.potion.VortexCooldownMobEffect;
import net.arphex.potion.WebbedMobEffect;
import net.arphex.potion.ZoomMobEffect;
import net.arphex.procedures.ChaosControlledEffectExpiresProcedure;
import net.arphex.procedures.ZoomEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class ArphexModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"arphex");
    public static final DeferredHolder<MobEffect, MobEffect> MOTH_CURSE = REGISTRY.register("moth_curse", () -> new MothCurseMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPIDER_SILK_TOUCH = REGISTRY.register("spider_silk_touch", () -> new SpiderSilkTouchMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> WEBBED = REGISTRY.register("webbed", () -> new WebbedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ABYSSAL_DETECTOR = REGISTRY.register("abyssal_detector", () -> new AbyssalDetectorMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> NECROSIS = REGISTRY.register("necrosis", () -> new NecrosisMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> THUNDER_SENSE = REGISTRY.register("thunder_sense", () -> new ThunderSenseMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> REPULSION = REGISTRY.register("repulsion", () -> new RepulsionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ZOOM = REGISTRY.register("zoom", () -> new ZoomMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FORCE_POWER = REGISTRY.register("force_power", () -> new ForcePowerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FORCE_LIFT = REGISTRY.register("force_lift", () -> new ForceLiftMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLOCKING_EFFECT = REGISTRY.register("blocking_effect", () -> new BlockingEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CHAOS_TARGET = REGISTRY.register("chaos_target", () -> new ChaosTargetMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CHAOS_CONTROLLED = REGISTRY.register("chaos_controlled", () -> new ChaosControlledMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VOID_PROTECTION = REGISTRY.register("void_protection", () -> new VoidProtectionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VOID_COOLDOWN = REGISTRY.register("void_cooldown", () -> new VoidCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ETHEREAL_CHARGE = REGISTRY.register("ethereal_charge", () -> new EtherealChargeMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INVINCIBILITY_TEMP = REGISTRY.register("invincibility_temp", () -> new InvincibilityTempMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VOID_REPULSION = REGISTRY.register("void_repulsion", () -> new VoidRepulsionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HEALTH_ANALYSIS = REGISTRY.register("health_analysis", () -> new HealthAnalysisMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VOIDLASHER_CHAOS_CONTROL = REGISTRY.register("voidlasher_chaos_control", () -> new VoidlasherChaosControlMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CONSTRICTED = REGISTRY.register("constricted", () -> new ConstrictedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VORTEX_COOLDOWN = REGISTRY.register("vortex_cooldown", () -> new VortexCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ETERNAL_EVASION = REGISTRY.register("eternal_evasion", () -> new EternalEvasionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> AB_FLIGHT = REGISTRY.register("ab_flight", () -> new AbFlightMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CHAO_LOCK = REGISTRY.register("chao_lock", () -> new ChaoLockMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CRAWLING = REGISTRY.register("crawling", () -> new CrawlingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FATIGUE_SHOW = REGISTRY.register("fatigue_show", () -> new FatigueShowMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DEBUG_EFFECT = REGISTRY.register("debug_effect", () -> new DebugEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TORMENT = REGISTRY.register("torment", () -> new TormentMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TORMENTOR_PRIMARY_TARGET = REGISTRY.register("tormentor_primary_target", () -> new TormentorPrimaryTargetMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TORMENT_SPIRAL = REGISTRY.register("torment_spiral", () -> new TormentSpiralMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DISPLAY_TORMENTOR_INITIAL = REGISTRY.register("display_tormentor_initial", () -> new DisplayTormentorInitialMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BREATHLESS = REGISTRY.register("breathless", () -> new BreathlessMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DESPAWN_IMMUNITY = REGISTRY.register("despawn_immunity", () -> new DespawnImmunityMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ArphexModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ArphexModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ZOOM)) {
            ZoomEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(CHAOS_TARGET)) {
            ChaosControlledEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(CHAOS_CONTROLLED)) {
            ChaosControlledEffectExpiresProcedure.execute(entity);
        }
    }
}

