/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.entity;

import net.arphex.entity.AntArsonistAlateQueenEntity;
import net.arphex.entity.AntArsonistEntity;
import net.arphex.entity.AntArsonistSoldierEntity;
import net.arphex.entity.AntArsonistWorkerEntity;
import net.arphex.procedures.OnGroundReturnProcedure;
import net.arphex.procedures.TermiteTunnelerAlateOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TermiteTunnelerAlateEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(TermiteTunnelerAlateEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(TermiteTunnelerAlateEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(TermiteTunnelerAlateEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public TermiteTunnelerAlateEntity(EntityType<TermiteTunnelerAlateEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"termitealate");
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<AntArsonistSoldierEntity>((PathfinderMob)this, AntArsonistSoldierEntity.class, 10.0f, 1.0, 1.2){

            public boolean canUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canContinueToUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false){

            public boolean canUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canContinueToUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AntArsonistEntity.class, true, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AntArsonistAlateQueenEntity.class, true, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AntArsonistWorkerEntity.class, true, true));
        this.goalSelector.addGoal(7, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canContinueToUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TermiteTunnelerAlateEntity.this.getX();
                double y = TermiteTunnelerAlateEntity.this.getY();
                double z = TermiteTunnelerAlateEntity.this.getZ();
                TermiteTunnelerAlateEntity entity = TermiteTunnelerAlateEntity.this;
                Level world = TermiteTunnelerAlateEntity.this.level();
                return super.canContinueToUse() && OnGroundReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(12, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.4f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:creepy_arthropod_tiny"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
    }

    public void baseTick() {
        super.baseTick();
        TermiteTunnelerAlateOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(0.96f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.15);
        builder = builder.add(Attributes.MAX_HEALTH, 25.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.2);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if ((event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) && this.onGround()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.termite.scurrying"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.termite.death"));
            }
            if (this.isInWaterOrBubble()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.termite.scurrying"));
            }
            if (this.isShiftKeyDown()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.termite.grab"));
            }
            if (!this.onGround()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.termite.flying"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.termite.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.termite.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 10) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 1, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 1, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 1, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

