/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.entity;

import java.util.List;
import net.arphex.init.ArphexModEntities;
import net.arphex.procedures.CheckOwnedProcedure;
import net.arphex.procedures.ConstrictingUpwardsProcedure;
import net.arphex.procedures.CrabFollowProcedure;
import net.arphex.procedures.CrabLarvaeEntityIsHurtProcedure;
import net.arphex.procedures.CrabLarvaeHitboxProcedure;
import net.arphex.procedures.CrabLarvaeOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrabLarvaeEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_grabbingtime = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_grabwait = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_sittingmode = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_crab_growth = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_following = SynchedEntityData.defineId(CrabLarvaeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public CrabLarvaeEntity(EntityType<CrabLarvaeEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"crablarvae");
        builder.define(DATA_grabbingtime, (Object)0);
        builder.define(DATA_grabwait, (Object)0);
        builder.define(DATA_sittingmode, (Object)false);
        builder.define(DATA_crab_growth, (Object)0);
        builder.define(DATA_following, (Object)true);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && CheckOwnedProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && CheckOwnedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && CheckOwnedProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && CheckOwnedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 40.0f){

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && CrabFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && CrabFollowProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.9, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 16.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 2.0, 40){

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabLarvaeEntity.this.getX();
                double y = CrabLarvaeEntity.this.getY();
                double z = CrabLarvaeEntity.this.getZ();
                CrabLarvaeEntity entity = CrabLarvaeEntity.this;
                Level world = CrabLarvaeEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new TryFindWaterGoal((PathfinderMob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:creepy_arthropod_large"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:creepy_arthropod_large"));
    }

    public boolean hurt(DamageSource source, float amount) {
        CrabLarvaeEntityIsHurtProcedure.execute((Entity)this);
        Entity immediatesourceentity = source.getDirectEntity();
        if (source.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putInt("Datagrabbingtime", ((Integer)this.entityData.get(DATA_grabbingtime)).intValue());
        compound.putInt("Datagrabwait", ((Integer)this.entityData.get(DATA_grabwait)).intValue());
        compound.putBoolean("Datasittingmode", ((Boolean)this.entityData.get(DATA_sittingmode)).booleanValue());
        compound.putInt("Datacrab_growth", ((Integer)this.entityData.get(DATA_crab_growth)).intValue());
        compound.putBoolean("Datafollowing", ((Boolean)this.entityData.get(DATA_following)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datagrabbingtime")) {
            this.entityData.set(DATA_grabbingtime, (Object)compound.getInt("Datagrabbingtime"));
        }
        if (compound.contains("Datagrabwait")) {
            this.entityData.set(DATA_grabwait, (Object)compound.getInt("Datagrabwait"));
        }
        if (compound.contains("Datasittingmode")) {
            this.entityData.set(DATA_sittingmode, (Object)compound.getBoolean("Datasittingmode"));
        }
        if (compound.contains("Datacrab_growth")) {
            this.entityData.set(DATA_crab_growth, (Object)compound.getInt("Datacrab_growth"));
        }
        if (compound.contains("Datafollowing")) {
            this.entityData.set(DATA_following, (Object)compound.getBoolean("Datafollowing"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        CrabLarvaeOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        CrabLarvaeEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return super.getDefaultDimensions(pose).scale((float)CrabLarvaeHitboxProcedure.execute((Entity)entity));
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        CrabLarvaeEntity retval = (CrabLarvaeEntity)((EntityType)ArphexModEntities.CRAB_LARVAE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return List.of().contains(stack.getItem());
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.35);
        builder = builder.add(Attributes.MAX_HEALTH, 200.0);
        builder = builder.add(Attributes.ARMOR, 5.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 8.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 70.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.scurrying"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.crabconstrictor.death"));
            }
            if (this.isShiftKeyDown()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.larvaegrab"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.crabconstrictor.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 90) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 5, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 5, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 5, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

