/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigurationSettingsConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> DWELLERS_REQUIRE_WEATHER;
    public static final ModConfigSpec.ConfigValue<Boolean> SPAWN_DWELLERS_NATURALLY;
    public static final ModConfigSpec.ConfigValue<Double> DWELLERS_FREQUENCY;
    public static final ModConfigSpec.ConfigValue<Boolean> DWELLERS_INCLUSION;
    public static final ModConfigSpec.ConfigValue<Double> NON_BOSS_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> RANDOM_SYSTEM_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Boolean> ALL_ENTITY_INCLUSION;
    public static final ModConfigSpec.ConfigValue<Double> MAX_ANTS;
    public static final ModConfigSpec.ConfigValue<Boolean> CRAWLING_ONLY;
    public static final ModConfigSpec.ConfigValue<Boolean> DISABLE_TORMENTOR;
    public static final ModConfigSpec.ConfigValue<Boolean> ANY_DIMENSION;
    public static final ModConfigSpec.ConfigValue<Boolean> TORMENTOR_INITIAL_SPAWNING;
    public static final ModConfigSpec.ConfigValue<Boolean> INSANITY_MODE;
    public static final ModConfigSpec.ConfigValue<Boolean> DWELLER_HEALTH;
    public static final ModConfigSpec.ConfigValue<Double> OVERALL_DIFFICULTY;
    public static final ModConfigSpec.ConfigValue<Double> OVERALL_DIFFICULTY_LOWER;
    public static final ModConfigSpec.ConfigValue<Double> TORMENTOR_MAX_HEALTH;
    public static final ModConfigSpec.ConfigValue<Double> TORMENTOR_HIT_SPEED;
    public static final ModConfigSpec.ConfigValue<Boolean> FRIENDLY_MODE;
    public static final ModConfigSpec.ConfigValue<Boolean> WELCOME_MESSAGE;
    public static final ModConfigSpec.ConfigValue<Boolean> STRUCTURE_GENERATION;
    public static final ModConfigSpec.ConfigValue<Boolean> SPECIAL_TORMENTOR_RENDERING;
    public static final ModConfigSpec.ConfigValue<String> BONUS_TORMENTOR_CHAT;
    public static final ModConfigSpec.ConfigValue<Double> LIMIT_TORMENTED_WRATH;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_ETHEREAL_WALL_BYPASS;
    public static final ModConfigSpec.ConfigValue<Boolean> ANT_QUEEN_OUTSIDE_DAMAGE;
    public static final ModConfigSpec.ConfigValue<Boolean> TORMENTOR_PARTICLES;
    public static final ModConfigSpec.ConfigValue<Boolean> TORMENTOR_SHADERS;

    static {
        BUILDER.push("Spawning");
        DWELLERS_REQUIRE_WEATHER = BUILDER.comment("This controls whether all boss versions will require specific weather conditions to spawn. Without this, they will appear much more frequently. ").define("Bosses require weather?", true);
        SPAWN_DWELLERS_NATURALLY = BUILDER.comment("Do you want the boss and clone versions to spawn naturally, or only from summoning structures?").define("Boss natural spawning", true);
        DWELLERS_FREQUENCY = BUILDER.comment("Bosses and variant spawns are rare by default. 1=twice as common. 2=default rarity. 3=twice as rare. 4=three times rarer. Avoid decimal and negative numbers.").define("Boss rarity", (Object)2.0);
        DWELLERS_INCLUSION = BUILDER.comment("This controls whether the stalker bosses (spider moth, scorpioid bloodluster, draconic voidlasher, tormentor) are included in general. Set to false if you only want the other mobs, and the bosses will become unable to be spawned in any way.").define("Boss inclusion", true);
        NON_BOSS_SPAWNRATE = BUILDER.comment("Controls the spawnrate of ALL non-boss mobs in this mod, including minibosses and all regular arthropods. Default multiplier value is 5. You could more than double the ArPhEx spawnrates by setting it to 2 or 1. Lower values = more spawns (minimum value is 1). No maximum rarity. Avoid decimal and negative numbers.").define("Non-boss global spawnrates", (Object)5.0);
        RANDOM_SYSTEM_SPAWNS = BUILDER.comment("ArPhEx has an additional spawning system that gives a 1 in (10) chance to spawn a random ArPhEx mob each time the natural spawn triggers. This system allows ArPhEx mobs to spawn in non-vanilla overworld biomes, while still accounting for mob rarity. Default number is 10, meaning it has a 1 in 10 chance to spawn each time. Setting it to 0 disables the additional spawning system entirely. Avoid decimal and negative numbers.").define("Random-system spawn rates", (Object)10.0);
        ALL_ENTITY_INCLUSION = BUILDER.comment("This value controls whether ArPhEx entities are included in general. Setting to false makes it impossible to spawn ArPhEx mobs, while keeping the items as usual. ").define("All entities enabled/disabled", true);
        MAX_ANTS = BUILDER.comment("Maximum colony tamed ants per player (furthest ants despawn, 20 default)").define("Max tamed ants per player", (Object)20.0);
        CRAWLING_ONLY = BUILDER.comment("Option to limit all natural ArPhEx spawning to the Crawling dimension. Note that you won't be able to craft a crawling compass, so a mod like traveller's compass is recommended").define("Crawling-restrict all mobs", false);
        DISABLE_TORMENTOR = BUILDER.comment("Specifically disables the Tormentor boss entirely. It will be unable to be spawned in any form if this is enabled.").define("Disable Tormentor", false);
        ANY_DIMENSION = BUILDER.comment("Disabled by default. If enabled, most mobs will become able to spawn in any dimension, including dimensions from other mods - may cause issues with some mod dimensions.").define("Spawn in other dimensions", false);
        TORMENTOR_INITIAL_SPAWNING = BUILDER.comment("By default, the Tormentor can spawn naturally once you defeat the first three bosses. At this point, you probably won't be ready yet to fight it, and so will be forced to seal it and locate a crawling portal (all intentional). Set to false to prevent this, and ensure the Tormentor can only spawn from being summoned. The earlier - Boss natural spawning - config option has the same effect, but also controls other bosses.").define("Tormentor initial natural spawning", true);
        INSANITY_MODE = BUILDER.comment("Do you want to massively amplify all ArPhEx spawns futher on top of the existing spawns? Enabling this will drastically amplfy random-system overworld spawns from the mod, and even add crawling dimension mobs like the spider ambusher into the overworld. Even the non-overworld bosses will spawn rarely in the overworld, except for the Tormentor (this must be summoned manually). Minibosses will spawn commonly. Perfect for fast-paced, intense gameplay!").define("Insanity Mode", false);
        BUILDER.pop();
        BUILDER.push("Difficulty");
        DWELLER_HEALTH = BUILDER.comment("By default, the stalker bosses have hundreds of health points. Choose true to decrease their maximum to just 60 health. Avoid decimal and negative numbers.").define("Boss easy-mode", false);
        OVERALL_DIFFICULTY = BUILDER.comment("Can increase damage for most ArPhEx mob, miniboss, and boss attacks. Affects their ranged projectiles too. Default value is 0. Positive values will give that level of strength to all arphex mobs. Avoid decimal and negative numbers, upper limit is 256. Does not affect Tormentor fight significantly.").define("Extra Difficulty Control", (Object)0.0);
        OVERALL_DIFFICULTY_LOWER = BUILDER.comment("Can lower damage for most ArPhEx mob, miniboss, and boss attacks. Affects their ranged projectiles too. Default value is 0. Positive values will give that level of weakness to all arphex mobs. Avoid decimal and negative numbers, upper limit is 256. Does not affect Tormentor fight significantly.").define("Lower Difficulty Control", (Object)0.0);
        TORMENTOR_MAX_HEALTH = BUILDER.comment("Option to make the TORMENTOR weaker by lowering its max heath to any specific value. Default and maximum value is 1024.").define("Tormentor Max Health", (Object)1024.0);
        TORMENTOR_HIT_SPEED = BUILDER.comment("Value is in ticks. Since 20 ticks equate to a second, the default 25 ticks gives the Tormentor 1.25 seconds of immunity after each time it takes damage.").define("Tormentor Damage Speed Limit", (Object)20.0);
        FRIENDLY_MODE = BUILDER.comment("With this mode enabled, all mobs from the mod become unable to target players for attack! For more peaceful gameplay, this is valuable. Full bosses such as the Tormentor and Voidlasher may not work fully, so you may want to disable them if using this setting").define("Friendly Mode", false);
        BUILDER.pop();
        BUILDER.push("Other");
        WELCOME_MESSAGE = BUILDER.comment("When you join a world for the first time with ArPhEx installed, it shows a welcome message, informing you about the wiki and showing that the mod is active. Set to false to disable.").define("Welcome message", true);
        STRUCTURE_GENERATION = BUILDER.comment("Allow structure generations? Without them you will need to cheat to access the lower Crawling dimension layers or get ant colonies and termite-related items. Some tiny elements may still generate.").define("Structure generation toggle", true);
        SPECIAL_TORMENTOR_RENDERING = BUILDER.comment("Keep enabled if you want to use the bonus rendering system for the Tormentor, featuring infinite render distance for the entity along with modifying fog distance accordingly, plus fog colour when nearby").define("Special Tormentor rendering", true);
        BONUS_TORMENTOR_CHAT = BUILDER.comment("The Tormentor can occasionally have a chance to respond to chat messages that mention its name, with a threatening message of its own. There are thirty possible messages. You can add one of your own with this setting.").define("Bonus Tormentor Chat Message", (Object)"I am here");
        LIMIT_TORMENTED_WRATH = BUILDER.comment("The Tormented Wrath is an explosive post-Tormentor weapon that can shoot more and more powerful explosives the more times its user has killed the final Tormentor boss. You can limit the charge level here (default is 200, matching with the maximum amount of Tormentor kills that can be registered)").define("Limit Tormented Wrath Power", (Object)200.0);
        ALLOW_ETHEREAL_WALL_BYPASS = BUILDER.comment("Disable to limit the staff's ability to walk through walls if it breaks something in your map or modpack").define("Allow Ethereal Staff wall bypassing", true);
        ANT_QUEEN_OUTSIDE_DAMAGE = BUILDER.comment("To encourage players to build a den for their ant queens, the queens are required to be under a roof, or take damage otherwise. Set to false to disable the damage").define("Ant Queen outside damage", true);
        TORMENTOR_PARTICLES = BUILDER.comment("Set to false to disable the Tormentor's cloud of particles. These can have a significant performance hit for some users.").define("Tormentor Particles", true);
        TORMENTOR_SHADERS = BUILDER.comment("Enable Tormentor's ability to add blurring and desaturation shaders when Tormenting").define("Tormentor Shaders", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

