/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.erodingstoneentities_common_forge.events;

import com.natamus.erodingstoneentities_common_forge.config.ConfigHandler;
import com.natamus.erodingstoneentities_common_forge.util.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ErodingEvent {
    private static final HashMap<Level, Integer> worldtickcount = new HashMap();
    private static final HashMap<Level, CopyOnWriteArrayList<ItemEntity>> perworldentities = new HashMap();
    private static final HashMap<ItemEntity, Integer> iecount = new HashMap();

    public static void onWorldTick(ServerLevel world) {
        if (!worldtickcount.containsKey(world)) {
            worldtickcount.put((Level)world, 1);
            return;
        }
        int currenttick = worldtickcount.get(world);
        if (currenttick % 20 != 0) {
            worldtickcount.put((Level)world, currenttick + 1);
            return;
        }
        worldtickcount.put((Level)world, 1);
        if (!perworldentities.containsKey(world)) {
            return;
        }
        if (perworldentities.get(world).size() > 0) {
            for (ItemEntity ie : perworldentities.get(world)) {
                Block belowblock;
                int level;
                if (!ie.isAlive()) {
                    perworldentities.get(world).remove(ie);
                    iecount.remove(ie);
                    continue;
                }
                int timeleft = iecount.get(ie);
                BlockPos iepos = ie.blockPosition();
                BlockState ieposstate = world.getBlockState(iepos);
                if (!ieposstate.getBlock().equals(Blocks.WATER) || (level = ((Integer)ieposstate.getValue((Property)LiquidBlock.LEVEL)).intValue()) <= 0 || ConfigHandler.preventErosionIfAboveIceBlock && Util.isIceBlock(belowblock = world.getBlockState(iepos.below()).getBlock())) continue;
                if (--timeleft == 0) {
                    perworldentities.get(world).remove(ie);
                    iecount.remove(ie);
                    Util.transformItemEntity((Level)world, ie);
                    continue;
                }
                iecount.put(ie, timeleft);
            }
        }
    }

    public static void onEntityJoin(Level world, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity ie = (ItemEntity)entity;
        ItemStack stack = ie.getItem();
        if (!Util.erodeinto.containsKey(stack.getItem())) {
            return;
        }
        if (!perworldentities.containsKey(world)) {
            perworldentities.put(world, new CopyOnWriteArrayList<ItemEntity>(Arrays.asList(ie)));
        } else {
            perworldentities.get(world).add(ie);
        }
        iecount.put(ie, ConfigHandler.durationInSecondsStoneErodes);
    }
}

