/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.collections;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public class Long2ObjectConcurrentOpenHashMap<V>
extends AbstractLong2ObjectMap<V> {
    private static final long serialVersionUID = -1613277332850521333L;
    private static final int MAX_SEGMENTS = 65536;
    protected transient Segment<V>[] segments;
    protected transient int segmentShift;
    protected transient int segmentMask;
    protected transient Long2ObjectMap.FastEntrySet<V> entrySet;
    protected transient LongSet keySet;
    protected transient ObjectCollection<V> values;
    protected Long2ObjectMap<V> syncer;
    protected Long2ObjectMap<V> unwrapped;

    public static <V> Long2ObjectConcurrentOpenHashMap<V> copyOrSelf(Long2ObjectMap<V> map) {
        if (map instanceof Long2ObjectConcurrentOpenHashMap) {
            return (Long2ObjectConcurrentOpenHashMap)map;
        }
        Long2ObjectConcurrentOpenHashMap<V> result = new Long2ObjectConcurrentOpenHashMap<V>(map);
        result.syncer = Long2ObjectMaps.synchronize(map);
        result.unwrapped = map;
        return result;
    }

    public Long2ObjectMap<V> getSyncer() {
        return this.unwrapped;
    }

    protected Long2ObjectConcurrentOpenHashMap(boolean unused) {
    }

    public Long2ObjectConcurrentOpenHashMap() {
        this(16, 0.75f, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(int minCapacity) {
        this(minCapacity, 0.75f, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(int minCapacity, float loadFactor) {
        this(minCapacity, loadFactor, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(int minCapacity, int concurrencyLevel) {
        this(minCapacity, 0.75f, concurrencyLevel);
    }

    public Long2ObjectConcurrentOpenHashMap(float loadFactor, int concurrencyLevel) {
        this(16, loadFactor, concurrencyLevel);
    }

    public Long2ObjectConcurrentOpenHashMap(int minCapacity, float loadFactor, int concurrencyLevel) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalStateException("Load Factor is not between 0 and 1");
        }
        if (concurrencyLevel <= 0 || concurrencyLevel >= 65536) {
            throw new IllegalStateException("concurrencyLevel has to be between 0 and 65536");
        }
        int segmentCount = HashCommon.nextPowerOfTwo((int)concurrencyLevel);
        int shift = Integer.numberOfTrailingZeros(segmentCount);
        this.segments = new Segment[segmentCount];
        this.segmentShift = 32 - shift;
        this.segmentMask = segmentCount - 1;
        int segmentCapacity = minCapacity / segmentCount;
        if (segmentCapacity * segmentCount < minCapacity) {
            ++segmentCapacity;
        }
        segmentCapacity = HashCommon.arraySize((int)segmentCapacity, (float)loadFactor);
        for (int i = 0; i < segmentCount; ++i) {
            this.segments[i] = new Segment(this, segmentCapacity, loadFactor, i == 0);
        }
    }

    public Long2ObjectConcurrentOpenHashMap(Long[] keys, V[] values) {
        this(keys, values, 0.75f, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(Long[] keys, V[] values, float loadFactor) {
        this(keys, values, loadFactor, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(Long[] keys, V[] values, int concurrencyLevel) {
        this(keys, values, 0.75f, concurrencyLevel);
    }

    public Long2ObjectConcurrentOpenHashMap(Long[] keys, V[] values, float loadFactor, int concurrencyLevel) {
        this(keys.length, loadFactor, concurrencyLevel);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        int m = keys.length;
        for (int i = 0; i < m; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public Long2ObjectConcurrentOpenHashMap(long[] keys, V[] values) {
        this(keys, values, 0.75f, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(long[] keys, V[] values, float loadFactor) {
        this(keys, values, loadFactor, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(long[] keys, V[] values, int concurrencyLevel) {
        this(keys, values, 0.75f, concurrencyLevel);
    }

    public Long2ObjectConcurrentOpenHashMap(long[] keys, V[] values, float loadFactor, int concurrencyLevel) {
        this(keys.length, loadFactor, concurrencyLevel);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        int m = keys.length;
        for (int i = 0; i < m; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public Long2ObjectConcurrentOpenHashMap(Map<? extends Long, ? extends V> map) {
        this(map, 0.75f, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(Map<? extends Long, ? extends V> map, float loadFactor) {
        this(map, loadFactor, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(Map<? extends Long, ? extends V> map, int concurrencyLevel) {
        this(map, 0.75f, concurrencyLevel);
    }

    public Long2ObjectConcurrentOpenHashMap(Map<? extends Long, ? extends V> map, float loadFactor, int concurrencyLevel) {
        this(map.size(), loadFactor, concurrencyLevel);
        this.putAll(map);
    }

    public Long2ObjectConcurrentOpenHashMap(Long2ObjectMap<V> map) {
        this(map, 0.75f, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(Long2ObjectMap<V> map, float loadFactor) {
        this(map, loadFactor, 4);
    }

    public Long2ObjectConcurrentOpenHashMap(Long2ObjectMap<V> map, int concurrencyLevel) {
        this(map, 0.75f, concurrencyLevel);
    }

    public Long2ObjectConcurrentOpenHashMap(Long2ObjectMap<V> map, float loadFactor, int concurrencyLevel) {
        this(map.size(), loadFactor, concurrencyLevel);
        this.putAll((Map)map);
    }

    public V put(long key, V value) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).put(hash, key, value);
    }

    public V putIfAbsent(long key, V value) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).putIfAbsent(hash, key, value);
    }

    public V remove(long key) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).remove(hash, key);
    }

    public boolean remove(Object key, Object value) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).remove(hash, key, value);
    }

    public V get(long key) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).get(hash, key);
    }

    public V get(Object key) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).get(hash, key);
    }

    public V getOrDefault(long key, V defaultValue) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).getOrDefault(hash, key, defaultValue);
    }

    public void forEach(BiConsumer<? super Long, ? super V> consumer) {
        int m = this.segments.length;
        for (int i = 0; i < m; ++i) {
            this.segments[i].forEach(consumer);
        }
    }

    public boolean containsKey(long key) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).containsKey(hash, key);
    }

    public boolean replace(long key, V oldValue, V newValue) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).replace(hash, key, oldValue, newValue);
    }

    public V replace(long key, V value) {
        int hash = this.getHashCode(key);
        return this.getSegment(hash).replace(hash, key, value);
    }

    public V compute(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int hash = this.getHashCode(key);
        return this.getSegment(hash).compute(hash, key, remappingFunction);
    }

    public V computeIfAbsent(long key, Long2ObjectFunction<? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int hash = this.getHashCode(key);
        return this.getSegment(hash).computeIfAbsent(hash, key, mappingFunction);
    }

    public V computeIfPresent(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int hash = this.getHashCode(key);
        return this.getSegment(hash).computeIfPresent(hash, key, remappingFunction);
    }

    public V merge(long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int hash = this.getHashCode(key);
        return this.getSegment(hash).merge(hash, key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public void clear() {
        int m = this.segments.length;
        for (int i = 0; i < m; ++i) {
            this.segments[i].clear();
        }
        if (this.syncer != null) {
            this.syncer.clear();
        }
    }

    public boolean trim(int size) {
        int segmentCapacity = size / this.segments.length;
        if (segmentCapacity * this.segments.length < size) {
            ++segmentCapacity;
        }
        boolean result = false;
        int m = this.segments.length;
        for (int i = 0; i < m; ++i) {
            result |= this.segments[i].trim(segmentCapacity);
        }
        return result;
    }

    public void clearAndTrim(int size) {
        int segmentCapacity = size / this.segments.length;
        if (segmentCapacity * this.segments.length < size) {
            ++segmentCapacity;
        }
        int m = this.segments.length;
        for (int i = 0; i < m; ++i) {
            this.segments[i].clearAndTrim(segmentCapacity);
        }
        if (this.syncer != null) {
            this.syncer.clear();
        }
    }

    public boolean isEmpty() {
        int m = this.segments.length;
        for (int i = 0; i < m; ++i) {
            if (this.segments[i].size <= 0) continue;
            return false;
        }
        return true;
    }

    public int size() {
        long size = 0L;
        int m = this.segments.length;
        for (int i = 0; i < m; ++i) {
            size += (long)this.segments[i].size;
        }
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public ObjectSet<Long2ObjectMap.Entry<V>> long2ObjectEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new MapEntrySet();
        }
        return this.entrySet;
    }

    public LongSet keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    protected int getSegmentIndex(int hash) {
        return hash >>> this.segmentShift & this.segmentMask;
    }

    protected Segment<V> getSegment(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    protected int getHashCode(long key) {
        return HashCommon.mix((int)Long.hashCode(key));
    }

    protected int getHashCode(Object obj) {
        return HashCommon.mix((int)Objects.hashCode(obj));
    }

    protected static class Segment<V>
    extends StampedLock {
        private static final long serialVersionUID = -446894977795760975L;
        protected final Long2ObjectConcurrentOpenHashMap<V> map;
        protected transient long[] keys;
        protected transient V[] values;
        protected transient long[] links;
        protected int firstIndex = -1;
        protected int lastIndex = -1;
        protected transient boolean containsNull;
        protected transient int nullIndex;
        protected transient int maxFill;
        protected transient int mask;
        protected int size;
        protected transient int minCapacity;
        protected float loadFactor;

        protected Segment(Long2ObjectConcurrentOpenHashMap<V> map) {
            this.map = map;
        }

        protected Segment(Long2ObjectConcurrentOpenHashMap<V> map, int minCapacity, float loadFactor, boolean isNullContainer) {
            this.map = map;
            this.minCapacity = minCapacity;
            this.loadFactor = loadFactor;
            this.mask = minCapacity - 1;
            this.maxFill = Math.min((int)Math.ceil((float)minCapacity * loadFactor), minCapacity - 1);
            this.nullIndex = isNullContainer ? minCapacity : -1;
            int arraySize = minCapacity + (isNullContainer ? 1 : 0);
            this.keys = new long[arraySize];
            this.values = new Object[arraySize];
            this.links = new long[arraySize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Segment<V> copy(Long2ObjectConcurrentOpenHashMap<V> newMap) {
            long stamp = this.readLock();
            try {
                Segment<V> copy = new Segment<V>(newMap);
                copy.keys = Arrays.copyOf(this.keys, this.keys.length);
                copy.values = Arrays.copyOf(this.values, this.values.length);
                copy.links = Arrays.copyOf(this.links, this.links.length);
                copy.firstIndex = this.firstIndex;
                copy.lastIndex = this.lastIndex;
                copy.containsNull = this.containsNull;
                copy.nullIndex = this.nullIndex;
                copy.maxFill = this.maxFill;
                copy.mask = this.mask;
                copy.size = this.size;
                copy.minCapacity = this.minCapacity;
                copy.loadFactor = this.loadFactor;
                Segment<V> segment = copy;
                return segment;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        protected V getDefaultReturnValue() {
            return (V)this.map.defaultReturnValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V put(int hash, long key, V value) {
            long stamp = this.writeLock();
            try {
                int slot = this.findIndex(hash, key);
                if (slot < 0) {
                    this.insert(-slot - 1, key, value);
                    V v = this.getDefaultReturnValue();
                    return v;
                }
                V oldValue = this.values[slot];
                this.values[slot] = value;
                V v = oldValue;
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V putIfAbsent(int hash, long key, V value) {
            long stamp = this.writeLock();
            try {
                int slot = this.findIndex(hash, key);
                if (slot < 0) {
                    this.insert(-slot - 1, key, value);
                    V v = this.getDefaultReturnValue();
                    return v;
                }
                if (Objects.equals(this.values[slot], this.getDefaultReturnValue())) {
                    V oldValue = this.values[slot];
                    this.values[slot] = value;
                    V v = oldValue;
                    return v;
                }
                V v = this.values[slot];
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean containsKey(int hash, long key) {
            long stamp = this.readLock();
            try {
                boolean bl = this.findIndex(hash, key) >= 0;
                return bl;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        protected boolean containsKey(int hash, Object key) {
            long stamp = this.readLock();
            try {
                boolean bl = this.findIndex(hash, key) >= 0;
                return bl;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        protected boolean containsValue(Object value) {
            long stamp = this.readLock();
            try {
                int index = this.firstIndex;
                while (index != -1) {
                    if (Objects.equals(this.values[index], value)) {
                        boolean bl = true;
                        return bl;
                    }
                    index = (int)this.links[index];
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V get(int hash, long key) {
            long stamp = this.readLock();
            try {
                int slot = this.findIndex(hash, key);
                V v = slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
                return v;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V get(int hash, Object key) {
            long stamp = this.readLock();
            try {
                int slot = this.findIndex(hash, key);
                V v = slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
                return v;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V getOrDefault(int hash, long key, V defaultValue) {
            long stamp = this.readLock();
            try {
                int slot = this.findIndex(hash, key);
                V v = slot < 0 ? defaultValue : this.values[slot];
                return v;
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forEach(BiConsumer<? super Long, ? super V> consumer) {
            long stamp = this.readLock();
            try {
                int index = this.firstIndex;
                while (index != -1) {
                    consumer.accept(this.keys[index], this.values[index]);
                    index = (int)this.links[index];
                }
            }
            finally {
                this.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V remove(int hash, long key) {
            long stamp = this.writeLock();
            try {
                int slot = this.findIndex(hash, key);
                if (slot < 0) {
                    V v = this.getDefaultReturnValue();
                    return v;
                }
                V v = this.removeIndex(slot);
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V removeOrDefault(int hash, long key, V defaultValue) {
            long stamp = this.writeLock();
            try {
                int slot = this.findIndex(hash, key);
                if (slot < 0) {
                    V v = defaultValue;
                    return v;
                }
                V v = this.removeIndex(slot);
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V remove(int hash, Object key) {
            long stamp = this.writeLock();
            try {
                int slot = this.findIndex(hash, key);
                if (slot < 0) {
                    V v = this.getDefaultReturnValue();
                    return v;
                }
                V v = this.removeIndex(slot);
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean remove(int hash, long key, V value) {
            long stamp = this.writeLock();
            try {
                if (key == 0L) {
                    if (this.containsNull && Objects.equals(value, this.values[this.nullIndex])) {
                        this.removeNullIndex();
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                int pos = hash & this.mask;
                long current = this.keys[pos];
                if (current == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (current == key && Objects.equals(value, this.values[pos])) {
                    this.removeIndex(pos);
                    boolean bl = true;
                    return bl;
                }
                do {
                    ++pos;
                    current = this.keys[pos &= this.mask];
                    if (current != 0L) continue;
                    boolean bl = false;
                    return bl;
                } while (current != key || !Objects.equals(value, this.values[pos]));
                this.removeIndex(pos);
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean remove(int hash, Object key, Object value) {
            long stamp = this.writeLock();
            try {
                if (key == null || key instanceof Long && (Long)key == 0L) {
                    if (this.containsNull && Objects.equals(value, this.values[this.nullIndex])) {
                        this.removeNullIndex();
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                int pos = hash & this.mask;
                long current = this.keys[pos];
                if (current == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (Objects.equals(key, current) && Objects.equals(value, this.values[pos])) {
                    this.removeIndex(pos);
                    boolean bl = true;
                    return bl;
                }
                do {
                    ++pos;
                    current = this.keys[pos &= this.mask];
                    if (current != 0L) continue;
                    boolean bl = false;
                    return bl;
                } while (!Objects.equals(key, current) || !Objects.equals(value, this.values[pos]));
                this.removeIndex(pos);
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean replace(int hash, long key, V oldValue, V newValue) {
            long stamp = this.writeLock();
            try {
                int index = this.findIndex(hash, key);
                if (index < 0 || this.values[index] != oldValue) {
                    boolean bl = false;
                    return bl;
                }
                this.values[index] = newValue;
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V replace(int hash, long key, V value) {
            long stamp = this.writeLock();
            try {
                int index = this.findIndex(hash, key);
                if (index < 0) {
                    V v = this.getDefaultReturnValue();
                    return v;
                }
                V oldValue = this.values[index];
                this.values[index] = value;
                V v = oldValue;
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V compute(int hash, long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
            long stamp = this.writeLock();
            try {
                int index = this.findIndex(hash, key);
                if (index < 0) {
                    V newValue = remappingFunction.apply(key, this.getDefaultReturnValue());
                    if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                        V v = newValue;
                        return v;
                    }
                    this.insert(-index - 1, key, newValue);
                    V v = newValue;
                    return v;
                }
                V newValue = remappingFunction.apply(key, this.values[index]);
                if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                    this.removeIndex(index);
                    V v = newValue;
                    return v;
                }
                this.values[index] = newValue;
                V v = newValue;
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V computeIfAbsent(int hash, long key, Long2ObjectFunction<? extends V> mappingFunction) {
            long stamp = this.writeLock();
            try {
                int index = this.findIndex(hash, key);
                if (index < 0) {
                    Object newValue = mappingFunction.apply(key);
                    if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                        Object object = newValue;
                        return (V)object;
                    }
                    this.insert(-index - 1, key, newValue);
                    Object object = newValue;
                    return (V)object;
                }
                Object newValue = this.values[index];
                if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                    newValue = mappingFunction.apply(key);
                    if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                        Object object = newValue;
                        return object;
                    }
                    this.values[index] = newValue;
                }
                V v = newValue;
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V computeIfPresent(int hash, long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
            long stamp = this.writeLock();
            try {
                int index = this.findIndex(hash, key);
                if (index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue())) {
                    V v = this.getDefaultReturnValue();
                    return v;
                }
                V newValue = remappingFunction.apply(key, this.values[index]);
                if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                    this.removeIndex(index);
                    V v = newValue;
                    return v;
                }
                this.values[index] = newValue;
                V v = newValue;
                return v;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected V merge(int hash, long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            long stamp = this.writeLock();
            try {
                V newValue;
                int index = this.findIndex(hash, key);
                V v = newValue = index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? value : remappingFunction.apply(this.values[index], value);
                if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                    if (index >= 0) {
                        this.removeIndex(index);
                    }
                } else if (index < 0) {
                    this.insert(-index - 1, key, newValue);
                } else {
                    this.values[index] = newValue;
                }
                V v2 = newValue;
                return v2;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        protected void clear() {
            if (this.size == 0) {
                return;
            }
            long stamp = this.writeLock();
            try {
                this.size = 0;
                this.containsNull = false;
                Arrays.fill(this.keys, 0L);
                Arrays.fill(this.values, null);
                this.firstIndex = -1;
                this.lastIndex = -1;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean trim(int size) {
            int request = Math.max(this.minCapacity, HashCommon.nextPowerOfTwo((int)((int)Math.ceil((float)size / this.loadFactor))));
            if (request >= this.mask + 1 || this.size > Math.min((int)Math.ceil((float)request * this.loadFactor), request - 1)) {
                return false;
            }
            long stamp = this.writeLock();
            try {
                try {
                    this.rehash(request);
                }
                catch (OutOfMemoryError noMemory) {
                    boolean bl = false;
                    this.unlockWrite(stamp);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearAndTrim(int size) {
            int request = Math.max(this.minCapacity, HashCommon.nextPowerOfTwo((int)((int)Math.ceil((float)size / this.loadFactor))));
            if (request >= this.mask + 1) {
                this.clear();
                return;
            }
            long stamp = this.writeLock();
            try {
                if (this.nullIndex != -1) {
                    this.nullIndex = request;
                }
                this.mask = request - 1;
                this.maxFill = Math.min((int)Math.ceil((float)request * this.loadFactor), request - 1);
                int arraySize = request + (this.nullIndex != -1 ? 1 : 0);
                this.keys = new long[arraySize];
                this.values = new Object[arraySize];
                this.links = new long[arraySize];
                this.size = 0;
                this.firstIndex = -1;
                this.lastIndex = -1;
                this.containsNull = false;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        protected void insert(int slot, long key, V value) {
            if (slot == this.nullIndex) {
                this.containsNull = true;
            }
            this.keys[slot] = key;
            this.values[slot] = value;
            if (this.size == 0) {
                this.firstIndex = this.lastIndex = slot;
                this.links[slot] = -1L;
            } else {
                int n = this.lastIndex;
                this.links[n] = this.links[n] ^ (this.links[this.lastIndex] ^ (long)slot & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                this.links[slot] = ((long)this.lastIndex & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
                this.lastIndex = slot;
            }
            if (this.map.syncer != null) {
                this.map.syncer.put(key, value);
            }
            if (this.size++ >= this.maxFill) {
                this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.loadFactor));
            }
        }

        protected V removeIndex(int pos) {
            if (pos == this.nullIndex) {
                return this.containsNull ? this.removeNullIndex() : this.getDefaultReturnValue();
            }
            V value = this.values[pos];
            long key = this.keys[pos];
            this.keys[pos] = 0L;
            this.values[pos] = null;
            --this.size;
            this.onNodeRemoved(pos);
            this.shiftKeys(pos);
            if (this.map.syncer != null) {
                this.map.syncer.remove(key);
            }
            if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
                this.rehash(this.nullIndex / 2);
            }
            return value;
        }

        protected V removeNullIndex() {
            long key = this.keys[this.nullIndex];
            V value = this.values[this.nullIndex];
            this.containsNull = false;
            this.keys[this.nullIndex] = 0L;
            this.values[this.nullIndex] = null;
            --this.size;
            this.onNodeRemoved(this.nullIndex);
            if (this.map.syncer != null) {
                this.map.syncer.remove(key);
            }
            if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
                this.rehash(this.nullIndex / 2);
            }
            return value;
        }

        protected int findIndex(int hash, long key) {
            int pos;
            block4: {
                if (key == 0L) {
                    return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
                }
                pos = hash & this.mask;
                long current = this.keys[pos];
                if (current != 0L) {
                    if (current == key) {
                        return pos;
                    }
                    do {
                        ++pos;
                        current = this.keys[pos &= this.mask];
                        if (current == 0L) break block4;
                    } while (current != key);
                    return pos;
                }
            }
            return -(pos + 1);
        }

        protected int findIndex(int hash, Object key) {
            int pos;
            block5: {
                if (key == null) {
                    return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
                }
                if ((Long)key == 0L) {
                    return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
                }
                pos = hash & this.mask;
                long current = this.keys[pos];
                if (current != 0L) {
                    if (Objects.equals(key, current)) {
                        return pos;
                    }
                    do {
                        ++pos;
                        current = this.keys[pos &= this.mask];
                        if (current == 0L) break block5;
                    } while (!Objects.equals(key, current));
                    return pos;
                }
            }
            return -(pos + 1);
        }

        protected void shiftKeys(int startPos) {
            while (true) {
                long current;
                int last = startPos;
                startPos = last + 1 & this.mask;
                while (true) {
                    if ((current = this.keys[startPos]) == 0L) {
                        this.keys[last] = 0L;
                        this.values[last] = null;
                        return;
                    }
                    int slot = HashCommon.mix((int)Long.hashCode(current)) & this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= this.mask;
                }
                this.keys[last] = current;
                this.values[last] = this.values[startPos];
                this.onNodeMoved(startPos, last);
            }
        }

        protected void rehash(int newSize) {
            int newMask = newSize - 1;
            int arraySize = newSize + (this.nullIndex != -1 ? 1 : 0);
            long[] newKeys = new long[arraySize];
            Object[] newValues = new Object[arraySize];
            long[] newLinks = new long[arraySize];
            int i = this.firstIndex;
            int prev = -1;
            int newPrev = -1;
            this.firstIndex = -1;
            int j = this.size;
            while (j-- != 0) {
                int pos;
                if (this.keys[i] == 0L) {
                    pos = newSize;
                } else {
                    pos = HashCommon.mix((int)Long.hashCode(this.keys[i])) & newMask;
                    while (newKeys[pos] != 0L) {
                        ++pos;
                        pos &= newMask;
                    }
                }
                newKeys[pos] = this.keys[i];
                newValues[pos] = this.values[i];
                if (prev != -1) {
                    int n = newPrev;
                    newLinks[n] = newLinks[n] ^ (newLinks[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                    int n2 = pos;
                    newLinks[n2] = newLinks[n2] ^ (newLinks[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                    newPrev = pos;
                } else {
                    newPrev = this.firstIndex = pos;
                    newLinks[pos] = -1L;
                }
                prev = i;
                i = (int)this.links[prev];
            }
            this.links = newLinks;
            this.lastIndex = newPrev;
            if (newPrev != -1) {
                int n = newPrev;
                newLinks[n] = newLinks[n] | 0xFFFFFFFFL;
            }
            if (this.nullIndex != -1) {
                this.nullIndex = newSize;
            }
            this.mask = newMask;
            this.maxFill = Math.min((int)Math.ceil((float)newSize * this.loadFactor), newSize - 1);
            this.keys = newKeys;
            this.values = newValues;
        }

        protected void onNodeRemoved(int pos) {
            if (this.size == 0) {
                this.lastIndex = -1;
                this.firstIndex = -1;
            } else if (this.firstIndex == pos) {
                this.firstIndex = (int)this.links[pos];
                if (0 <= this.firstIndex) {
                    int n = this.firstIndex;
                    this.links[n] = this.links[n] | 0xFFFFFFFF00000000L;
                }
            } else if (this.lastIndex == pos) {
                this.lastIndex = (int)(this.links[pos] >>> 32);
                if (0 <= this.lastIndex) {
                    int n = this.lastIndex;
                    this.links[n] = this.links[n] | 0xFFFFFFFFL;
                }
            } else {
                long link = this.links[pos];
                int prev = (int)(link >>> 32);
                int next = (int)link;
                int n = prev;
                this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = next;
                this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
            }
        }

        protected void onNodeMoved(int from, int to) {
            if (this.size == 1) {
                this.firstIndex = this.lastIndex = to;
                this.links[to] = -1L;
            } else if (this.firstIndex == from) {
                this.firstIndex = to;
                int n = (int)this.links[from];
                this.links[n] = this.links[n] ^ (this.links[(int)this.links[from]] ^ ((long)to & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                this.links[to] = this.links[from];
            } else if (this.lastIndex == from) {
                this.lastIndex = to;
                int n = (int)(this.links[from] >>> 32);
                this.links[n] = this.links[n] ^ (this.links[(int)(this.links[from] >>> 32)] ^ (long)to & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                this.links[to] = this.links[from];
            } else {
                long link = this.links[from];
                int prev = (int)(link >>> 32);
                int next = (int)link;
                int n = prev;
                this.links[n] = this.links[n] ^ (this.links[prev] ^ (long)to & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = next;
                this.links[n2] = this.links[n2] ^ (this.links[next] ^ ((long)to & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                this.links[to] = link;
            }
        }
    }

    private class MapEntrySet
    extends AbstractObjectSet<Long2ObjectMap.Entry<V>>
    implements Long2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        public ObjectBidirectionalIterator<Long2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        public ObjectBidirectionalIterator<Long2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(Consumer<? super Long2ObjectMap.Entry<V>> action) {
            int m = Long2ObjectConcurrentOpenHashMap.this.segments.length;
            for (int i = 0; i < m; ++i) {
                Segment seg = Long2ObjectConcurrentOpenHashMap.this.segments[i];
                long stamp = seg.readLock();
                try {
                    int index = seg.firstIndex;
                    while (index != -1) {
                        action.accept(new ValueMapEntry(Long2ObjectConcurrentOpenHashMap.this, index, i));
                        index = (int)seg.links[index];
                    }
                    continue;
                }
                finally {
                    seg.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fastForEach(Consumer<? super Long2ObjectMap.Entry<V>> action) {
            MapEntry entry = new MapEntry();
            int m = Long2ObjectConcurrentOpenHashMap.this.segments.length;
            for (int i = 0; i < m; ++i) {
                Segment seg = Long2ObjectConcurrentOpenHashMap.this.segments[i];
                long stamp = seg.readLock();
                try {
                    int index = seg.firstIndex;
                    while (index != -1) {
                        entry.set(index, i);
                        action.accept(entry);
                        index = (int)seg.links[index];
                    }
                    continue;
                }
                finally {
                    seg.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public boolean contains(Object o) {
            block10: {
                if (o instanceof Map.Entry) {
                    if (o instanceof Long2ObjectMap.Entry) {
                        Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)o;
                        long key = entry.getLongKey();
                        int hash = Long2ObjectConcurrentOpenHashMap.this.getHashCode(key);
                        Segment seg = Long2ObjectConcurrentOpenHashMap.this.getSegment(hash);
                        long stamp = seg.readLock();
                        try {
                            int index = seg.findIndex(hash, key);
                            if (index >= 0) {
                                boolean bl = Objects.equals(entry.getValue(), seg.values[index]);
                                return bl;
                            }
                            break block10;
                        }
                        finally {
                            seg.unlockRead(stamp);
                        }
                    }
                    Map.Entry entry = (Map.Entry)o;
                    int hash = Long2ObjectConcurrentOpenHashMap.this.getHashCode(entry.getKey());
                    Segment seg = Long2ObjectConcurrentOpenHashMap.this.getSegment(hash);
                    long stamp = seg.readLock();
                    try {
                        int index = seg.findIndex(hash, entry.getKey());
                        if (index >= 0) {
                            boolean bl = Objects.equals(entry.getValue(), seg.values[index]);
                            return bl;
                        }
                    }
                    finally {
                        seg.unlockRead(stamp);
                    }
                }
            }
            return false;
        }

        @Deprecated
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Long2ObjectMap.Entry) {
                    Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)o;
                    return Long2ObjectConcurrentOpenHashMap.this.remove(entry.getLongKey(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)o;
                return Long2ObjectConcurrentOpenHashMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        public int size() {
            return Long2ObjectConcurrentOpenHashMap.this.size();
        }

        public void clear() {
            Long2ObjectConcurrentOpenHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractLongSet
    implements LongSet {
        private KeySet() {
        }

        public boolean add(long key) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(long e) {
            return Long2ObjectConcurrentOpenHashMap.this.containsKey(e);
        }

        public boolean remove(long o) {
            int oldSize = this.size();
            Long2ObjectConcurrentOpenHashMap.this.remove(o);
            return this.size() != oldSize;
        }

        public LongBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Long2ObjectConcurrentOpenHashMap.this.size();
        }

        public void clear() {
            Long2ObjectConcurrentOpenHashMap.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(LongConsumer action) {
            Objects.requireNonNull(action);
            for (Segment seg : Long2ObjectConcurrentOpenHashMap.this.segments) {
                long stamp = seg.readLock();
                try {
                    int index = seg.firstIndex;
                    while (index != -1) {
                        action.accept(seg.keys[index]);
                        index = (int)seg.links[index];
                    }
                }
                finally {
                    seg.unlockRead(stamp);
                }
            }
        }
    }

    private class Values
    extends AbstractObjectCollection<V> {
        private Values() {
        }

        @Deprecated
        public boolean contains(Object e) {
            return Long2ObjectConcurrentOpenHashMap.this.containsValue(e);
        }

        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        public ObjectIterator<V> iterator() {
            return new ValueIterator();
        }

        public int size() {
            return Long2ObjectConcurrentOpenHashMap.this.size();
        }

        public void clear() {
            Long2ObjectConcurrentOpenHashMap.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(Consumer<? super V> action) {
            Objects.requireNonNull(action);
            for (Segment seg : Long2ObjectConcurrentOpenHashMap.this.segments) {
                long stamp = seg.readLock();
                try {
                    int index = seg.firstIndex;
                    while (index != -1) {
                        action.accept(seg.values[index]);
                        index = (int)seg.links[index];
                    }
                }
                finally {
                    seg.unlockRead(stamp);
                }
            }
        }
    }

    protected class MapEntry
    implements Long2ObjectMap.Entry<V>,
    Map.Entry<Long, V> {
        int index = -1;
        int segmentIndex = -1;

        public MapEntry() {
        }

        public MapEntry(int index, int segmentIndex) {
            this.set(index, segmentIndex);
        }

        public void set(int index, int segmentIndex) {
            this.index = index;
            this.segmentIndex = segmentIndex;
        }

        public void clear() {
            this.index = -1;
            this.segmentIndex = -1;
        }

        public long getLongKey() {
            return Long2ObjectConcurrentOpenHashMap.this.segments[this.segmentIndex].keys[this.index];
        }

        @Override
        public V getValue() {
            return Long2ObjectConcurrentOpenHashMap.this.segments[this.segmentIndex].values[this.index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V setValue(V value) {
            Segment seg = Long2ObjectConcurrentOpenHashMap.this.segments[this.segmentIndex];
            long stamp = seg.writeLock();
            try {
                Object oldValue = seg.values[this.index];
                seg.values[this.index] = value;
                Object v = oldValue;
                return v;
            }
            finally {
                seg.unlockWrite(stamp);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Long2ObjectMap.Entry) {
                    Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)obj;
                    return this.getLongKey() == entry.getLongKey() && Objects.equals(this.getValue(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return key instanceof Long && this.getLongKey() == ((Long)key).longValue() && Objects.equals(this.getValue(), value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.getLongKey()) ^ Objects.hashCode(this.getValue());
        }

        public String toString() {
            return Long.toString(this.getLongKey()) + "=" + Objects.toString(this.getValue());
        }
    }

    protected class ValueMapEntry
    extends MapEntry {
        protected long key;
        protected V value;

        public ValueMapEntry(Long2ObjectConcurrentOpenHashMap this$0, int index, int segmentIndex) {
            super(index, segmentIndex);
            this.key = this$0.segments[segmentIndex].keys[index];
            this.value = this$0.segments[segmentIndex].values[index];
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return super.setValue(value);
        }
    }

    private class MapIterator {
        int previous = -1;
        int next = -1;
        int current = -1;
        int previousSegment = -1;
        int nextSegment = -1;
        int currentSegment = this.getFirstSegment();

        MapIterator() {
            if (this.currentSegment != -1) {
                this.next = Long2ObjectConcurrentOpenHashMap.this.segments[this.currentSegment].firstIndex;
            }
        }

        public boolean hasNext() {
            return this.next != -1 || this.nextSegment != -1;
        }

        public boolean hasPrevious() {
            return this.previous != -1 || this.previousSegment != -1;
        }

        public int currentSegment() {
            return this.currentSegment;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.previousSegment != -1) {
                this.nextSegment = this.currentSegment;
                this.currentSegment = this.previousSegment;
                this.previousSegment = -1;
                this.next = this.current = Long2ObjectConcurrentOpenHashMap.this.segments[this.currentSegment].lastIndex;
            } else {
                if (this.next != -1) {
                    this.nextSegment = -1;
                }
                this.next = this.current = this.previous;
            }
            this.findPreviousIndex();
            return this.current;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextSegment != -1) {
                this.previousSegment = this.currentSegment;
                this.currentSegment = this.nextSegment;
                this.nextSegment = -1;
                this.previous = this.current = Long2ObjectConcurrentOpenHashMap.this.segments[this.currentSegment].firstIndex;
            } else {
                if (this.previous != -1) {
                    this.previousSegment = -1;
                }
                this.previous = this.current = this.next;
            }
            this.findNextIndex();
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            block17: {
                if (this.current == -1) {
                    throw new IllegalStateException();
                }
                Segment seg = Long2ObjectConcurrentOpenHashMap.this.segments[this.currentSegment];
                long stamp = seg.writeLock();
                try {
                    if (this.current == this.previous) {
                        this.findPreviousIndex();
                    } else {
                        this.findNextIndex();
                    }
                    --seg.size;
                    if (this.previous == -1) {
                        seg.firstIndex = this.next;
                    } else {
                        int n = this.previous;
                        seg.links[n] = seg.links[n] ^ (seg.links[this.previous] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                    }
                    if (this.next == -1) {
                        seg.lastIndex = this.previous;
                    } else {
                        int n = this.next;
                        seg.links[n] = seg.links[n] ^ (seg.links[this.next] ^ ((long)this.previous & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                    }
                    this.notifyDeletion(seg);
                    if (this.current == seg.nullIndex) {
                        this.current = -1;
                        seg.containsNull = false;
                        seg.keys[seg.nullIndex] = 0L;
                        seg.values[seg.nullIndex] = null;
                        break block17;
                    }
                    int startPos = this.current;
                    this.current = -1;
                    while (true) {
                        long current;
                        int last = startPos;
                        startPos = last + 1 & seg.mask;
                        while (true) {
                            if ((current = seg.keys[startPos]) == 0L) {
                                seg.keys[last] = 0L;
                                seg.values[last] = null;
                                return;
                            }
                            int slot = HashCommon.mix((int)Long.hashCode(current)) & seg.mask;
                            if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                            ++startPos;
                            startPos &= seg.mask;
                        }
                        seg.keys[last] = current;
                        seg.values[last] = seg.values[startPos];
                        if (this.next == startPos) {
                            this.next = last;
                        }
                        if (this.previous == startPos) {
                            this.previous = last;
                        }
                        seg.onNodeMoved(startPos, last);
                    }
                }
                finally {
                    seg.unlockWrite(stamp);
                }
            }
        }

        protected void notifyDeletion(Segment<V> seg) {
            if (seg.map.syncer != null) {
                seg.map.syncer.remove(seg.keys[this.current]);
            }
        }

        protected void findPreviousIndex() {
            this.previous = (int)(Long2ObjectConcurrentOpenHashMap.this.segments[this.currentSegment].links[this.current] >>> 32);
            if (this.previous == -1) {
                this.previousSegment = this.findPreviousSegment(this.currentSegment - 1);
            }
        }

        protected void findNextIndex() {
            this.next = (int)Long2ObjectConcurrentOpenHashMap.this.segments[this.currentSegment].links[this.current];
            if (this.next == -1) {
                this.nextSegment = this.findNextSegment(this.currentSegment + 1);
            }
        }

        private int getFirstSegment() {
            int m = Long2ObjectConcurrentOpenHashMap.this.segments.length;
            for (int i = 0; i < m; ++i) {
                if (Long2ObjectConcurrentOpenHashMap.this.segments[i].firstIndex == -1) continue;
                return i;
            }
            return -1;
        }

        private int findNextSegment(int index) {
            while (index < Long2ObjectConcurrentOpenHashMap.this.segments.length && Long2ObjectConcurrentOpenHashMap.this.segments[index].firstIndex == -1) {
                ++index;
            }
            return index >= Long2ObjectConcurrentOpenHashMap.this.segments.length ? -1 : index;
        }

        private int findPreviousSegment(int index) {
            while (index >= 0 && Long2ObjectConcurrentOpenHashMap.this.segments[index].lastIndex == -1) {
                --index;
            }
            return index >= 0 ? index : -1;
        }
    }

    private class KeyIterator
    extends MapIterator
    implements LongBidirectionalIterator {
        public long previousLong() {
            return this.entry(this.previousEntry(), this.currentSegment());
        }

        public long nextLong() {
            return this.entry(this.nextEntry(), this.currentSegment());
        }

        protected long entry(int entry, int segment) {
            return Long2ObjectConcurrentOpenHashMap.this.segments[segment].keys[entry];
        }
    }

    private class ValueIterator
    extends MapIterator
    implements ObjectBidirectionalIterator<V> {
        public V previous() {
            return this.entry(this.previousEntry(), this.currentSegment());
        }

        public V next() {
            return this.entry(this.nextEntry(), this.currentSegment());
        }

        protected V entry(int entry, int segment) {
            return Long2ObjectConcurrentOpenHashMap.this.segments[segment].values[entry];
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectBidirectionalIterator<Long2ObjectMap.Entry<V>> {
        MapEntry entry;

        public Long2ObjectMap.Entry<V> next() {
            this.entry = new ValueMapEntry(Long2ObjectConcurrentOpenHashMap.this, this.nextEntry(), this.currentSegment());
            return this.entry;
        }

        public Long2ObjectMap.Entry<V> previous() {
            this.entry = new ValueMapEntry(Long2ObjectConcurrentOpenHashMap.this, this.previousEntry(), this.currentSegment());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectBidirectionalIterator<Long2ObjectMap.Entry<V>> {
        MapEntry entry;

        public FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public Long2ObjectMap.Entry<V> next() {
            this.entry.set(this.nextEntry(), this.currentSegment());
            return this.entry;
        }

        public Long2ObjectMap.Entry<V> previous() {
            this.entry.set(this.previousEntry(), this.currentSegment());
            return this.entry;
        }
    }
}

