/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BiomeEntry;
import pregenerator.common.tracker.types.BlockEntry;
import pregenerator.common.tracker.types.EntityEntry;
import pregenerator.common.tracker.types.TileEntry;

public interface IWorldEntry {
    public Component getName(RegistryAccess var1);

    public ResourceLocation getKey(RegistryAccess var1);

    public int getCount();

    public void write(FriendlyByteBuf var1);

    public boolean canDelete(boolean var1);

    public int deleteWorld(WorldTracker var1, Player var2);

    public int deleteChunk(WorldTracker var1, long var2);

    public static int count(List<IWorldEntry> list) {
        int result = 0;
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            result += list.get(i).getCount();
        }
        return result;
    }

    public static Function<RegistryFriendlyByteBuf, IWorldEntry> byId(int id) {
        switch (id) {
            case 0: {
                return TileEntry::new;
            }
            case 1: {
                return EntityEntry::new;
            }
            case 2: {
                return BiomeEntry::new;
            }
            case 3: {
                return BlockEntry::new;
            }
        }
        throw new IllegalStateException("Unknown Type!");
    }

    public static List<IWorldEntry> byChunk(int id, LevelChunk chunk) {
        switch (id) {
            case 0: {
                return TileEntry.getChunk(chunk);
            }
            case 1: {
                return EntityEntry.getChunk(chunk);
            }
            case 2: {
                return BiomeEntry.getChunk(chunk);
            }
            case 3: {
                return BlockEntry.getChunk(chunk);
            }
        }
        throw new IllegalStateException("Unsupported Type");
    }

    public static List<IWorldEntry> byLevel(int id, ServerLevel level) {
        switch (id) {
            case 0: {
                return TileEntry.getLevel(level);
            }
            case 1: {
                return EntityEntry.getLevel(level);
            }
            case 3: {
                return BlockEntry.getLevel(level);
            }
        }
        throw new IllegalStateException("Unsupported Type");
    }
}

