/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class EntityEntry
extends BaseWorldEntry {
    public EntityEntry(int id, int count) {
        super(id, count);
    }

    public EntityEntry(FriendlyByteBuf buf) {
        super(buf);
    }

    public EntityType<?> getEntity() {
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.byId(this.id);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)BuiltInRegistries.ENTITY_TYPE.byId(id)));
    }

    @Override
    public Component getName(RegistryAccess registry) {
        return this.getEntity().getDescription();
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, Player player) {
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.byId(this.id);
        if (type == null) {
            return 0;
        }
        int[] count = new int[1];
        tracker.getWorld().getEntities().get((EntityTypeTest)type, AbortableIterationConsumer.forConsumer(T -> {
            T.discard();
            count[0] = count[0] + 1;
        }));
        return count[0];
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.byId(this.id);
        if (type == null) {
            return 0;
        }
        ServerLevel level = tracker.getWorld();
        ChunkPos pos = new ChunkPos(position);
        AABB box = AABB.encapsulatingFullBlocks((BlockPos)pos.getBlockAt(0, level.getMinBuildHeight(), 0), (BlockPos)pos.getBlockAt(16, level.getMaxBuildHeight(), 16));
        int[] count = new int[1];
        level.getEntities().get((EntityTypeTest)type, box, AbortableIterationConsumer.forConsumer(T -> {
            T.discard();
            count[0] = count[0] + 1;
        }));
        return count[0];
    }

    public static List<IWorldEntry> getLevel(ServerLevel level) {
        BaseWorldEntry.Counter<EntityType> counter = new BaseWorldEntry.Counter<EntityType>();
        level.getEntities().getAll().forEach(T -> {
            if (T instanceof Player) {
                return;
            }
            counter.add(T.getType());
        });
        return counter.map((T, C) -> new EntityEntry(BuiltInRegistries.ENTITY_TYPE.getId(T), C));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        Level level = chunk.getLevel();
        if (level instanceof ServerLevel) {
            BaseWorldEntry.Counter<EntityType> counter = new BaseWorldEntry.Counter<EntityType>();
            ((ServerLevel)level).getEntities().get(AABB.encapsulatingFullBlocks((BlockPos)chunk.getPos().getBlockAt(0, level.getMinBuildHeight(), 0), (BlockPos)chunk.getPos().getBlockAt(16, level.getMaxBuildHeight(), 16)), T -> {
                if (T instanceof Player) {
                    return;
                }
                counter.add(T.getType());
            });
            return counter.map((T, C) -> new EntityEntry(BuiltInRegistries.ENTITY_TYPE.getId(T), C));
        }
        return ObjectLists.emptyList();
    }
}

