/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;
import pregenerator.base.mixins.common.storage.RegionSectionCacheMixin;
import pregenerator.common.tracker.types.TileEntry;
import pregenerator.common.utils.misc.AverageCounter;
import pregenerator.common.utils.misc.TimeTracker;

public class WorldTracker {
    ServerLevel world;
    TimeTracker timer = new TimeTracker(40);
    AverageCounter blockUpdates = new AverageCounter(40);
    AverageCounter blockTicks = new AverageCounter(40);
    AverageCounter fluidTicks = new AverageCounter(40);
    TimeTracker averageLag = new TimeTracker(200);
    Long2ObjectMap<Optional<PoiSection>> pointsOfInterest;
    int loadedEntities = 0;
    int loadedBlockEntities = 0;
    int loadedTickingBlockEntities = 0;

    public WorldTracker(ServerLevel world) {
        this.world = world;
        this.pointsOfInterest = ((RegionSectionCacheMixin)world.getPoiManager()).getStorage();
        if (this.pointsOfInterest == null) {
            this.pointsOfInterest = new Long2ObjectOpenHashMap();
        }
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    public void start() {
        Object2IntMap state;
        this.timer.start();
        this.blockTicks.addMore(this.world.getBlockTicks().count());
        this.blockTicks.onFinished();
        this.fluidTicks.addMore(this.world.getFluidTicks().count());
        this.fluidTicks.onFinished();
        this.loadedEntities = 0;
        this.averageLag.start();
        if (this.world.getGameTime() % 20L == 0L) {
            this.loadedBlockEntities = 0;
            this.loadedTickingBlockEntities = 0;
            TileEntry.getBlockEntities(this.world, this::countTile);
        }
        this.averageLag.finish();
        NaturalSpawner.SpawnState spawnState = this.world.getChunkSource().getLastSpawnState();
        if (spawnState != null && (state = spawnState.getMobCategoryCounts()) != null) {
            IntIterator intIterator = state.values().iterator();
            while (intIterator.hasNext()) {
                int value = (Integer)intIterator.next();
                this.loadedEntities += value;
            }
        }
    }

    private void countTile(BlockEntity entity) {
        ++this.loadedBlockEntities;
        this.loadedTickingBlockEntities += entity.getBlockState().getTicker((Level)this.world, entity.getType()) != null ? 1 : 0;
    }

    public void stop() {
        this.timer.finish();
        this.blockUpdates.onFinished();
    }

    public void onBlockUpdate() {
        this.blockUpdates.addOne();
    }

    public long getAverageLag() {
        return this.timer.getAverage();
    }

    public List<LevelChunk> getChunks() {
        ObjectArrayList chunks = new ObjectArrayList();
        for (ChunkHolder holder : ((ChunkManagerMixin)this.world.getChunkSource().chunkMap).getLoadedChunks()) {
            ChunkResult entry = holder.getEntityTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK);
            if (!entry.isSuccess()) continue;
            chunks.add((LevelChunk)entry.orElse(null));
        }
        return chunks;
    }

    public LevelChunk getChunk(long chunkPos) {
        return this.world.getChunk(ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos));
    }

    public void writeTrackingData(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.world.dimension().location());
        buffer.writeVarLong(this.timer.getAverage());
        buffer.writeVarLong(this.timer.getLastValue());
        buffer.writeVarInt(this.world.getChunkSource().getLoadedChunksCount());
        buffer.writeVarInt(this.pointsOfInterest.size());
        buffer.writeVarInt(this.loadedBlockEntities);
        buffer.writeVarInt(this.loadedTickingBlockEntities);
        buffer.writeVarInt(this.loadedEntities);
        buffer.writeVarInt(this.blockUpdates.getLast());
        buffer.writeVarInt(this.blockUpdates.getAverage());
        buffer.writeVarInt(this.blockTicks.getLast());
        buffer.writeVarInt(this.blockTicks.getAverage());
        buffer.writeVarInt(this.fluidTicks.getLast());
        buffer.writeVarInt(this.fluidTicks.getAverage());
    }
}

