/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.common.tracker.DefaultServerTracker;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.utils.misc.AverageCounter;
import pregenerator.common.utils.misc.TimeTracker;

public class ServerTracker {
    public static ServerTracker INSTANCE = new DefaultServerTracker();
    TimeTracker timer = new TimeTracker(40);
    AverageCounter packets = new AverageCounter(40);
    Object2ObjectMap<ResourceKey<Level>, WorldTracker> trackers = new Object2ObjectLinkedOpenHashMap();
    boolean active = false;

    public void init() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public boolean toggle(boolean newValue) {
        if (this.disabled() == newValue) {
            this.active = newValue;
            return true;
        }
        return false;
    }

    public byte[] getProfilerData(ResourceKey<Level> type, Player player) {
        if (this.disabled()) {
            return new byte[0];
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarLong(this.timer.getAverage());
        Runtime runtime = Runtime.getRuntime();
        buf.writeLong(runtime.totalMemory());
        buf.writeLong(runtime.maxMemory());
        buf.writeLong(runtime.freeMemory());
        buf.writeVarInt(this.packets.getAverage());
        buf.writeVarInt(this.packets.getLast());
        buf.writeVarInt(this.trackers.size());
        for (Object2ObjectMap.Entry entry : this.trackers.object2ObjectEntrySet()) {
            buf.writeResourceLocation(((ResourceKey)entry.getKey()).location());
            buf.writeVarLong(((WorldTracker)entry.getValue()).getAverageLag());
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get(type);
        buf.writeBoolean(tracker != null);
        if (tracker != null) {
            tracker.writeTrackingData(buf);
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        return data;
    }

    public void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor world = event.getLevel();
        if (!(world instanceof Level)) {
            return;
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get((Object)((Level)world).dimension());
        if (tracker != null) {
            tracker.onBlockUpdate();
        }
    }

    public void onServerTick(ServerTickEvent event) {
        if (this.disabled()) {
            return;
        }
        if (event instanceof ServerTickEvent.Pre) {
            this.timer.start();
            this.packets.addMore(ServerLifecycleHooks.getCurrentServer().getPendingTasksCount());
            this.packets.onFinished();
            return;
        }
        this.timer.finish();
    }

    public void onWorldTick(LevelTickEvent event) {
        if (event.getLevel().isClientSide() || this.disabled()) {
            return;
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get((Object)event.getLevel().dimension());
        if (tracker != null) {
            if (event instanceof LevelTickEvent.Pre) {
                tracker.start();
                return;
            }
            tracker.stop();
        }
    }

    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            this.trackers.put((Object)server.dimension(), (Object)new WorldTracker(server));
        }
    }

    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        this.trackers.remove((Object)((Level)event.getLevel()).dimension());
    }

    protected boolean disabled() {
        return !this.active;
    }

    public Set<ResourceLocation> getAllDimensions() {
        ObjectOpenHashSet locations = new ObjectOpenHashSet();
        for (ResourceKey type : ServerLifecycleHooks.getCurrentServer().levelKeys()) {
            locations.add(type.location());
        }
        return locations;
    }

    public Set<ResourceLocation> getLoadedDimensions() {
        ObjectOpenHashSet locations = new ObjectOpenHashSet();
        for (ResourceKey type : this.trackers.keySet()) {
            locations.add(type.location());
        }
        return locations;
    }

    public WorldTracker getWorldTracker(ResourceKey<Level> dimension) {
        return (WorldTracker)this.trackers.get(dimension);
    }
}

