/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.base.api.TextUtil;

public class DiskTracker {
    public static DiskEntry generateStatistics() throws IOException {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path mainFolder = server.getWorldPath(LevelResource.ROOT).getParent();
        ObjectLinkedOpenHashSet mainFiles = new ObjectLinkedOpenHashSet(DiskTracker.getFolderPaths(mainFolder));
        mainFiles.removeIf(DiskTracker::isDimensionFolder);
        mainFiles.removeIf(DiskTracker::isVanillaFolder);
        DiskEntry root = new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.root"));
        root.addChild(DiskTracker.createDimensionStats(mainFolder));
        root.addChild(DiskTracker.createPlayerStats(mainFolder));
        DiskEntry misc = new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.misc"));
        misc.addChild(new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.configs"), DiskTracker.countFolder(mainFolder.resolve("serverconfig"))));
        misc.addChild(new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.datapacks"), DiskTracker.countFolder(mainFolder.resolve("datapacks"))));
        for (Path path : mainFiles) {
            misc.addChild(new DiskEntry((Component)TextUtil.literalPascal(path.getFileName().toString()), DiskTracker.countFolder(path)));
        }
        root.addChild(misc);
        return root;
    }

    private static DiskEntry createDimensionStats(Path mainPath) throws IOException {
        DiskEntry result = new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.dimensions"));
        result.addChild(DiskTracker.createDimensionStats(mainPath, (Component)TextUtil.dimension((ResourceKey<Level>)Level.OVERWORLD), true));
        result.addChild(DiskTracker.createDimensionStats(mainPath.resolve("DIM-1"), (Component)TextUtil.dimension((ResourceKey<Level>)Level.NETHER), false));
        result.addChild(DiskTracker.createDimensionStats(mainPath.resolve("DIM1"), (Component)TextUtil.dimension((ResourceKey<Level>)Level.END), false));
        if (Files.exists(mainPath.resolve("dimensions"), new LinkOption[0])) {
            for (NamedEntry entry : DiskTracker.getDimensions(mainPath.resolve("dimensions"))) {
                result.addChild(DiskTracker.createDimensionStats(entry.getPath(), entry.getName(), false));
            }
        }
        return result;
    }

    private static DiskEntry createDimensionStats(Path dimFolder, Component name, boolean overworld) throws IOException {
        DiskEntry result = new DiskEntry(name);
        for (NamedEntry entry : overworld ? DiskTracker.getOverworldFolders(dimFolder) : DiskTracker.getDimensionFolders(dimFolder)) {
            result.addChild(new DiskEntry(entry.getName(), DiskTracker.countFolder(entry.getPath())));
        }
        return result;
    }

    private static DiskEntry createPlayerStats(Path mainFolder) throws IOException {
        DiskEntry playerStats = new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.player_data"));
        playerStats.addChild(new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.advancements"), DiskTracker.countFolder(mainFolder.resolve("advancements"))));
        playerStats.addChild(new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.data"), DiskTracker.countFolder(mainFolder.resolve("playerdata"))));
        playerStats.addChild(new DiskEntry((Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.stats"), DiskTracker.countFolder(mainFolder.resolve("stats"))));
        return playerStats;
    }

    private static boolean isVanillaFolder(Path path) {
        String name = path.getFileName().toString();
        return name.equals("stats") || name.equals("advancements") || name.equals("playerdata") || name.equals("datapacks") || name.equals("serverconfig");
    }

    private static boolean isDimensionFolder(Path path) {
        String name = path.getFileName().toString();
        return name.startsWith("DIM") || name.equals("dimensions") || name.equals("data") || name.equals("entities") || name.equals("poi") || name.equals("region");
    }

    private static List<NamedEntry> getDimensions(Path basePath) throws IOException {
        ObjectArrayList entry = new ObjectArrayList();
        for (Path modFolder : Files.newDirectoryStream(basePath)) {
            String modId = modFolder.getFileName().toString();
            for (Path dimIdFolder : Files.newDirectoryStream(modFolder)) {
                entry.add(new NamedEntry(dimIdFolder, (Component)TextUtil.dimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)dimIdFolder.getFileName().toString())))));
            }
        }
        return entry;
    }

    private static List<NamedEntry> getOverworldFolders(Path path) {
        ObjectArrayList paths = new ObjectArrayList();
        for (String s : new String[]{"data", "entities", "poi", "region"}) {
            paths.add(new NamedEntry(path.resolve(s), (Component)TextUtil.translate("gui.chunk_pregen.disk_screen.folder.world." + s)));
        }
        return paths;
    }

    private static List<NamedEntry> getDimensionFolders(Path path) throws IOException {
        ObjectArrayList paths = new ObjectArrayList();
        for (Path file : Files.newDirectoryStream(path)) {
            String name = file.getFileName().toString();
            paths.add(new NamedEntry(file, (Component)(DiskTracker.isDimensionFolder(file) ? TextUtil.translate("gui.chunk_pregen.disk_screen.folder.world." + name) : TextUtil.literalPascal(name))));
        }
        return paths;
    }

    private static List<Path> getFolderPaths(Path path) throws IOException {
        ObjectArrayList paths = new ObjectArrayList();
        for (Path file : Files.newDirectoryStream(path)) {
            paths.add(file);
        }
        return paths;
    }

    private static Summary countFolder(Path path) throws IOException {
        Summary statistics = new Summary();
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        for (Path file : Files.walk(path, new FileVisitOption[0]).filter((Predicate<Path>)Predicates.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).toList()) {
            statistics.add(Files.size(file));
        }
        return statistics;
    }

    public static class DiskEntry {
        Component name;
        DiskEntry parent;
        Summary result;
        List<DiskEntry> children = new ObjectArrayList();

        private DiskEntry() {
            this.result = new Summary();
        }

        public DiskEntry(Component name) {
            this(name, new Summary());
        }

        public DiskEntry(Component name, Summary result) {
            this.name = name;
            this.result = result;
        }

        public void addChild(DiskEntry stats) {
            if (stats.result == null) {
                return;
            }
            this.result.add(stats.result);
            this.children.add(stats);
            stats.parent = this;
        }

        public List<DiskEntry> getChildren() {
            return this.children;
        }

        public void sort(Comparator<DiskEntry> sorter) {
            this.children.sort(sorter);
            for (DiskEntry entry : this.children) {
                entry.sort(sorter);
            }
        }

        public Component getName() {
            return this.name;
        }

        public double getTotalPercentage() {
            DiskEntry root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            return (double)this.result.getBytes() / (double)root.result.getBytes();
        }

        public double getPercentage() {
            return this.parent == null ? 1.0 : (double)this.result.getBytes() / (double)this.parent.result.getBytes();
        }

        public long getBytes() {
            return this.result.getBytes();
        }

        public int getFiles() {
            return this.result.getFileCount();
        }

        public Summary getResult() {
            return this.result;
        }

        public DiskEntry read(RegistryFriendlyByteBuf buf) {
            this.name = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
            this.result.read((FriendlyByteBuf)buf);
            int size = buf.readVarInt();
            for (int i = 0; i < size; ++i) {
                DiskEntry child = new DiskEntry().read(buf);
                this.children.add(child);
                child.parent = this;
            }
            return this;
        }

        public void write(RegistryFriendlyByteBuf buf) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.name);
            this.result.write((FriendlyByteBuf)buf);
            buf.writeVarInt(this.children.size());
            for (DiskEntry child : this.children) {
                child.write(buf);
            }
        }
    }

    public static class Summary {
        int fileCount;
        long bytes;

        public Summary() {
        }

        public Summary(int fileCount, long bytes) {
            this.fileCount = fileCount;
            this.bytes = bytes;
        }

        public void add(long bytes) {
            ++this.fileCount;
            this.bytes += bytes;
        }

        public void add(int count, long bytes) {
            this.fileCount += count;
            this.bytes += bytes;
        }

        public void add(Summary sum) {
            this.add(sum.getFileCount(), sum.getBytes());
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public long getBytes() {
            return this.bytes;
        }

        public void read(FriendlyByteBuf buffer) {
            this.fileCount = buffer.readVarInt();
            this.bytes = buffer.readVarLong();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeVarInt(this.fileCount);
            buffer.writeVarLong(this.bytes);
        }
    }

    private static class NamedEntry {
        Path path;
        Component name;

        public NamedEntry(Path path, Component name) {
            this.path = path;
            this.name = name;
        }

        public Component getName() {
            return this.name;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

