/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.common.structures.StructureRef;
import pregenerator.common.structures.StructureWorld;

public class StructureManager {
    public static final StructureManager INSTANCE = new StructureManager();

    @SubscribeEvent
    public synchronized void onChunkSave(ChunkDataEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        StructureWorld structure = StructureWorld.getStructures(level);
        if (structure == null) {
            return;
        }
        for (StructureStart start : event.getChunk().getAllStarts().values()) {
            structure.addStructure(level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)start.getStructure()), start);
        }
    }

    @SubscribeEvent
    public synchronized void onChunkLoad(ChunkEvent.Load load) {
        ChunkAccess chunk = load.getChunk();
        if (!(chunk instanceof LevelChunk)) {
            return;
        }
        Level world = ((LevelChunk)chunk).getLevel();
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            StructureWorld structure = StructureWorld.getStructures(server);
            if (structure == null) {
                return;
            }
            for (StructureStart start : chunk.getAllStarts().values()) {
                structure.addStructure(server.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)start.getStructure()), start);
            }
        }
    }

    public synchronized List<StructureRef> getTrackers(ResourceKey<Level> type) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return ObjectLists.emptyList();
        }
        ServerLevel world = server.getLevel(type);
        if (world == null) {
            return ObjectLists.emptyList();
        }
        ObjectArrayList trackers = new ObjectArrayList();
        StructureWorld structure = StructureWorld.getStructures(world);
        if (structure != null) {
            structure.getStructures(null, (Collection<StructureRef>)trackers);
        }
        return trackers;
    }
}

