/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import pregenerator.client.gui.ProgressScreen;
import pregenerator.client.helpers.IProgressListener;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;

public class ProgressPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, Start> START_CODEC = CustomPacketPayload.codec(Start::write, IPregenPacket.readPacket(Start::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Update> UPDATE_CODEC = CustomPacketPayload.codec(Update::write, IPregenPacket.readPacket(Update::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Complete> COMPLETE_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(Complete::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Cancel> CANCEL_CODEC = CustomPacketPayload.codec(Cancel::write, IPregenPacket.readPacket(Cancel::new));
    public static final CustomPacketPayload.Type<Start> START = IPregenPacket.createType("chunkpregen:progress_start");
    public static final CustomPacketPayload.Type<Update> UPDATE = IPregenPacket.createType("chunkpregen:progress_update");
    public static final CustomPacketPayload.Type<Complete> COMPLETE = IPregenPacket.createType("chunkpregen:progress_complete");
    public static final CustomPacketPayload.Type<Cancel> CANCEL = IPregenPacket.createType("chunkpregen:progress_cancel");

    public static class Complete
    implements IPregenPacket.IRequestPacket {
        public Complete() {
        }

        public Complete(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof IProgressListener) {
                ((IProgressListener)screen).onCompleted();
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return COMPLETE;
        }
    }

    public static class Cancel
    implements IPregenPacket {
        UUID taskId;

        public Cancel(UUID taskId) {
            this.taskId = taskId;
        }

        public Cancel(RegistryFriendlyByteBuf buffer) {
            this.taskId = buffer.readUUID();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeUUID(this.taskId);
        }

        @Override
        public void process(Player player) {
            ServerManager.INSTANCE.interruptMiniTask(this.taskId);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CANCEL;
        }
    }

    public static class Update
    implements IPregenPacket {
        long current;
        long max;

        public Update(long current, long max) {
            this.current = current;
            this.max = max;
        }

        public Update(RegistryFriendlyByteBuf buffer) {
            this.current = buffer.readVarLong();
            this.max = buffer.readVarLong();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarLong(this.current);
            buffer.writeVarLong(this.max);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof IProgressListener) {
                ((IProgressListener)screen).updateProgress(this.current, this.max);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return UPDATE;
        }
    }

    public static class Start
    implements IPregenPacket {
        long max;
        UUID taskId;
        Component message;

        public Start(long max, UUID taskId, Component message) {
            this.max = max;
            this.taskId = taskId;
            this.message = message;
        }

        public Start(RegistryFriendlyByteBuf buffer) {
            this.max = buffer.readVarLong();
            this.taskId = buffer.readUUID();
            this.message = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer);
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarLong(this.max);
            buffer.writeUUID(this.taskId);
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.message);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen((Screen)new ProgressScreen(mc.screen, this.taskId, this.max, this.message));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return START;
        }
    }
}

