/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.PregenMenu;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.misc.PregenAction;

public class CommandPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, Request> REQUEST_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(Request::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Answer> ANSWER_CODEC = CustomPacketPayload.codec(Answer::write, IPregenPacket.readPacket(Answer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestPerms> REQUEST_PERMS_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(RequestPerms::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnswerPerms> ANSWER_PERMS_CODEC = CustomPacketPayload.codec(AnswerPerms::write, IPregenPacket.readPacket(AnswerPerms::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Action> ACTION_CODEC = CustomPacketPayload.codec(Action::write, IPregenPacket.readPacket(Action::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DeletionTask> DELETION_CODEC = CustomPacketPayload.codec(DeletionTask::write, IPregenPacket.readPacket(DeletionTask::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GenTask> GENERATION_CODEC = CustomPacketPayload.codec(GenTask::write, IPregenPacket.readPacket(GenTask::new));
    public static final CustomPacketPayload.Type<Request> REQUEST = IPregenPacket.createType("chunkpregen:command_request");
    public static final CustomPacketPayload.Type<Answer> ANSWER = IPregenPacket.createType("chunkpregen:command_answer");
    public static final CustomPacketPayload.Type<RequestPerms> REQUEST_PERMS = IPregenPacket.createType("chunkpregen:command_request_perms");
    public static final CustomPacketPayload.Type<AnswerPerms> ANSWER_PERMS = IPregenPacket.createType("chunkpregen:command_answer_perms");
    public static final CustomPacketPayload.Type<Action> ACTION = IPregenPacket.createType("chunkpregen:command_action");
    public static final CustomPacketPayload.Type<DeletionTask> DELETION = IPregenPacket.createType("chunkpregen:command_deletion");
    public static final CustomPacketPayload.Type<GenTask> GENERATION = IPregenPacket.createType("chunkpregen:command_generation");

    public static class AnswerPerms
    implements IPregenPacket {
        List<PregenAction> perms = new ObjectArrayList();

        public AnswerPerms(List<PregenAction> perms) {
            this.perms = perms;
        }

        public AnswerPerms(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.readCollection(buffer, this.perms, T -> (PregenAction)T.readEnum(PregenAction.class));
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.writeCollectionReverse(buffer, this.perms, FriendlyByteBuf::writeEnum);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof PregenMenu) {
                ((PregenMenu)screen).receivePermissions(this.perms);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER_PERMS;
        }
    }

    public static class RequestPerms
    implements IPregenPacket.IRequestPacket {
        public RequestPerms() {
        }

        public RequestPerms(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new AnswerPerms(ChunkPregenerator.getValidActions(player)), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST_PERMS;
        }
    }

    public static class DeletionTask
    implements IPregenPacket {
        IDeletionTask task;

        public DeletionTask(IDeletionTask task) {
            this.task = task;
        }

        public DeletionTask(RegistryFriendlyByteBuf buffer) {
            this.task = IDeletionTask.loadTask(buffer.readNbt());
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)IDeletionTask.saveTask(this.task));
        }

        @Override
        public void process(Player player) {
            if (this.task == null || !ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                return;
            }
            ServerManager.INSTANCE.startTask(this.task, player.getUUID(), arg_0 -> ((Player)player).sendSystemMessage(arg_0));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return DELETION;
        }
    }

    public static class GenTask
    implements IPregenPacket {
        ITask task;

        public GenTask(ITask task) {
            this.task = task;
        }

        public GenTask(RegistryFriendlyByteBuf buffer) {
            this.task = ITask.loadTask(buffer.readNbt());
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)ITask.saveTask(this.task));
        }

        @Override
        public void process(Player player) {
            if (this.task == null || !ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                return;
            }
            ServerManager.INSTANCE.startTask(this.task, player.getUUID(), arg_0 -> ((Player)player).sendSystemMessage(arg_0));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return GENERATION;
        }
    }

    public static class Action
    implements IPregenPacket {
        int action;

        public Action(int action) {
            this.action = action;
        }

        public Action(RegistryFriendlyByteBuf buffer) {
            this.action = buffer.readVarInt();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(this.action);
        }

        @Override
        public void process(Player player) {
            if (this.action < 5) {
                if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                    player.displayClientMessage((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                    return;
                }
                switch (this.action) {
                    case 0: {
                        ServerManager.INSTANCE.pauseTask(null, arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                        break;
                    }
                    case 1: {
                        ServerManager.INSTANCE.resumeTask(null, arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                        break;
                    }
                    case 2: {
                        ServerManager.INSTANCE.stopTask(null, arg_0 -> ((Player)player).sendSystemMessage(arg_0), false);
                        break;
                    }
                    case 3: {
                        ServerManager.INSTANCE.continueTask(arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                        break;
                    }
                    case 4: {
                        ServerManager.INSTANCE.removeTask(null, arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                    }
                }
            } else {
                switch (this.action) {
                    case 5: {
                        TaskStorage.getListeners().add(player.getUUID(), true);
                        break;
                    }
                    case 6: {
                        TaskStorage.getListeners().add(player.getUUID(), false);
                        break;
                    }
                    case 7: {
                        TaskStorage.getListeners().remove(player.getUUID());
                        break;
                    }
                    case 8: {
                        ServerManager.INSTANCE.addListener(player.getUUID());
                        break;
                    }
                    case 9: {
                        ServerManager.INSTANCE.removeListener(player.getUUID());
                    }
                }
            }
            Request.processPlayer(player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ACTION;
        }
    }

    public static class Answer
    implements IPregenPacket {
        int listeningState;
        boolean listening;
        int totalTasks;
        int runningTasks;
        int pausedTasks;

        public Answer(int listeningState, boolean listening, int totalTasks, int runningTasks, int pausedTasks) {
            this.listeningState = listeningState;
            this.listening = listening;
            this.totalTasks = totalTasks;
            this.runningTasks = runningTasks;
            this.pausedTasks = pausedTasks;
        }

        public Answer(RegistryFriendlyByteBuf buffer) {
            this.listeningState = buffer.readVarInt();
            this.listening = buffer.readBoolean();
            this.totalTasks = buffer.readVarInt();
            this.runningTasks = buffer.readVarInt();
            this.pausedTasks = buffer.readVarInt();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(this.listeningState);
            buffer.writeBoolean(this.listening);
            buffer.writeVarInt(this.totalTasks);
            buffer.writeVarInt(this.runningTasks);
            buffer.writeVarInt(this.pausedTasks);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof PregenMenu) {
                ((PregenMenu)screen).receiveData(this.listeningState, this.listening, this.totalTasks, this.runningTasks, this.pausedTasks);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER;
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        public Request() {
        }

        public Request(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            Request.processPlayer(player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST;
        }

        public static void processPlayer(Player player) {
            int[] result = new int[3];
            if (ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                result = ServerManager.INSTANCE.getTasks((G, D, A) -> {
                    int[] output = new int[3];
                    output[0] = G.size() + D.size();
                    output[1] = A.size();
                    BooleanIterator booleanIterator = A.values().iterator();
                    while (booleanIterator.hasNext()) {
                        boolean entry = (Boolean)booleanIterator.next();
                        output[2] = output[2] + (entry ? 0 : 1);
                    }
                    return output;
                });
            }
            NetworkManager.INSTANCE.sendToPlayer(new Answer(TaskStorage.getListeners().getState(player.getUUID()), ServerManager.INSTANCE.isListening(player.getUUID()), result[0], result[1], result[2]), player);
        }
    }
}

