/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.common.networking.packets.MemoryPacket;
import pregenerator.common.networking.packets.OverlayPacket;
import pregenerator.common.networking.packets.ProgressPacket;
import pregenerator.common.networking.packets.RetrogenPacket;
import pregenerator.common.networking.packets.SyncStatePacket;
import pregenerator.common.networking.packets.TaskPacket;

public class NetworkManager {
    public static final NetworkManager INSTANCE = new NetworkManager();
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet();
    boolean serverInstalled = false;
    PayloadRegistrar registerer;

    public void init(RegisterPayloadHandlersEvent event) {
        this.registerer = event.registrar("chunkpregen").optional().versioned("1.0.0");
        this.registerPacket(OverlayPacket.REQUEST, OverlayPacket.REQUEST_CODEC);
        this.registerPacket(OverlayPacket.ANSWER, OverlayPacket.ANSWER_CODEC);
        this.registerPacket(RetrogenPacket.REQUEST, RetrogenPacket.REQUEST_CODEC);
        this.registerPacket(RetrogenPacket.ANSWER, RetrogenPacket.ANSWER_CODEC);
        this.registerPacket(RetrogenPacket.CHANGE, RetrogenPacket.CHANGE_CODEC);
        this.registerPacket(RetrogenPacket.SYNC, RetrogenPacket.SYNC_CODEC);
        this.registerPacket(MemoryPacket.REQUEST, MemoryPacket.REQUEST_CODEC);
        this.registerPacket(MemoryPacket.USED, MemoryPacket.USED_CODEC);
        this.registerPacket(MemoryPacket.ANSWER, MemoryPacket.ANSWER_CODEC);
        this.registerPacket(ProgressPacket.START, ProgressPacket.START_CODEC);
        this.registerPacket(ProgressPacket.UPDATE, ProgressPacket.UPDATE_CODEC);
        this.registerPacket(ProgressPacket.COMPLETE, ProgressPacket.COMPLETE_CODEC);
        this.registerPacket(ProgressPacket.CANCEL, ProgressPacket.CANCEL_CODEC);
        this.registerPacket(TaskPacket.REQUEST_TASKS, TaskPacket.REQUEST_TASKS_CODEC);
        this.registerPacket(TaskPacket.ANSWER_TASKS, TaskPacket.ANSWER_TASKS_CODEC);
        this.registerPacket(TaskPacket.ACTIONS, TaskPacket.ACTIONS_CODEC);
        this.registerPacket(TaskPacket.REQUEST_SPEEDS, TaskPacket.REQUEST_SPEEDS_CODEC);
        this.registerPacket(TaskPacket.ANSWER_SPEEDS, TaskPacket.ANSWER_SPEEDS_CODEC);
        this.registerPacket(CommandPacket.REQUEST, CommandPacket.REQUEST_CODEC);
        this.registerPacket(CommandPacket.ANSWER, CommandPacket.ANSWER_CODEC);
        this.registerPacket(CommandPacket.ACTION, CommandPacket.ACTION_CODEC);
        this.registerPacket(CommandPacket.GENERATION, CommandPacket.GENERATION_CODEC);
        this.registerPacket(CommandPacket.DELETION, CommandPacket.DELETION_CODEC);
        this.registerPacket(CommandPacket.REQUEST_PERMS, CommandPacket.REQUEST_PERMS_CODEC);
        this.registerPacket(CommandPacket.ANSWER_PERMS, CommandPacket.ANSWER_PERMS_CODEC);
        this.registerPacket(SyncStatePacket.ID, SyncStatePacket.CODEC);
    }

    public <T extends IPregenPacket> void registerPacket(CustomPacketPayload.Type<T> id, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        this.registerer.playBidirectional(id, codec, this::handlePacket);
    }

    protected void handlePacket(IPregenPacket packet, IPayloadContext provider) {
        try {
            provider.enqueueWork(() -> packet.process(this.getPlayer(provider)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isInWorld() {
        return this.getClientPlayer() != null;
    }

    protected Player getPlayer(IPayloadContext provider) {
        Player entity = provider.player();
        return entity != null ? entity : this.getClientPlayer();
    }

    public void onPlayerJoined(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.getUUID());
        } else {
            this.serverInstalled = true;
        }
    }

    public void onPlayerLeft(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.getUUID());
        } else {
            this.serverInstalled = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public boolean isInstalled(Player player) {
        return player instanceof ServerPlayer ? this.isInstalledOnClient((ServerPlayer)player) : this.isInstalledOnServer();
    }

    public boolean isInstalledOnClient(ServerPlayer player) {
        return this.clientInstalledPlayers.contains(player.getUUID());
    }

    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public void sendToServer(IPregenPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendToAllPlayers(IPregenPacket packet) {
        for (ServerPlayer player : this.getAllPlayers()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private List<ServerPlayer> getAllPlayers() {
        ObjectArrayList players = new ObjectArrayList();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player);
        }
        return players;
    }

    public void sendToPlayer(IPregenPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

