/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.minitasks;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import pregenerator.ChunkPregenerator;
import pregenerator.common.generator.minitasks.BaseScanTask;
import pregenerator.common.utils.misc.TrackedRegionFile;

public abstract class BaseChunkScanTask<T>
extends BaseScanTask {
    protected int chunksScanned = 0;
    protected int totalChunks = 0;
    protected int filesScanned = 0;
    protected int totalFiles = 0;
    boolean started = false;
    int progress = 0;
    ExecutorCompletionService<Integer> service = new ExecutorCompletionService(ChunkPregenerator.CHUNK_PROCESS_QUEUE);
    List<Future<Integer>> tasks = new ObjectArrayList();
    RegionStorageInfo info;

    public BaseChunkScanTask(ResourceKey<Level> dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public void interrupt() {
        for (Future<Integer> entry : this.tasks) {
            if (entry.isDone()) continue;
            entry.cancel(false);
        }
        this.tasks.clear();
    }

    @Override
    public boolean update(long startTime) {
        if (!this.started) {
            this.started = true;
            for (Path path : this.getRegionFiles()) {
                this.tasks.add(this.service.submit(new Task(path)));
                this.totalChunks += 1024;
                ++this.totalFiles;
            }
            this.info = new RegionStorageInfo(this.getAccess().getLevelId(), this.dimension, "chunk");
            this.onInit();
            return true;
        }
        if (this.filesScanned < this.totalFiles) {
            Future<Integer> output = null;
            while (System.currentTimeMillis() - startTime < 50L && (output = this.service.poll()) != null) {
                int value = this.getSave(output);
                this.chunksScanned += value;
                this.totalChunks -= 1024 - value;
                ++this.filesScanned;
                int newProgress = (int)((float)this.filesScanned / (float)this.totalFiles * 100.0f);
                if (newProgress == this.progress) continue;
                this.progress = newProgress;
                this.onProgressReached(newProgress);
            }
            return true;
        }
        this.onCompletion();
        return false;
    }

    protected int process(Path regionFile) {
        ChunkPos region = this.getRegionPosition(regionFile);
        if (region == null) {
            return 0;
        }
        int result = 0;
        ObjectArrayList list = new ObjectArrayList();
        try {
            TrackedRegionFile file = new TrackedRegionFile(this.info, regionFile, regionFile.getParent());
            for (int i = 0; i < 1024; ++i) {
                ChunkPos pos = new ChunkPos(i % 32, i / 32);
                if (!file.hasChunk(pos)) continue;
                try (DataInputStream stream = file.getChunkDataInputStream(pos);){
                    this.test(NbtIo.read((DataInput)stream), ((List)list)::add);
                }
                catch (Exception e) {
                    this.onFailure(new ChunkPos((region.x << 5) + pos.x, (region.z << 5) + pos.z), ((List)list)::add);
                }
                ++result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processResult((List<T>)list);
        return result;
    }

    protected abstract void test(CompoundTag var1, Consumer<T> var2);

    protected abstract void onFailure(ChunkPos var1, Consumer<T> var2);

    protected abstract void onInit();

    protected abstract void onProgressReached(int var1);

    protected abstract void processResult(List<T> var1);

    protected abstract void onCompletion();

    protected int getSave(Future<Integer> output) {
        try {
            return output.get();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private class Task
    implements Callable<Integer> {
        Path path;

        public Task(Path path) {
            this.path = path;
        }

        @Override
        public Integer call() throws Exception {
            return BaseChunkScanTask.this.process(this.path);
        }
    }
}

