/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.minitasks;

import it.unimi.dsi.fastutil.ints.Int2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongMaps;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.minitasks.BaseChunkScanTask;

public class AgeScan
extends BaseChunkScanTask<Long> {
    private static final long[] TICKS = new long[]{100L, 1200L, 12000L, 36000L};
    private static final String[] KEYS = new String[]{"mini_task.chunk_pregen.age_scan.first", "mini_task.chunk_pregen.age_scan.second", "mini_task.chunk_pregen.age_scan.third", "mini_task.chunk_pregen.age_scan.fourth", "mini_task.chunk_pregen.age_scan.fith"};
    int lastFive = 0;
    Int2LongMap counted = Int2LongMaps.synchronize((Int2LongMap)new Int2LongLinkedOpenHashMap());

    public AgeScan(ResourceKey<Level> dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public boolean hasClientOverlay() {
        return true;
    }

    @Override
    public byte getClientDataId() {
        return 3;
    }

    @Override
    public void writeData(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.dimension.location());
        buffer.writeVarInt(this.filesScanned);
        buffer.writeVarInt(this.totalFiles);
        buffer.writeLong((long)this.chunksScanned);
        buffer.writeLong((long)this.totalChunks);
    }

    @Override
    protected void onInit() {
        this.sendMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.start", this.totalFiles));
    }

    @Override
    protected void onProgressReached(int progress) {
        if (progress - this.lastFive >= 5) {
            this.lastFive = progress;
            this.sendMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.progress", TextUtil.NUMBERS.format(progress)).withStyle(ChatFormatting.AQUA));
        }
    }

    @Override
    protected void test(CompoundTag tag, Consumer<Long> output) {
        if (tag == null) {
            return;
        }
        output.accept(tag.getLong("InhabitedTime"));
    }

    @Override
    protected void onFailure(ChunkPos pos, Consumer<Long> output) {
    }

    @Override
    protected void processResult(List<Long> data) {
        for (Long value : data) {
            this.counted.compute(this.findIndex(value), (T, V) -> V == null ? 1L : V + 1L);
        }
    }

    private int findIndex(long value) {
        for (int i = 0; i < TICKS.length; ++i) {
            if (value >= TICKS[i]) continue;
            return i;
        }
        return TICKS.length;
    }

    private Style format(int index) {
        HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)TextUtil.translate("mini_task.chunk_pregen.age_scan.suggestion"));
        ClickEvent click = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, (String)(index >= 4 ? "/pregen start delete trim TrimTaskId 0 0 100" : "/pregen start delete timedtrim TrimTaskId 0 0 100 " + TICKS[index]));
        return Style.EMPTY.withHoverEvent(hover).withClickEvent(click).withColor(ChatFormatting.AQUA);
    }

    @Override
    protected void onCompletion() {
        this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.completed"));
        this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.found"));
        for (int i = 0; i < 5; ++i) {
            this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.time", TextUtil.translateStyled(KEYS[i], ChatFormatting.GOLD), TextUtil.NUMBERS.format(this.counted.get(i))).withStyle(this.format(i)));
        }
    }
}

