/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkProcess;

public class ChunkUnloader {
    List<ChunkEntry> queue = new ObjectArrayList();
    List<ChunkEntry> finishedSaved = new ObjectArrayList();
    int chunksToUnload = 0;
    int tempUnloaded = 0;

    public void enqueue(ChunkEntry file) {
        this.queue.add(file);
        this.chunksToUnload += file.getGenerationSize();
    }

    public long process(PriorityQueue<ChunkEntry> chunksToProcess) {
        int i;
        if (this.queue.isEmpty()) {
            return 0L;
        }
        long value = 0L;
        IntArrayList list = new IntArrayList();
        for (i = 0; i < this.queue.size(); ++i) {
            ChunkEntry file = this.queue.get(i);
            int temp = file.trackUnloading();
            if (file.isUnloaded()) {
                this.chunksToUnload -= file.getGenerationSize();
                if (!file.isTaskFinished()) {
                    chunksToProcess.enqueue((Object)file);
                    value += (long)file.getTotalSize();
                }
                this.queue.remove(i--);
                continue;
            }
            list.add(temp);
        }
        this.tempUnloaded = 0;
        for (i = 0; i < list.size(); ++i) {
            this.tempUnloaded += list.getInt(i);
        }
        return value;
    }

    public void forceFinish(ChunkProcess process) {
        for (int i = 0; i < this.queue.size(); ++i) {
            this.queue.get(i).interrupt();
        }
        this.queue.clear();
        this.tempUnloaded = 0;
        this.chunksToUnload = 0;
    }

    public boolean isFinished() {
        return this.chunksToUnload <= 0;
    }

    public int getChunksToUnload() {
        return this.chunksToUnload - this.tempUnloaded;
    }
}

