/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionTimeOut
extends BaseDeletionTask {
    ChunkPos center;
    int radius;
    long timeOut;
    long cachedSize = -1L;

    public DeletionTimeOut(CompoundTag nbt) {
        super(nbt);
        this.center = new ChunkPos(nbt.getLong("center"));
        this.radius = nbt.getInt("radius");
        this.timeOut = nbt.getLong("time");
        this.cachedSize = nbt.contains("cache") ? nbt.getLong("cache") : -1L;
    }

    public DeletionTimeOut(String name, ResourceKey<Level> type, ChunkPos center, int radius, long timeOut) {
        super(name, type);
        this.center = center;
        this.radius = radius;
        this.timeOut = timeOut;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.putInt("radius", this.radius);
        nbt.putLong("time", this.timeOut);
        nbt.putLong("center", this.center.toLong());
        if (this.cachedSize != -1L) {
            nbt.putLong("cache", this.cachedSize);
        }
        return nbt;
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.timeout");
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public ChunkPos getCenter() {
        return this.center;
    }

    @Override
    public long getTaskSize() {
        return this.cachedSize == -1L ? (this.cachedSize = this.calculateCacheSize()) : this.cachedSize;
    }

    @Override
    public void append(MutableComponent builder) {
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.timeout"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.timeout", this.timeOut, builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", this.center.x, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", this.center.z, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        ObjectArrayList list = new ObjectArrayList();
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        RegionStorageInfo info = new RegionStorageInfo(this.getAccess().getLevelId(), this.getDimension(), "chunk");
        progress.setMax((long)this.getRegionFiles().size() * 1024L);
        for (Path subFile : this.getRegionFiles()) {
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.x;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.z;
            if (minX < -this.radius || minX + 32 > this.radius || minZ < -this.radius || minZ + 32 > this.radius) {
                list.add(service.submit(() -> {
                    if (!progress.isAlive()) {
                        return new ScanResult(ChunkPos.asLong((int)(minX >> 5), (int)(minZ >> 5)), new BitSet());
                    }
                    long result = ChunkPos.asLong((int)(minX >> 5), (int)(minZ >> 5));
                    BitSet set = new BitSet(1024);
                    try (RegionFile region = new RegionFile(info, subFile, subFile.getParent(), false);){
                        for (int i = 0; i < 1024 && progress.isAlive(); ++i) {
                            int x = i % 32 + minX;
                            int z = i / 32 + minZ;
                            ChunkPos pos = new ChunkPos(i % 32, i / 32);
                            if ((x > this.radius || x < -this.radius || z > this.radius || z < -this.radius) && region.hasChunk(pos) && this.canBeDeleted(region, pos)) {
                                set.set(i);
                            }
                            progress.growValue(1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return new ScanResult(result, set);
                }));
                continue;
            }
            progress.growValue(1024);
        }
        service.shutdown();
        Long2ObjectOpenHashMap toDelete = new Long2ObjectOpenHashMap();
        long total = 0L;
        while (progress.isAlive() && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((Future)list.get(i)).isDone()) continue;
                try {
                    ((ScanResult)((Future)list.remove(i--)).get()).apply((Long2ObjectMap<BitSet>)toDelete);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        if (!progress.isAlive() && list.size() > 0) {
            for (Future entry : list) {
                entry.cancel(true);
            }
            service.shutdownNow();
        }
        this.cachedSize = total;
        return new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world).init((Long2ObjectMap<BitSet>)toDelete, this.center, progress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canBeDeleted(RegionFile file, ChunkPos pos) {
        try (DataInputStream stream = file.getChunkDataInputStream(pos);){
            if (stream == null) return false;
            CompoundTag nbt = NbtIo.read((DataInput)stream);
            boolean bl = nbt != null && (ChunkSerializer.getChunkTypeFromTag((CompoundTag)nbt) == ChunkType.PROTOCHUNK || nbt.getLong("InhabitedTime") <= this.timeOut);
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long calculateCacheSize() {
        long total = 0L;
        RegionStorageInfo info = new RegionStorageInfo(this.getAccess().getLevelId(), this.getDimension(), "chunk");
        for (Path subFile : this.getRegionFiles()) {
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.x;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.z;
            if (minX >= -this.radius && minX + 32 <= this.radius && minZ >= -this.radius && minZ + 32 <= this.radius) continue;
            try (RegionFile file = new RegionFile(info, subFile, subFile.getParent(), false);){
                for (int i = 0; i < 1024; ++i) {
                    int x = i % 32 + minX;
                    int z = i / 32 + minZ;
                    if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.hasChunk(new ChunkPos(i % 32, i / 32))) continue;
                    ++total;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return total;
    }

    static class ScanResult {
        long pos;
        BitSet set;

        public ScanResult(long pos, BitSet set) {
            this.pos = pos;
            this.set = set;
        }

        public long apply(Long2ObjectMap<BitSet> map) {
            if (!this.set.isEmpty()) {
                map.put(this.pos, (Object)this.set);
                return this.set.cardinality();
            }
            return 0L;
        }
    }
}

