/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforge.server.command.EnumArgument;
import pregenerator.base.api.TextUtil;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.generator.tasks.SquareTask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;
import pregenerator.common.utils.misc.GenShape;

public class GenCommand {
    public static GenCommand INSTANCE = new GenCommand();

    public CommandBuilder createGenStart(boolean advArgs) {
        CommandBuilder builder = new CommandBuilder("gen");
        Consumer<CommandWrapper> radius = GenCommand::executeRadius;
        builder.literal("radius");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.arg("Center", CenterArgument.center());
            builder.arg("Radius", RadiusArgument.integer(1, 25000), radius);
            builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), radius);
            builder.arg("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), radius).popTop();
        } else {
            builder.arg("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listShape));
            builder.arg("Center", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1, (int)25000), radius);
            builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), radius);
            builder.arg("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), radius).popTop();
        }
        Consumer<CommandWrapper> expansion = GenCommand::executeExpansion;
        builder.literal("expansion");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.arg("Center", CenterArgument.center());
            builder.arg("Min Radius", RadiusArgument.integer(1));
            builder.arg("Max Radius", RadiusArgument.integer(1), expansion);
            builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), expansion);
            builder.arg("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), expansion).popTop();
        } else {
            builder.arg("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listShape));
            builder.arg("Center", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1));
            builder.arg("Max Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1), expansion);
            builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), expansion);
            builder.arg("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), expansion).popTop();
        }
        Consumer<CommandWrapper> area = GenCommand::executeArea;
        builder.literal("area");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.arg("From", CenterArgument.center());
            builder.arg("To", CenterArgument.center(), area);
            builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), area);
            builder.arg("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), area).popTop();
        } else {
            builder.arg("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listShape));
            builder.arg("From", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("To", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion), area);
            builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), area);
            builder.arg("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), area).popTop();
        }
        Consumer<CommandWrapper> border = GenCommand::executeWorldBorder;
        builder.literal("worldborder");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word(), border);
        builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), border);
        if (advArgs) {
            builder.arg("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), border).popTop();
        } else {
            builder.arg("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), border).popTop();
        }
        return builder;
    }

    private static CompletableFuture<Suggestions> listShape(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(GenShape.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString()));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> listSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(GenerationType.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString(), (Message)e.createSuggestion()));
        return builder.buildFuture();
    }

    private static void executeWorldBorder(CommandWrapper source) {
        String name = source.get("Task Name", String.class);
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        GenerationType gen = source.hasValue("Generation Type", String.class) ? GenerationType.valueOf(source.get("Generation Type", String.class)) : source.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        WorldBorder border = ServerLifecycleHooks.getCurrentServer().getLevel(dimension).getWorldBorder();
        int size = (int)(border.getSize() / 2.0) >> 4;
        if (size > 500) {
            source.sendErrorMessage((Component)TextUtil.radiusToBig());
            return;
        }
        int memoryError = GenCommand.validateDiskUsage(GenShape.SQUARE.calculateRadius(size), dimension);
        if (memoryError == 3) {
            source.sendErrorMessage((Component)TextUtil.taskOverflow(TextUtil.getWorldSize(GenShape.SQUARE.calculateRadius(size), dimension)));
            return;
        }
        if (memoryError == 1) {
            source.sendFeedBackMessage((Component)TextUtil.taskInfo(TextUtil.getWorldSize(GenShape.SQUARE.calculateRadius(size), dimension)));
        }
        SquareTask task = new SquareTask(name, dimension, gen.getIndex(), new ChunkPos((int)border.getCenterX() >> 4, (int)border.getCenterZ() >> 4), size);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                source.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (ServerManager.INSTANCE.generation.storeTask(task, source, ServerLifecycleHooks.getCurrentServer())) {
                source.sendFeedBackMessage((Component)TextUtil.taskWarning(TextUtil.getWorldSize(GenShape.SQUARE.calculateRadius(size), dimension), task.getName()));
            }
            return;
        }
        ServerManager.INSTANCE.startTask(task, source.getSenderId(), source);
    }

    private static void executeArea(CommandWrapper source) {
        ChunkPos maxPos;
        String name = source.get("Task Name", String.class);
        GenShape shape = source.hasValue("Shape", String.class) ? GenShape.valueOf(source.get("Shape", String.class)) : source.get("Shape", GenShape.class);
        BlockPos min = CenterArgument.getVanillaBlockPos(source.get("From", Coordinates.class), source.getSource());
        BlockPos max = CenterArgument.getVanillaBlockPos(source.get("To", Coordinates.class), source.getSource());
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        if (max.getX() - min.getX() > 500 || max.getZ() - min.getZ() > 500) {
            source.sendErrorMessage((Component)TextUtil.radiusToBig());
            return;
        }
        ChunkPos minPos = new ChunkPos(min.getX() < max.getX() ? min.getX() : max.getX(), min.getZ() < max.getZ() ? min.getZ() : max.getZ());
        int memoryError = GenCommand.validateDiskUsage(shape.calculateRadius(minPos, maxPos = new ChunkPos(min.getX() > max.getX() ? min.getX() : max.getX(), min.getZ() > max.getZ() ? min.getZ() : max.getZ())), dimension);
        if (memoryError == 3) {
            source.sendErrorMessage((Component)TextUtil.taskOverflow(TextUtil.getWorldSize(shape.calculateRadius(minPos, maxPos), dimension)));
            return;
        }
        if (memoryError == 1) {
            source.sendFeedBackMessage((Component)TextUtil.taskInfo(TextUtil.getWorldSize(shape.calculateRadius(minPos, maxPos), dimension)));
        }
        GenerationType gen = source.hasValue("Generation Type", String.class) ? GenerationType.valueOf(source.get("Generation Type", String.class)) : source.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        ITask task = shape.createAreaGenTask(name, minPos, maxPos, gen, dimension);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                source.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (ServerManager.INSTANCE.generation.storeTask(task, source, ServerLifecycleHooks.getCurrentServer())) {
                source.sendFeedBackMessage((Component)TextUtil.taskWarning(TextUtil.getWorldSize(shape.calculateRadius(minPos, maxPos), dimension), task.getName()));
            }
            return;
        }
        ServerManager.INSTANCE.startTask(task, source.getSenderId(), source);
    }

    private static void executeRadius(CommandWrapper source) {
        String name = source.get("Task Name", String.class);
        GenShape shape = source.hasValue("Shape", String.class) ? GenShape.valueOf(source.get("Shape", String.class)) : source.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(source.get("Center", Coordinates.class), source.getSource());
        int radius = source.get("Radius", Integer.class);
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        if (radius > 500) {
            source.sendErrorMessage((Component)TextUtil.radiusToBig());
            return;
        }
        int memoryError = GenCommand.validateDiskUsage(shape.calculateRadius(radius), dimension);
        if (memoryError == 3) {
            source.sendErrorMessage((Component)TextUtil.taskOverflow(TextUtil.getWorldSize(shape.calculateRadius(radius), dimension)));
            return;
        }
        if (memoryError == 1) {
            source.sendFeedBackMessage((Component)TextUtil.taskInfo(TextUtil.getWorldSize(shape.calculateRadius(radius), dimension)));
        }
        GenerationType gen = source.hasValue("Generation Type", String.class) ? GenerationType.valueOf(source.get("Generation Type", String.class)) : source.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        ITask task = shape.createRadiusGenTask(name, center.getX(), center.getZ(), radius, gen, dimension);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                source.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (ServerManager.INSTANCE.generation.storeTask(task, source, ServerLifecycleHooks.getCurrentServer())) {
                source.sendFeedBackMessage((Component)TextUtil.taskWarning(TextUtil.getWorldSize(shape.calculateRadius(radius), dimension), task.getName()));
            }
            return;
        }
        ServerManager.INSTANCE.startTask(task, source.getSenderId(), source);
    }

    private static void executeExpansion(CommandWrapper source) {
        int maxRadius;
        String name = source.get("Task Name", String.class);
        GenShape shape = source.hasValue("Shape", String.class) ? GenShape.valueOf(source.get("Shape", String.class)) : source.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(source.get("Center", Coordinates.class), source.getSource());
        int minRadius = source.get("Min Radius", Integer.class);
        if (minRadius > (maxRadius = source.get("Max Radius", Integer.class).intValue())) {
            source.sendErrorMessage((Component)TextUtil.minBiggerThenMax());
            return;
        }
        if (shape.calculateRadius(minRadius, maxRadius) > 1000000L) {
            source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.error.expansion_to_big", GenCommand.findRadius(minRadius, maxRadius, shape)));
            return;
        }
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        int memoryError = GenCommand.validateDiskUsage(shape.calculateRadius(minRadius, maxRadius), dimension);
        if (memoryError == 3) {
            source.sendErrorMessage((Component)TextUtil.taskOverflow(TextUtil.getWorldSize(shape.calculateRadius(minRadius, maxRadius), dimension)));
            return;
        }
        if (memoryError == 1) {
            source.sendFeedBackMessage((Component)TextUtil.taskInfo(TextUtil.getWorldSize(shape.calculateRadius(minRadius, maxRadius), dimension)));
        }
        GenerationType gen = source.hasValue("Generation Type", String.class) ? GenerationType.valueOf(source.get("Generation Type", String.class)) : source.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        ITask task = shape.createExpansionGenTask(name, center.getX(), center.getZ(), minRadius, maxRadius, gen, dimension);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                source.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (ServerManager.INSTANCE.generation.storeTask(task, source, ServerLifecycleHooks.getCurrentServer())) {
                source.sendFeedBackMessage((Component)TextUtil.taskWarning(TextUtil.getWorldSize(shape.calculateRadius(minRadius, maxRadius), dimension), task.getName()));
            }
            return;
        }
        ServerManager.INSTANCE.startTask(task, source.getSenderId(), source);
    }

    public static int validateDiskUsage(long chunks, ResourceKey<Level> dimension) {
        double usage = (double)TextUtil.getWorldSize(chunks, dimension) / (double)TextUtil.getFreeMemory();
        if (usage < 0.3) {
            return 0;
        }
        if (usage < 0.8) {
            return 1;
        }
        if (usage < 1.0) {
            return 2;
        }
        return 3;
    }

    private static int findRadius(int startRadius, int endRadius, GenShape shape) {
        int diff = Math.max(1, (endRadius - startRadius) / 100);
        long baseValue = shape.calculateRadius(startRadius);
        int value = endRadius;
        while (shape.calculateRadius(value) - baseValue >= 1000000L) {
            value -= diff;
        }
        while (shape.calculateRadius(value + 1) - baseValue < 1000000L) {
            ++value;
        }
        return value;
    }
}

