/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.ListenerStorage;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.deleter.tasks.IDeletionTask;

public class TaskStorage
extends SavedData {
    private static final SavedData.Factory<TaskStorage> FACTORY = new SavedData.Factory(TaskStorage::new, TaskStorage::loadData, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
    GenTaskStorage storage = new GenTaskStorage(() -> ((TaskStorage)this).setDirty());
    SimpleTaskStorage<IDeletionTask> deletion = new SimpleTaskStorage<IDeletionTask>(() -> ((TaskStorage)this).setDirty(), IDeletionTask::loadTask, IDeletionTask::saveTask);
    ListenerStorage listeners = new ListenerStorage();

    public static TaskStorage loadData(CompoundTag nbt, HolderLookup.Provider provider) {
        TaskStorage storage = new TaskStorage();
        storage.load(nbt, provider);
        return storage;
    }

    public void load(CompoundTag nbt, HolderLookup.Provider provider) {
        this.storage.read(nbt.getCompound("generation"));
        this.deletion.read(nbt.getCompound("deletion"));
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider p_323640_) {
        compound.put("generation", (Tag)this.storage.write(new CompoundTag()));
        compound.put("deletion", (Tag)this.deletion.write(new CompoundTag()));
        return compound;
    }

    public static GenTaskStorage getGenStorage() {
        return TaskStorage.getStorage().storage;
    }

    public static SimpleTaskStorage<IDeletionTask> getDeletionStorage() {
        return TaskStorage.getStorage().deletion;
    }

    public static ListenerStorage getListeners() {
        return TaskStorage.getStorage().listeners;
    }

    public static TaskStorage getStorage() {
        return (TaskStorage)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(FACTORY, "pregen_storage");
    }

    public static Set<String> getActiveTasks() {
        ObjectLinkedOpenHashSet s = new ObjectLinkedOpenHashSet();
        s.addAll(TaskStorage.getGenStorage().getActiveTasks());
        s.addAll(TaskStorage.getDeletionStorage().getActiveTasks());
        return s;
    }

    public static Set<String> getTasks() {
        ObjectLinkedOpenHashSet s = new ObjectLinkedOpenHashSet();
        s.addAll(TaskStorage.getGenStorage().getTasks());
        s.addAll(TaskStorage.getDeletionStorage().getTasks());
        return s;
    }
}

