/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import pregenerator.common.base.ProcessListener;

public class ListenerStorage {
    Object2BooleanMap<ProcessListener> listeners = new Object2BooleanLinkedOpenHashMap();

    public void read(CompoundTag nbt) {
        ListTag list = nbt.getList("autoListeners", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            CompoundTag data = list.getCompound(i);
            this.listeners.put((Object)ProcessListener.create(data.getString("id")), data.getBoolean("state"));
        }
    }

    public CompoundTag write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Object2BooleanMap.Entry entry : Object2BooleanMaps.fastIterable(this.listeners)) {
            CompoundTag data = new CompoundTag();
            data.putBoolean("state", entry.getBooleanValue());
            data.putString("id", ((ProcessListener)entry.getKey()).save());
            list.add((Object)data);
        }
        nbt.put("autoListeners", (Tag)list);
        return nbt;
    }

    public void updateListeners(Set<ProcessListener> globalListeners) {
        for (Object2BooleanMap.Entry entry : Object2BooleanMaps.fastIterable(this.listeners)) {
            if (!entry.getBooleanValue()) continue;
            globalListeners.add((ProcessListener)entry.getKey());
        }
    }

    public boolean add(UUID id, boolean listen) {
        ProcessListener listener = ProcessListener.create(id);
        if (this.listeners.containsKey((Object)listener)) {
            return this.listeners.put((Object)listener, listen) != listen;
        }
        this.listeners.put((Object)listener, listen);
        return true;
    }

    public boolean remove(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        if (this.listeners.containsKey((Object)listener)) {
            this.listeners.removeBoolean((Object)listener);
            return true;
        }
        return false;
    }

    public boolean contains(UUID id) {
        return this.listeners.containsKey((Object)ProcessListener.create(id));
    }

    public boolean isIgnoring(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey((Object)listener) && !this.listeners.getBoolean((Object)listener);
    }

    public boolean isAutoListening(UUID id) {
        return this.listeners.getBoolean((Object)ProcessListener.create(id));
    }

    public int getState(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey((Object)listener) ? (this.listeners.getBoolean((Object)listener) ? 0 : 1) : 2;
    }
}

