/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import pregen_expansion.client.gui.DimensionScreen;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.helpers.IProgressListener;
import pregenerator.common.networking.packets.ProgressPacket;

public class ProgressScreen
extends BasePregenScreen
implements IProgressListener {
    Screen parent;
    Component header;
    long current = 0L;
    long max;
    UUID taskId;
    long lastPacket = System.currentTimeMillis();

    public ProgressScreen(Screen parent, UUID taskId, long max, Component message) {
        super((Component)TextUtil.guiConstructor());
        this.parent = parent;
        this.taskId = taskId;
        this.max = max;
        this.header = message;
    }

    @Override
    protected void init() {
        super.init();
        this.button(-60, 25, 120, 18, Align.CENTER, Align.CENTER, (Component)TextUtil.literal("Cancel"), T -> this.sendToServer(new ProgressPacket.Cancel(this.taskId)));
        this.minecraft.noRender = true;
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void renderBack(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.drawRectangle(graphics, 80, 7, 0, 0, -7631989, true);
        float progress = Math.max(Math.min((float)this.current / (float)this.max, 1.0f), 0.0f);
        this.drawColorRegion(graphics, this.centerX - 80, this.centerY - 7, (float)(this.centerX - 80) + progress * 160.0f, this.centerY + 7, Color.GREEN.darker().getRGB());
    }

    @Override
    public void renderFront(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawText(graphics, this.header, 0.0f, -25.0f, Align.CENTER, -1);
        this.drawText(graphics, (Component)TextUtil.literal(NUMBERS.format(this.current) + " / " + NUMBERS.format(this.max)), 0.0f, -4.0f, Align.CENTER, -1);
    }

    public void onClose() {
        this.minecraft.noRender = false;
        this.setScreen(this.parent);
        if (this.parent instanceof DimensionScreen) {
            ((DimensionScreen)this.parent).updateDimension();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (System.currentTimeMillis() - this.lastPacket > 100000L) {
            this.onClose();
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void updateProgress(long current, long max) {
        this.current = current;
        this.max = max;
        this.lastPacket = System.currentTimeMillis();
    }

    @Override
    public void onCompleted() {
        this.onClose();
    }
}

