/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.DynamicPregenList;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.common.utils.misc.SmoothDouble;

public class PregenTreeList<T extends TreeEntry<T>>
extends DynamicPregenList<T>
implements BasePregenScreen.ITooltipProvider {
    TreeState<T> state;
    int heightCache = -1;

    public PregenTreeList(Screen owner, int width, int height, int startY, int endY, TreeState<T> state) {
        super(owner.getMinecraft(), width, height, startY, endY, state.getItemHeight());
        this.state = state;
        state.setOwner(this);
        for (TreeEntry node : state.getNodes()) {
            node.iterateEach(this::bindToSelf);
        }
        this.applySearch(state.getSearch(), true);
    }

    public PregenTreeList(Screen owner, TreeState<T> state) {
        this(owner, owner.width, owner.height - state.getBottomPadding() - state.getTopPadding(), state.getTopPadding(), owner.height, state);
    }

    @Override
    public void provideTooltips(Consumer<Component> tooltips) {
        for (TreeEntry entry : this.children()) {
            if (!(entry instanceof BasePregenScreen.ITooltipProvider)) continue;
            entry.provideTooltips(tooltips);
        }
    }

    public int getRowWidth() {
        return this.state.getRowWidth();
    }

    protected boolean isSelectedItem(int p_94019_) {
        return this.state.isFramed();
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + this.state.getRowWidth() / 2 + 14;
    }

    public void setScrollAmount(double value) {
        this.state.setScrollAmount(Math.max(0.0, Math.min(value, (double)this.getMaxScroll())));
    }

    public double getScrollAmount() {
        return this.state.getScrollAmount();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.state.scrollAmount.update(partialTicks);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.state.scrollAmount.forceFinish();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float particalTicks) {
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPos(mouseX, mouseY) : null;
        int minX = this.getRowLeft();
        int width = this.getRowWidth();
        int size = this.getItemCount();
        int yOff = this.getY() + 4 - (int)this.getScrollAmount() + this.headerHeight;
        int yOffset = 0;
        boolean hasRendered = false;
        ObjectArrayList childNodes = new ObjectArrayList();
        boolean valid = true;
        BasePregenScreen.pushScissors(minX, this.getY() + this.headerHeight, width, this.getBottom() - this.getY());
        for (int i = 0; i < size; ++i) {
            TreeEntry entry = (TreeEntry)this.getEntry(i);
            int height = entry.getItemHeight();
            int minY = yOffset + yOff;
            int maxY = minY + height;
            int xOff = this.getXOff(entry);
            if (valid && childNodes.size() > 0) {
                boolean[] rendered = new boolean[1];
                yOffset += this.renderGrid(graphics, mouseX, mouseY, particalTicks, i - 1, minX + xOff, minY, width - xOff, rendered, (List<T>)childNodes);
                hasRendered |= rendered[0];
                i += childNodes.size() - 1;
                childNodes.clear();
                valid = false;
                continue;
            }
            if (maxY >= this.getY() && minY <= this.getBottom()) {
                hasRendered = true;
                this.renderItem(graphics, mouseX, mouseY, particalTicks, i, minX + xOff, minY, width - xOff, height - 4);
            } else if (hasRendered) break;
            if (entry.areGridChildren()) {
                valid = this.collectGrids(i + 1, size, (T)entry, (List<T>)childNodes);
            }
            yOffset += height;
        }
        BasePregenScreen.popScissors();
    }

    protected boolean collectGrids(int startindex, int size, T entry, List<T> childNodes) {
        for (int j = startindex; j < size; ++j) {
            TreeEntry child = (TreeEntry)this.getEntry(j);
            if (child.parent() == entry) {
                if (child.childNodes.size() > 0) {
                    childNodes.clear();
                    return false;
                }
            } else {
                return true;
            }
            childNodes.add(child);
        }
        return true;
    }

    protected int renderGrid(GuiGraphics graphics, int mouseX, int mouseY, float particalTicks, int startIndex, int left, int top, int width, boolean[] stopped, List<T> children) {
        TreeEntry entry = (TreeEntry)this.getEntry(startIndex);
        int entryWidth = entry.getGridWidth();
        int entryHeight = this.calculateMostY(children);
        int xOffset = 0;
        int yOffset = 0;
        boolean hasRendered = false;
        int m = children.size();
        for (int i = 0; i < m; ++i) {
            int minY;
            int maxY;
            if (xOffset + entryWidth > width) {
                yOffset += entryHeight;
                xOffset = 0;
            }
            if ((maxY = (minY = yOffset + top) + entryHeight) >= this.getY() && minY <= this.getBottom()) {
                hasRendered = true;
                this.renderItem(graphics, mouseX, mouseY, particalTicks, i + startIndex + 1, left + xOffset, minY, entryWidth, entryHeight - 4);
            }
            xOffset += entryWidth;
        }
        if (hasRendered) {
            stopped[0] = true;
        }
        return entryHeight + yOffset;
    }

    protected int calculateMostY(List<T> children) {
        int max = 0;
        for (TreeEntry entry : children) {
            max = Math.max(max, entry.getItemHeight());
        }
        return max;
    }

    protected int countGrid(List<T> children, T entry, int width) {
        int entryWidth = ((TreeEntry)entry).getGridWidth();
        int entryHeight = this.calculateMostY(children);
        int xOffset = 0;
        int yOffset = 0;
        int m = children.size();
        for (int i = 0; i < m; ++i) {
            if (xOffset + entryWidth > width) {
                yOffset += entryHeight;
                xOffset = 0;
            }
            xOffset += entryWidth;
        }
        return entryHeight + yOffset;
    }

    protected Map.Entry<Integer, Integer> findGrid(List<T> children, T entry, int width, int xLeft, int yLeft) {
        int entryWidth = ((TreeEntry)entry).getGridWidth();
        int entryHeight = this.calculateMostY(children);
        int xOffset = 0;
        int yOffset = 0;
        int m = children.size();
        for (int i = 0; i < m; ++i) {
            if (xOffset + entryWidth > width) {
                yOffset += entryHeight;
                xOffset = 0;
            }
            if (entryHeight + yOffset >= yLeft && entryWidth + xOffset >= xLeft) {
                return new AbstractMap.SimpleEntry<Object, Integer>(null, i);
            }
            xOffset += entryWidth;
        }
        return new AbstractMap.SimpleEntry<Integer, Object>(entryHeight + yOffset, null);
    }

    protected int getXOff(T node) {
        int count = 0;
        while ((node = ((TreeEntry)node).parent()) != null) {
            ++count;
        }
        return count * 14;
    }

    @Override
    protected void centerScrollOn(T element) {
        int index = this.children().indexOf(element);
        if (index <= 0) {
            this.setScrollAmount(0.0);
            return;
        }
        double total = 0.0;
        for (int i = 0; i <= index; ++i) {
            ObjectArrayList childNodes;
            TreeEntry entry = (TreeEntry)this.getEntry(i);
            if (entry.areGridChildren() && this.collectGrids(i + 1, index, (T)entry, (List<T>)(childNodes = new ObjectArrayList())) && childNodes.size() > 0) {
                total += (double)entry.getItemHeight();
                total += (double)this.countGrid((List<T>)childNodes, (T)entry, this.getRowWidth() - (this.getXOff(entry) + 14));
                i += childNodes.size();
                continue;
            }
            total += (double)entry.getItemHeight();
        }
        this.setScrollAmount(total - (double)((this.getBottom() - this.getY()) / 2));
    }

    @Override
    protected T getEntryAtPos(double mouseX, double mouseY) {
        TreeEntry entry;
        int height;
        int centerWidth = this.getRowWidth() / 2;
        int centerX = this.getX() + this.width / 2;
        int minX = centerX - centerWidth;
        int maxX = centerX + centerWidth;
        int xPosition = (int)(mouseX - (double)minX);
        int yPosition = Mth.floor((double)(mouseY - (double)this.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int index = 0;
        int m = this.getItemCount();
        for (int i = 0; i < m && (height = (entry = (TreeEntry)this.getEntry(i)).getItemHeight()) <= yPosition; ++i) {
            ObjectArrayList childNodes;
            ++index;
            yPosition -= height;
            if (!entry.areGridChildren() || !this.collectGrids(i + 1, m, (T)entry, (List<T>)(childNodes = new ObjectArrayList())) || childNodes.size() <= 0) continue;
            int offset = this.getXOff(entry) + 14;
            Map.Entry<Integer, Integer> result = this.findGrid((List<T>)childNodes, (T)entry, this.getRowWidth() - offset, xPosition - offset, yPosition);
            if (result.getValue() == null) {
                i += childNodes.size();
                index += childNodes.size();
                yPosition -= result.getKey().intValue();
                continue;
            }
            index += result.getValue().intValue();
            break;
        }
        return (T)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && index >= 0 && yPosition >= 0 && index < this.getItemCount() ? (TreeEntry)this.children().get(index) : null);
    }

    @Override
    public int getMaxPosition() {
        if (this.heightCache == -1) {
            int total = 0;
            boolean valid = false;
            ObjectArrayList childNodes = new ObjectArrayList();
            int m = this.getItemCount();
            for (int i = 0; i < m; ++i) {
                if (valid) {
                    TreeEntry parent = (TreeEntry)this.getEntry(i - 1);
                    total += this.countGrid((List<T>)childNodes, (T)parent, this.getRowWidth() - (this.getXOff(parent) + 14));
                    i += childNodes.size() - 1;
                    valid = false;
                    childNodes.clear();
                    continue;
                }
                TreeEntry entry = (TreeEntry)this.getEntry(i);
                total += entry.getItemHeight();
                if (!entry.areGridChildren()) continue;
                valid = this.collectGrids(i + 1, m, (T)entry, (List<T>)childNodes);
            }
            this.heightCache = total;
            this.setScrollAmount(this.getScrollAmount());
        }
        return this.heightCache;
    }

    public void applySearch(String search, boolean force) {
        if (!force && this.state.getSearch().equals(search)) {
            return;
        }
        this.state.filterNodes.clear();
        this.state.updateSearch(search);
        if (search.isEmpty()) {
            this.state.openSearch.clear();
            this.replaceEntries(this.state.getNodes());
            this.state.nodes.forEach(this::expandChildren);
            return;
        }
        String actualSearch = search.toLowerCase(Locale.ROOT);
        ObjectOpenHashSet filter = new ObjectOpenHashSet();
        ObjectLinkedOpenHashSet potentialNodes = new ObjectLinkedOpenHashSet();
        for (TreeEntry node : this.state.getNodes()) {
            node.iterateEach(arg_0 -> this.lambda$applySearch$0(actualSearch, (Set)potentialNodes, (Set)filter, arg_0));
        }
        if (!force) {
            this.state.openSearch.clear();
            this.state.openSearch.addAll(filter);
        }
        this.replaceEntries(potentialNodes);
        potentialNodes.forEach(this::expandChildren);
        this.setScrollAmount(this.getScrollAmount());
    }

    private void findParent(T node, Set<T> set, Set<T> filter) {
        T current = node;
        while (((TreeEntry)current).parent() != null) {
            this.state.filterNodes.add(current);
            current = ((TreeEntry)current).parent();
            filter.add(current);
        }
        set.add(current);
    }

    public void expand(T node) {
        int index = this.children().indexOf(node);
        if (index != -1 && this.state.open((TreeEntry<T>)node)) {
            this.addEntries(index + 1, this.state.filterNodes(((TreeEntry)node).childNodes));
            for (TreeEntry child : ((TreeEntry)node).childNodes) {
                if (!this.state.isOpen(child)) continue;
                this.expandChildren(child);
            }
        }
    }

    public void shrink(T node) {
        if (this.state.close((TreeEntry<T>)node)) {
            this.shrinkChildren(node);
        }
    }

    protected void expandChildren(T node) {
        int index = this.children().indexOf(node);
        if (index != -1 && this.state.isOpen((TreeEntry<T>)node)) {
            this.addEntries(index + 1, this.state.filterNodes(((TreeEntry)node).childNodes));
            for (TreeEntry child : ((TreeEntry)node).childNodes) {
                if (!this.state.isOpen(child)) continue;
                this.expandChildren(child);
            }
        }
    }

    protected void shrinkChildren(T node) {
        this.children().removeAll(((TreeEntry)node).childNodes);
        ((TreeEntry)node).childNodes.forEach(this::shrinkChildren);
        this.heightCache = -1;
    }

    @Override
    protected void bindToSelf(T element) {
        super.bindToSelf(element);
        ((TreeEntry)element).owner = this;
        this.heightCache = -1;
    }

    private /* synthetic */ void lambda$applySearch$0(String actualSearch, Set potentialNodes, Set filter, TreeEntry T) {
        if (T.containsSearch(actualSearch)) {
            this.findParent(T, potentialNodes, filter);
        }
    }

    public static class TreeState<T extends TreeEntry<T>> {
        List<T> nodes = new ObjectArrayList();
        Set<T> openNodes = new ObjectOpenHashSet();
        Set<T> openSearch = new ObjectOpenHashSet();
        Set<T> filterNodes = new ObjectOpenHashSet();
        String search = "";
        int top = 50;
        int bottom = 36;
        int height = 24;
        int rowWidth = 220;
        SmoothDouble scrollAmount = new SmoothDouble(0.25);
        boolean frame;
        PregenTreeList<T> owner;

        public TreeState() {
        }

        public TreeState(int height) {
            this.height = height;
        }

        @SafeVarargs
        public TreeState(T ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
        }

        public TreeState(List<T> nodes) {
            this.nodes.addAll(nodes);
        }

        @SafeVarargs
        public TreeState(int height, T ... nodes) {
            this.height = height;
            this.nodes.addAll(Arrays.asList(nodes));
        }

        public TreeState(int height, List<T> nodes) {
            this.nodes.addAll(nodes);
            this.height = height;
        }

        public TreeState<T> add(T ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
            return this;
        }

        public TreeState<T> add(List<T> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public TreeState<T> replaceNodes(List<T> nodes) {
            this.nodes.clear();
            this.nodes.addAll(nodes);
            this.openNodes.clear();
            if (this.owner != null) {
                this.owner.applySearch(this.search, true);
            }
            return this;
        }

        public TreeState<T> sort(Comparator<T> sorter) {
            this.nodes.sort(sorter);
            if (this.owner != null) {
                this.owner.applySearch(this.search, true);
            }
            return this;
        }

        public TreeState<T> setItemHeight(int newHeight) {
            this.height = newHeight;
            return this;
        }

        public TreeState<T> setRowWidth(int rowWidth) {
            this.rowWidth = rowWidth;
            return this;
        }

        public TreeState<T> setTopPadding(int value) {
            this.top = value;
            return this;
        }

        public TreeState<T> setBottomPadding(int value) {
            this.bottom = value;
            return this;
        }

        public TreeState<T> setFrame(boolean frame) {
            this.frame = frame;
            return this;
        }

        public double getScrollAmount() {
            return this.owner != null && this.owner.isScrolling() ? this.scrollAmount.getTarget() : this.scrollAmount.getValue();
        }

        public TreeState<T> setScrollAmount(double value) {
            this.scrollAmount.setTarget(value);
            return this;
        }

        public int getTopPadding() {
            return this.top;
        }

        public int getBottomPadding() {
            return this.bottom;
        }

        public int getRowWidth() {
            return this.rowWidth;
        }

        public int getItemHeight() {
            return this.height;
        }

        public boolean isFramed() {
            return this.frame;
        }

        void setOwner(PregenTreeList<T> owner) {
            this.owner = owner;
        }

        public PregenTreeList<T> getOwner() {
            return this.owner;
        }

        public boolean isSearching() {
            return this.search != null && !this.search.isEmpty();
        }

        public TreeState<T> search(String search) {
            if (this.owner != null) {
                this.owner.applySearch(search, false);
            } else {
                this.search = search;
            }
            return this;
        }

        public TreeState<T> updateSearch() {
            if (this.owner != null) {
                String newSearch = this.search;
                this.search = "928239023290\u00c3\u0192\u00c6\u2019\u00c3\u2020\u00e2\u20ac\u2122\u00c3\u0192\u00e2\u20ac\u00a6\u00c3\u201a\u00c2\u00b893\u00c3\u0192\u00c6\u2019\u00c3\u2020\u00e2\u20ac\u2122\u00c3\u0192\u00e2\u20ac\u00a6\u00c3\u201a\u00c2\u00b82131023\u00c3\u0192\u00c6\u2019\u00c3\u2020\u00e2\u20ac\u2122\u00c3\u0192\u00e2\u20ac\u00a6\u00c3\u201a\u00c2\u00b810391283128903810298310283128310\u00c3\u0192\u00c6\u2019\u00c3\u2020\u00e2\u20ac\u2122\u00c3\u0192\u00e2\u20ac\u00a6\u00c3\u201a\u00c2\u00b82832\u00c3\u0192\u00c6\u2019\u00c3\u2020\u00e2\u20ac\u2122\u00c3\u0192\u00e2\u20ac\u00a6\u00c3\u201a\u00c2\u00b8032\u00c3\u0192\u00c6\u2019\u00c3\u2020\u00e2\u20ac\u2122\u00c3\u0192\u00e2\u20ac\u00a6\u00c3\u201a\u00c2\u00b809";
                this.owner.applySearch(newSearch, false);
            }
            return this;
        }

        void updateSearch(String search) {
            this.search = search;
        }

        public String getSearch() {
            return this.search;
        }

        public List<T> getNodes() {
            return this.nodes;
        }

        public void expandNode(T node) {
            if (this.owner == null) {
                return;
            }
            this.owner.expand(node);
        }

        public void shrinkNode(T node) {
            if (this.owner == null) {
                return;
            }
            this.owner.shrink(node);
        }

        public List<T> filterNodes(List<T> nodes) {
            if (this.filterNodes.isEmpty()) {
                return nodes;
            }
            ObjectArrayList result = new ObjectArrayList();
            for (TreeEntry entry : nodes) {
                if (!this.filterNodes.contains(entry)) continue;
                result.add(entry);
            }
            return result;
        }

        public boolean isOpen(TreeEntry<T> node) {
            return this.isSearching() ? this.openSearch.contains(node) : this.openNodes.contains(node);
        }

        public boolean open(TreeEntry<T> node) {
            return this.isSearching() ? this.openSearch.add(node) : this.openNodes.add(node);
        }

        public boolean close(TreeEntry<T> node) {
            return this.isSearching() ? this.openSearch.remove(node) : this.openNodes.remove(node);
        }
    }

    public static abstract class TreeEntry<T extends TreeEntry<T>>
    extends DynamicPregenList.DynamicEntry<T>
    implements BasePregenScreen.ITooltipProvider {
        PregenTreeList<T> owner;
        TreeEntry<T> parent;
        List<T> childNodes = new ObjectArrayList();
        List<GuiEventListener> children = new ObjectArrayList();
        PregenButton openNode = this.addChild(new PregenButton(0, 0, 14, 14, (Component)TextUtil.literal("+"), this::toggle));
        boolean wasOpen = false;

        public T addChildNode(T child) {
            this.childNodes.add(child);
            ((TreeEntry)child).parent = this;
            return (T)this;
        }

        protected <E extends GuiEventListener> E addChild(E child) {
            this.children.add(child);
            return child;
        }

        @Override
        public void provideTooltips(Consumer<Component> tooltips) {
            for (GuiEventListener listener : this.children) {
                if (!(listener instanceof BasePregenScreen.ITooltipProvider)) continue;
                ((BasePregenScreen.ITooltipProvider)listener).provideTooltips(tooltips);
            }
        }

        public boolean isLeaf() {
            return this.childNodes.isEmpty();
        }

        protected List<T> childNodes() {
            return this.childNodes;
        }

        protected T parent() {
            return (T)this.parent;
        }

        protected boolean areGridChildren() {
            return false;
        }

        protected int getGridWidth() {
            return 0;
        }

        protected abstract boolean containsSearch(String var1);

        protected boolean searchResourceLocation(String searchString, ResourceLocation id) {
            String[] split = id.getPath().split("[ -_]");
            int m = split.length;
            for (int i = 0; i < m; ++i) {
                if (!split[i].startsWith(searchString)) continue;
                return true;
            }
            return false;
        }

        public void toggle(Button button) {
            if (this.owner.state.isOpen(this)) {
                this.shrink();
                return;
            }
            this.expand();
        }

        public void expand() {
            this.owner.expand(this);
        }

        public void shrink() {
            this.owner.shrink(this);
        }

        void iterateEach(Consumer<T> node) {
            node.accept(this);
            for (TreeEntry entry : this.childNodes) {
                entry.iterateEach(node);
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return ObjectLists.emptyList();
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            boolean newState;
            boolean bl = this.openNode.visible = this.childNodes.size() > 0;
            if (this.openNode.visible && this.wasOpen != (newState = this.owner.state.isOpen(this))) {
                this.wasOpen = newState;
                this.openNode.setMessage((Component)TextUtil.literal(newState ? "-" : "+"));
            }
            this.openNode.setX(left + 1);
            this.openNode.setY(top + height / 2 - this.openNode.getHeight() / 2);
            this.openNode.render(graphics, mouseX, mouseY, partialTicks);
        }

        protected boolean isSearching() {
            return this.owner.state.isSearching();
        }
    }
}

