/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import pregenerator.base.impl.comp.PregenButton;

public class PregenButtonGroup {
    List<PregenButton> buttons = new ObjectArrayList();
    IntConsumer listener;
    int activeIndex = -1;

    public PregenButtonGroup(IntConsumer listener) {
        this.listener = listener;
    }

    public void clear() {
        for (PregenButton button : this.buttons) {
            if (button == null) continue;
            button.group = null;
        }
        this.buttons.clear();
    }

    public void addEmptyButton() {
        this.buttons.add(null);
    }

    public void addButton(PregenButton button) {
        if (this.activeIndex == -1 || this.activeIndex == this.buttons.size()) {
            button.active = false;
            this.activeIndex = this.buttons.size();
        }
        this.buttons.add(button);
        button.group = this;
    }

    public int getActiveIndex() {
        return this.activeIndex;
    }

    public void setActive(int index) {
        this.setActive(this.buttons.get(index));
    }

    public void setActive(PregenButton button) {
        int newIndex = this.buttons.indexOf(button);
        if (newIndex == -1 || newIndex == this.activeIndex) {
            return;
        }
        this.activeIndex = newIndex;
        button.active = false;
        for (PregenButton entry : this.buttons) {
            if (entry == button || entry == null) continue;
            entry.active = true;
        }
        if (this.listener == null) {
            return;
        }
        this.listener.accept(newIndex);
    }
}

