/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;

public class RenderHelper
implements IRenderHelper {
    public static final float TEXTURE_SCALE = 0.00390625f;
    private static final ResourceLocation BAR_BACKGROUND = ResourceLocation.parse((String)"textures/gui/sprites/boss_bar/pink_background.png");
    private static final ResourceLocation BAR_PROGRESS = ResourceLocation.parse((String)"textures/gui/sprites/boss_bar/pink_progress.png");
    Minecraft mc;
    Font render;
    GuiGraphics graphics;
    float width;

    @Override
    public void init(GuiGraphics graphcis) {
        this.mc = Minecraft.getInstance();
        this.render = this.mc.font;
        this.graphics = graphcis;
    }

    @Override
    public GuiGraphics getGraphics() {
        return this.graphics;
    }

    @Override
    public void setupCanvasSize(float width) {
        this.width = width;
    }

    @Override
    public void drawText(float x, float y, Align align, Component text) {
        float textScale = 0.5f;
        float invScale = 1.0f / textScale;
        PoseStack stack = this.graphics.pose();
        stack.pushPose();
        stack.translate(x - align.align(this.width), 0.0f, 0.0f);
        stack.scale(textScale, textScale, textScale);
        this.render.drawInBatch(text, align.align(this.render.width((FormattedText)text)), y * invScale, 0xFFFFFF, true, stack.last().pose(), (MultiBufferSource)this.graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.graphics.flush();
        stack.popPose();
    }

    @Override
    public void drawArea(float x, float y, float widht, float height) {
        Tesselator tes = Tesselator.getInstance();
        BufferBuilder buffer = tes.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float minX = 4.0f + x;
        float maxX = minX + widht;
        float minY = 4.0f + y;
        float maxY = minY + height;
        this.fillGradient(minX - 3.0f, minY - 4.0f, maxX + 3.0f, minY - 3.0f, -267386864, buffer);
        this.fillGradient(minX - 3.0f, maxY + 3.0f, maxX + 3.0f, maxY + 4.0f, -267386864, buffer);
        this.fillGradient(minX - 3.0f, minY - 3.0f, maxX + 3.0f, maxY + 3.0f, -267386864, buffer);
        this.fillGradient(minX - 4.0f, minY - 3.0f, minX - 3.0f, maxY + 3.0f, -267386864, buffer);
        this.fillGradient(maxX + 3.0f, minY - 3.0f, maxX + 4.0f, maxY + 3.0f, -267386864, buffer);
        this.fillGradient(minX - 3.0f, minY - 3.0f + 1.0f, minX - 3.0f + 1.0f, maxY + 3.0f - 1.0f, 0x505000FF, buffer);
        this.fillGradient(maxX + 2.0f, minY - 3.0f + 1.0f, maxX + 3.0f, maxY + 3.0f - 1.0f, 0x505000FF, buffer);
        this.fillGradient(minX - 3.0f, minY - 3.0f, maxX + 3.0f, minY - 3.0f + 1.0f, 0x505000FF, buffer);
        this.fillGradient(minX - 3.0f, maxY + 2.0f, maxX + 3.0f, maxY + 3.0f, 1344798847, buffer);
        GlStateManager._enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager._enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        GlStateManager._disableDepthTest();
        GlStateManager._disableBlend();
    }

    @Override
    public void drawTexture(float x, float y, float width, float height, float maxU, float maxV) {
        Tesselator test = Tesselator.getInstance();
        BufferBuilder builder = test.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        PoseStack stack = this.graphics.pose();
        stack.pushPose();
        stack.translate(0.0f, 0.0f, 100.0f);
        this.drawTexture(x, y, 0.0f, 0.0f, 256.0f * maxU, 256.0f * maxV, width, height, builder);
        stack.popPose();
        GlStateManager._enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferUploader.drawWithShader((MeshData)builder.build());
        GlStateManager._disableDepthTest();
    }

    @Override
    public void drawProgressBar(float x, float y, float width, float height, float progress, Component text) {
        progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
        Tesselator test = Tesselator.getInstance();
        BufferBuilder builder = test.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BAR_BACKGROUND);
        GlStateManager._enableDepthTest();
        this.drawTexture(x, y, 0.0f, 0.0f, 256.0f, 256.0f, width, height, builder);
        BufferUploader.drawWithShader((MeshData)builder.build());
        if (progress > 0.0f) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BAR_PROGRESS);
            builder = test.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            this.drawTexture(x, y, 0.0f, 0.0f, 256.0f * progress, 256.0f, width * progress, height, builder);
            BufferUploader.drawWithShader((MeshData)builder.build());
        }
        GlStateManager._disableDepthTest();
        this.drawText(x, y + 1.0f, Align.CENTER, text);
    }

    protected void fillGradient(float left, float top, float right, float bottom, int color, BufferBuilder buffer) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f stack = this.graphics.pose().last().pose();
        buffer.addVertex(stack, right, top, -10.0f).setColor(r, g, b, a);
        buffer.addVertex(stack, left, top, -10.0f).setColor(r, g, b, a);
        buffer.addVertex(stack, left, bottom, -10.0f).setColor(r, g, b, a);
        buffer.addVertex(stack, right, bottom, -10.0f).setColor(r, g, b, a);
    }

    public void drawTexture(float x, float y, float u, float v, float uWidth, float vHeight, float width, float height, BufferBuilder builder) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Matrix4f stack = this.graphics.pose().last().pose();
        builder.addVertex(stack, x, y + height, 0.0f).setUv(u * f, (v + vHeight) * f1);
        builder.addVertex(stack, x + width, y + height, 0.0f).setUv((u + uWidth) * f, (v + vHeight) * f1);
        builder.addVertex(stack, x + width, y, 0.0f).setUv((u + uWidth) * f, v * f1);
        builder.addVertex(stack, x, y, 0.0f).setUv(u * f, v * f1);
    }
}

