/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.comp.CycleButton;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenCheckBox;
import pregenerator.base.impl.comp.PregenList;
import pregenerator.base.impl.comp.PregenSlider;
import pregenerator.base.impl.comp.PregenText;
import pregenerator.base.impl.comp.PregenTreeList;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public abstract class BasePregenScreen
extends Screen {
    public static final DecimalFormat NUMBERS = TextUtil.NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS = TextUtil.FLOATING_NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS_EXTENDED = TextUtil.FLOATING_NUMBERS_EXTENDED;
    private static final ScissorsStack STACK = new ScissorsStack();
    protected int centerX;
    protected int centerY;
    protected int tick;
    int lastMouseX = 0;
    int lastMouseY = 0;
    long lastCheck = 0L;
    int lastDrawnToolTipAmount = 0;
    boolean renderTooltip = false;

    protected BasePregenScreen(Component titleIn) {
        super(titleIn);
    }

    protected void init() {
        super.init();
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.clearWidgets();
    }

    public void tick() {
        super.tick();
        ++this.tick;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBack(graphics, mouseX, mouseY, partialTicks);
        this.renderWidgets(graphics, mouseX, mouseY, partialTicks);
        this.renderFront(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderBack(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable widget : this.renderables) {
            widget.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderFront(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void collectTooltips(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Consumer<Component> tooltips) {
    }

    public void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ObjectArrayList tooltips = new ObjectArrayList();
        if (mouseX != Integer.MAX_VALUE && mouseY != Integer.MAX_VALUE) {
            for (GuiEventListener listener : this.children()) {
                if (!(listener instanceof ITooltipProvider)) continue;
                ((ITooltipProvider)listener).provideTooltips(arg_0 -> this.lambda$renderTooltips$0((List)tooltips, mouseX, arg_0));
            }
            this.collectTooltips(graphics, mouseX, mouseY, partialTicks, arg_0 -> this.lambda$renderTooltips$1((List)tooltips, mouseX, arg_0));
        }
        if (!this.renderTooltip && (this.lastMouseX != mouseX || this.lastMouseY != mouseY) || tooltips.isEmpty()) {
            this.lastCheck = System.currentTimeMillis();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastDrawnToolTipAmount = 0;
            if (tooltips.isEmpty()) {
                this.renderTooltip = false;
            }
            return;
        }
        if (System.currentTimeMillis() - this.lastCheck < (long)PregenConfig.INSTANCE.tooltipDelay.get()) {
            this.lastDrawnToolTipAmount = 0;
            return;
        }
        this.renderTooltip = true;
        this.lastDrawnToolTipAmount = 0;
        graphics.renderTooltip(this.font, (List)tooltips, mouseX, mouseY);
        this.lastDrawnToolTipAmount = tooltips.size();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        return super.mouseScrolled(mouseX, mouseY, xScroll, yScroll);
    }

    public PregenButton button(int x, int y, int width, int height, Component text, Button.OnPress press) {
        return (PregenButton)this.addRenderableWidget((GuiEventListener)new PregenButton(x, y, width, height, text, press));
    }

    public PregenButton button(int x, int y, int width, int height, Align horizontal, Align vertical, Component text, Button.OnPress press) {
        return (PregenButton)this.addRenderableWidget((GuiEventListener)new PregenButton(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, text, press));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, List<T> values, T initial, Function<T, Component> displayFunction, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.addRenderableWidget((GuiEventListener)new CycleButton<T>(x, y, width, height, values, initial, displayFunction, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, Align horizontal, Align vertical, List<T> values, T initial, Function<T, Component> displayFunction, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.addRenderableWidget((GuiEventListener)new CycleButton<T>(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, values, initial, displayFunction, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, CycleButton.CycleState<T> state, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.addRenderableWidget((GuiEventListener)new CycleButton<T>(x, y, width, height, state, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, Align horizontal, Align vertical, CycleButton.CycleState<T> state, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.addRenderableWidget((GuiEventListener)new CycleButton<T>(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state, result));
    }

    public <T extends PregenTreeList.TreeEntry<T>> PregenTreeList<T> tree(int width, int height, int startY, int endY, PregenTreeList.TreeState<T> state) {
        return (PregenTreeList)this.addRenderableWidget((GuiEventListener)new PregenTreeList<T>(this, width, height, startY, endY, state));
    }

    public <T extends PregenTreeList.TreeEntry<T>> PregenTreeList<T> tree(PregenTreeList.TreeState<T> state) {
        return (PregenTreeList)this.addRenderableWidget((GuiEventListener)new PregenTreeList<T>(this, state));
    }

    public <T extends PregenList.ListEntry<T>> PregenList<T> list(int width, int height, int startY, int endY, PregenList.ListState<T> state) {
        return (PregenList)this.addRenderableWidget((GuiEventListener)new PregenList<T>(this, width, height, startY, endY, state));
    }

    public <T extends PregenList.ListEntry<T>> PregenList<T> list(PregenList.ListState<T> state) {
        return (PregenList)this.addRenderableWidget((GuiEventListener)new PregenList<T>(this, state));
    }

    public PregenCheckBox checkbox(int x, int y, int width, int height, PregenCheckBox.CheckboxState state) {
        return (PregenCheckBox)this.addRenderableWidget((GuiEventListener)new PregenCheckBox(x, y, width, height, state));
    }

    public PregenCheckBox checkbox(int x, int y, int width, int height, Align horizontal, Align vertical, PregenCheckBox.CheckboxState state) {
        return (PregenCheckBox)this.addRenderableWidget((GuiEventListener)new PregenCheckBox(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public PregenText text(int x, int y, int width, int height, PregenText.TextState state) {
        return (PregenText)this.addRenderableWidget((GuiEventListener)new PregenText(this.font, x, y, width, height, state));
    }

    public PregenText text(int x, int y, int width, int height, Align horizontal, Align vertical, PregenText.TextState state) {
        return (PregenText)this.addRenderableWidget((GuiEventListener)new PregenText(this.font, this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public PregenSlider slider(int x, int y, int width, int height, PregenSlider.SliderState state) {
        return (PregenSlider)this.addRenderableWidget((GuiEventListener)new PregenSlider(x, y, width, height, state));
    }

    public PregenSlider slider(int x, int y, int width, int height, Align horizontal, Align vertical, PregenSlider.SliderState state) {
        return (PregenSlider)this.addRenderableWidget((GuiEventListener)new PregenSlider(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public Screen createChoice(Component mainline, Component description, BooleanConsumer result) {
        return new ConfirmScreen(result, mainline, description);
    }

    public Screen createChoice(Component mainline, Component description, Component yesButton, Component noButton, BooleanConsumer result) {
        return new ConfirmScreen(result, mainline, description, yesButton, noButton);
    }

    protected Button.OnPress emptyClick() {
        return T -> {};
    }

    protected <T> Consumer<T> emptyAction() {
        return T -> {};
    }

    protected List<ResourceKey<Level>> dimensions() {
        return new ObjectArrayList((Collection)Minecraft.getInstance().player.connection.levels());
    }

    protected ResourceKey<Level> defaultDimension() {
        return Minecraft.getInstance().level.dimension();
    }

    protected void setScreen(Screen screen) {
        Minecraft.getInstance().setScreen(screen);
    }

    protected int getAlignedX(Align align) {
        switch (align) {
            case CENTER: {
                return this.centerX;
            }
            case END: {
                return this.width;
            }
            case START: {
                return 0;
            }
        }
        return 0;
    }

    protected int getAlignedY(Align align) {
        switch (align) {
            case CENTER: {
                return this.centerY;
            }
            case END: {
                return this.height;
            }
            case START: {
                return 0;
            }
        }
        return 0;
    }

    public void drawText(GuiGraphics graphics, Component text, float x, float y, Align align, int color) {
        float offset = align.align(this.font.width((FormattedText)text));
        this.font.drawInBatch(text, (float)this.centerX + x + offset, (float)this.centerY + y, color, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.flush();
    }

    public void drawSplitText(GuiGraphics graphics, Component text, float x, float y, Align align, int color, int maxLength) {
        Matrix4f matrix = graphics.pose().last().pose();
        MultiBufferSource.BufferSource buffer = graphics.bufferSource();
        for (FormattedCharSequence line : this.font.split((FormattedText)text, maxLength)) {
            float offset = align.align(this.font.width(line));
            this.font.drawInBatch(line, (float)this.centerX + x + offset, (float)this.centerY + y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            Objects.requireNonNull(this.font);
            y += 9.0f;
        }
        graphics.flush();
    }

    public void drawUnalignedText(GuiGraphics graphics, Component text, float x, float y, Align align, int color) {
        float offset = align.align(this.font.width((FormattedText)text));
        this.font.drawInBatch(text, x + offset, y, color, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.flush();
    }

    public void drawScrollText(GuiGraphics graphics, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        BasePregenScreen.drawScrollingString(graphics, this.font, text, x + (float)this.centerX, y + (float)this.centerY, width, height, align, color, seed);
    }

    public void drawUnalignedScrollText(GuiGraphics graphics, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        BasePregenScreen.drawScrollingString(graphics, this.font, text, x, y, width, height, align, color, seed);
    }

    public static void drawScrollingString(GuiGraphics graphics, Font font, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        int textWidth = font.width((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.getMillis() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            BasePregenScreen.pushScissors((int)x, (int)y, (int)width, (int)height);
            float f = x - align.align(width) + align.align(textWidth) + (float)Mth.lerp((double)offset, (double)0.0, (double)diff);
            float f2 = y + height / 2.0f;
            Objects.requireNonNull(font);
            font.drawInBatch(text, f, f2 - (float)(9 / 3), color, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            graphics.flush();
            BasePregenScreen.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        float f = x - align.align(width) + offset;
        float f3 = y + height / 2.0f;
        Objects.requireNonNull(font);
        font.drawInBatch(text, f, f3 - (float)(9 / 3), color, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.flush();
    }

    public static void drawScrollingShadowString(GuiGraphics graphics, Font font, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        int textWidth = font.width((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.getMillis() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            BasePregenScreen.pushScissors((int)x, (int)y, (int)width, (int)height);
            float f = x - align.align(width) + align.align(textWidth) + (float)Mth.lerp((double)offset, (double)0.0, (double)diff);
            float f2 = y + height / 2.0f;
            Objects.requireNonNull(font);
            font.drawInBatch(text, f, f2 - (float)(9 / 3), color, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            graphics.flush();
            BasePregenScreen.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        float f = x - align.align(width) + offset;
        float f3 = y + height / 2.0f;
        Objects.requireNonNull(font);
        font.drawInBatch(text, f, f3 - (float)(9 / 3), color, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.flush();
    }

    public static void pushScissors(float x, float y, float width, float height) {
        BasePregenScreen.pushScissors(new Rect(x, y, width, height));
    }

    public static void pushScissors(Rect rect) {
        STACK.push(rect);
        BasePregenScreen.applyScissors(rect);
    }

    public static void popScissors() {
        BasePregenScreen.applyScissors(STACK.pop());
    }

    private static void applyScissors(Rect rect) {
        if (rect == null) {
            RenderSystem.disableScissor();
            return;
        }
        Window window = Minecraft.getInstance().getWindow();
        float bottom = rect.maxY;
        double scaledHeight = (double)window.getHeight() / (double)window.getGuiScaledHeight();
        double scaledWidth = (double)window.getWidth() / (double)window.getGuiScaledWidth();
        RenderSystem.enableScissor((int)((int)((double)rect.getX() * scaledWidth)), (int)((int)((double)window.getHeight() - (double)bottom * scaledHeight)), (int)((int)((double)rect.getWidth() * scaledWidth)), (int)((int)((double)rect.getHeigth() * scaledHeight)));
    }

    public static void renderEntityInGui(Entity entity, GuiGraphics graphics, int xPos, int yPos, float scale, float rotation) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)(xPos + 8), (float)(yPos + 26), 50.0f);
        matrixStack.scale(-scale, scale, scale);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        if (rotation != 0.0f) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(rotation));
        }
        Lighting.setupForFlatItems();
        if (!(entity instanceof Player)) {
            entity.setXRot(0.0f);
            entity.xRotO = 0.0f;
            entity.setYRot(0.0f);
            entity.yRotO = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.yBodyRotO = 0.0f;
                living.yBodyRot = 0.0f;
                living.yHeadRot = 0.0f;
                living.yHeadRotO = 0.0f;
            }
        }
        matrixStack.translate(0.0f, (entity.getVehicle() == null ? 0.0f : (float)entity.getVehicle().getPassengerRidingPosition((Entity)entity).y) + (entity instanceof HangingEntity ? 0.5f : 0.0f), 0.0f);
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        boolean prev = dispatcher.shouldRenderHitBoxes();
        try {
            float value = 1.0f;
            float yOff = 0.5f;
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                value = -((float)item.getAge() + item.bobOffs * 10.0f) - 25.0f;
                yOff = 0.25f;
            }
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            dispatcher.setRenderShadow(false);
            dispatcher.setRenderHitBoxes(false);
            dispatcher.render(entity, 0.0, (double)yOff, 0.0, 0.0f, value, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
            buffer.endBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dispatcher.setRenderShadow(true);
        dispatcher.setRenderHitBoxes(prev);
        matrixStack.popPose();
    }

    public void drawBuffer(BufferBuilder builder) {
        MeshData data = builder.build();
        if (data == null) {
            return;
        }
        BufferUploader.drawWithShader((MeshData)data);
    }

    public void renderTextureWithOffset(GuiGraphics graphics, float x, float y, float width, float height) {
        this.renderTexture(graphics, x + (float)this.centerX, y + (float)this.centerY, width, height);
    }

    public void renderTexture(GuiGraphics graphics, float x, float y, float width, float height, TextureAtlasSprite texture, BufferBuilder builder) {
        if (texture == null) {
            return;
        }
        Matrix4f matrix = graphics.pose().last().pose();
        builder.addVertex(matrix, x, y + height, 0.0f).setUv(texture.getU0(), texture.getV1());
        builder.addVertex(matrix, x + width, y + height, 0.0f).setUv(texture.getU1(), texture.getV1());
        builder.addVertex(matrix, x + width, y, 0.0f).setUv(texture.getU1(), texture.getV0());
        builder.addVertex(matrix, x, y, 0.0f).setUv(texture.getU0(), texture.getV0());
    }

    public static void drawTextureRegion(GuiGraphics graphics, float x, float y, float texX, float texY, float width, float height, float texWidth, float texHeight, float textureWidth, float textureHeight) {
        Matrix4f matrix = graphics.pose().last().pose();
        float maxX = x + width;
        float maxY = y + height;
        float t_minX = texX / textureWidth;
        float t_minY = texY / textureHeight;
        float t_maxX = (texX + texWidth) / textureWidth;
        float t_maxY = (texY + texHeight) / textureHeight;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        bufferbuilder.addVertex(matrix, x, maxY, 0.0f).setUv(t_minX, t_maxY);
        bufferbuilder.addVertex(matrix, maxX, maxY, 0.0f).setUv(t_maxX, t_maxY);
        bufferbuilder.addVertex(matrix, maxX, y, 0.0f).setUv(t_maxX, t_minY);
        bufferbuilder.addVertex(matrix, x, y, 0.0f).setUv(t_minX, t_minY);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public void renderTexture(GuiGraphics graphics, float x, float y, float width, float height) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = graphics.pose().last().pose();
        bufferbuilder.addVertex(matrix, x, y + height, 0.0f).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(matrix, x + width, y + height, 0.0f).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix, x + width, y, 0.0f).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(matrix, x, y, 0.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public static void drawFrame(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        BasePregenScreen.drawQuadArea(graphics, minX, minY, maxX, minY + 1.0f, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(graphics, minX, maxY, maxX, maxY + 1.0f, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(graphics, minX, minY, minX + 1.0f, maxY, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(graphics, maxX, minY, maxX + 1.0f, maxY, bufferbuilder, color);
        GlStateManager._enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        GlStateManager._disableBlend();
    }

    public void drawSimpleRect(GuiGraphics graphics, int minX, int minY, int maxX, int maxY, int color, boolean drop) {
        if (drop) {
            graphics.fill(minX - 1, minY - 1, maxX, maxY, -13158601);
            graphics.fill(minX, minY, maxX + 1, maxY + 1, -1);
        } else {
            graphics.fill(minX, minY, maxX + 1, maxY + 1, -13158601);
            graphics.fill(minX - 1, minY - 1, maxX, maxY, -1);
        }
        graphics.fill(minX, minY, maxX, maxY, color);
    }

    public void drawRectangle(GuiGraphics graphics, int xSize, int ySize, int xOffset, int yOffset, int color, boolean drop) {
        int minX = this.centerX - xSize + xOffset;
        int minY = this.centerY - ySize + yOffset;
        int maxX = this.centerX + xSize + xOffset;
        int maxY = this.centerY + ySize + yOffset;
        if (drop) {
            graphics.fill(minX - 1, minY - 1, maxX, maxY, -13158601);
            graphics.fill(minX, minY, maxX + 1, maxY + 1, -1);
        } else {
            graphics.fill(minX, minY, maxX + 1, maxY + 1, -13158601);
            graphics.fill(minX - 1, minY - 1, maxX, maxY, -1);
        }
        graphics.fill(minX, minY, maxX, maxY, color);
    }

    public boolean isInsideBox(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= this.centerX + minX && mouseX < this.centerX + maxX && mouseY >= this.centerY + minY && mouseY <= this.centerY + maxY;
    }

    public void drawColorRegion(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        GlStateManager._enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f matrix = graphics.pose().last().pose();
        bufferbuilder.addVertex(matrix, minX, maxY, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(matrix, maxX, maxY, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(matrix, maxX, minY, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(matrix, minX, minY, 0.0f).setColor(f, f1, f2, f3);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        GlStateManager._disableBlend();
    }

    public static void drawQuadArea(GuiGraphics graphics, float left, float top, float right, float bottom, BufferBuilder builder, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        Matrix4f stack = graphics.pose().last().pose();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        builder.addVertex(stack, left, bottom, 0.0f).setColor(f, f1, f2, f3);
        builder.addVertex(stack, right, bottom, 0.0f).setColor(f, f1, f2, f3);
        builder.addVertex(stack, right, top, 0.0f).setColor(f, f1, f2, f3);
        builder.addVertex(stack, left, top, 0.0f).setColor(f, f1, f2, f3);
    }

    public void sendToServer(IPregenPacket packet) {
        NetworkManager.INSTANCE.sendToServer(packet);
    }

    public static String convertText(Component component) {
        StringConsumer consumer = new StringConsumer();
        component.getVisualOrderText().accept((FormattedCharSink)consumer);
        return consumer.getBuilder().toString();
    }

    private /* synthetic */ void lambda$renderTooltips$1(List tooltips, int mouseX, Component T) {
        tooltips.addAll(this.font.split((FormattedText)T, Math.max(mouseX, this.width - mouseX) - 20));
    }

    private /* synthetic */ void lambda$renderTooltips$0(List tooltips, int mouseX, Component T) {
        tooltips.addAll(this.font.split((FormattedText)T, Math.max(mouseX, this.width - mouseX) - 20));
    }

    public static interface ITooltipProvider {
        public void provideTooltips(Consumer<Component> var1);
    }

    public static class Rect {
        float minX;
        float minY;
        float maxX;
        float maxY;

        public Rect(float x, float y, float width, float heigth) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + width;
            this.maxY = y + heigth;
        }

        public void limit(Rect rect) {
            this.minX = Math.max(0.0f, Math.max(rect.minX, this.minX));
            this.minY = Math.max(0.0f, Math.max(rect.minY, this.minY));
            this.maxX = Math.max(this.minX, Math.min(rect.maxX, this.maxX));
            this.maxY = Math.max(this.minY, Math.min(rect.maxY, this.maxY));
        }

        public float getX() {
            return this.minX;
        }

        public float getY() {
            return this.minY;
        }

        public float getWidth() {
            return this.maxX - this.minX;
        }

        public float getHeigth() {
            return this.maxY - this.minY;
        }
    }

    public static class ScissorsStack {
        Deque<Rect> stack = new ArrayDeque<Rect>();

        public void push(Rect owner) {
            if (this.stack.isEmpty()) {
                this.stack.push(owner);
                return;
            }
            owner.limit(this.stack.peek());
            this.stack.push(owner);
        }

        public Rect pop() {
            this.stack.pop();
            return this.stack.peek();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StringConsumer
    implements FormattedCharSink {
        StringBuilder builder = new StringBuilder();
        ChatFormatting formatting = ChatFormatting.RESET;

        public boolean accept(int index, Style style, int character) {
            ChatFormatting format = this.getFormat(style);
            if (format != this.formatting) {
                this.formatting = format;
                this.builder.append(format.toString());
            }
            this.builder.append((char)character);
            return true;
        }

        protected ChatFormatting getFormat(Style style) {
            ChatFormatting format = style.getColor() == null ? null : ChatFormatting.getByName((String)style.getColor().serialize());
            return format == null ? ChatFormatting.RESET : format;
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }
    }
}

