/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.init;

import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.util.init.ColoredDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.init.GroupingDeferredHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ColoredWoodTypeDeferredHolder<R, T extends R>
implements GroupingDeferredHolder<R, T> {
    private final Map<BibliocraftWoodType, ColoredDeferredHolder<R, T>> map = new LinkedHashMap<BibliocraftWoodType, ColoredDeferredHolder<R, T>>();

    public ColoredWoodTypeDeferredHolder(DeferredRegister<R> register, String suffix, BiFunction<BibliocraftWoodType, DyeColor, ? extends T> creator) {
        for (BibliocraftWoodType type : BibliocraftApi.getWoodTypeRegistry().getAll()) {
            this.map.put(type, new ColoredDeferredHolder<R, Object>(register, type.getRegistrationPrefix() + "_" + suffix, color -> creator.apply(type, (DyeColor)color)));
        }
    }

    public ColoredDeferredHolder<R, T> element(BibliocraftWoodType type) {
        return this.map.get(type);
    }

    public DeferredHolder<R, T> holder(BibliocraftWoodType type, DyeColor color) {
        return this.map.get(type).holder(color);
    }

    public T get(BibliocraftWoodType type, DyeColor color) {
        return this.map.get(type).get(color);
    }

    public ResourceLocation id(BibliocraftWoodType type, DyeColor color) {
        return this.map.get(type).id(color);
    }

    public Collection<ColoredDeferredHolder<R, T>> elements() {
        return this.map.values();
    }

    public Map<BibliocraftWoodType, ColoredDeferredHolder<R, T>> map() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Collection<DeferredHolder<R, T>> holders() {
        return this.elements().stream().flatMap(holder -> holder.holders().stream()).toList();
    }

    @Override
    public Collection<T> values() {
        return this.elements().stream().flatMap(holder -> holder.values().stream()).toList();
    }

    @Override
    public Collection<ResourceLocation> ids() {
        return this.elements().stream().flatMap(holder -> holder.ids().stream()).toList();
    }
}

