/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util;

import com.github.minecraftschurlimods.bibliocraft.content.fancylight.AbstractFancyLightBlock;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public final class DatagenUtil {
    public static final Map<DyeColor, ResourceLocation> CANDLE_TEXTURES = (Map)Util.make(new HashMap(), map -> Arrays.stream(DyeColor.values()).forEach(color -> map.put(color, BCUtil.mcLoc("block/" + color.getName() + "_candle_lit"))));
    public static final Map<DyeColor, ResourceLocation> GLASS_TEXTURES = (Map)Util.make(new HashMap(), map -> Arrays.stream(DyeColor.values()).forEach(color -> map.put(color, BCUtil.mcLoc("block/" + color.getName() + "_stained_glass"))));
    public static final Map<DyeColor, ResourceLocation> WOOL_TEXTURES = (Map)Util.make(new HashMap(), map -> Arrays.stream(DyeColor.values()).forEach(color -> map.put(color, BCUtil.mcLoc("block/" + color.getName() + "_wool"))));

    public static String toTranslation(String s) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (char c : s.toCharArray()) {
            if (c == '_') {
                builder.append(' ');
                first = true;
                continue;
            }
            if (first) {
                builder.append(Character.toUpperCase(c));
                first = false;
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        return builder.toString();
    }

    public static void horizontalBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, String name, ResourceLocation parent, ResourceLocation texture) {
        DatagenUtil.horizontalBlockModel(provider, block, $ -> ((BlockModelBuilder)provider.models().withExistingParent(name, parent)).texture("texture", texture), true);
    }

    public static void horizontalBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, String name, ResourceLocation parent, ResourceLocation texture, boolean uvLock) {
        DatagenUtil.horizontalBlockModel(provider, block, $ -> ((BlockModelBuilder)provider.models().withExistingParent(name, parent)).texture("texture", texture), uvLock);
    }

    public static void horizontalBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, Function<BlockState, ModelFile> modelFunction) {
        DatagenUtil.horizontalBlockModel(provider, block, modelFunction, true);
    }

    public static void horizontalBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, Function<BlockState, ModelFile> modelFunction, boolean uvLock) {
        provider.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).uvLock(uvLock).build());
    }

    public static void doubleHighHorizontalBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, ModelFile bottom, ModelFile top, boolean uvLock) {
        DatagenUtil.horizontalBlockModel(provider, block, state -> state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? bottom : top, uvLock);
    }

    public static void openClosedHorizontalBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, ModelFile open, ModelFile closed, boolean uvLock) {
        DatagenUtil.horizontalBlockModel(provider, block, state -> (Boolean)state.getValue((Property)BlockStateProperties.OPEN) != false ? open : closed, uvLock);
    }

    public static void fancyLightBlockModel(BlockStateProvider provider, Supplier<? extends Block> block, ModelFile standing, ModelFile hanging, ModelFile wall, boolean uvLock) {
        DatagenUtil.horizontalBlockModel(provider, block, state -> switch ((AbstractFancyLightBlock.Type)((Object)((Object)state.getValue(AbstractFancyLightBlock.TYPE)))) {
            default -> throw new MatchException(null, null);
            case AbstractFancyLightBlock.Type.STANDING -> standing;
            case AbstractFancyLightBlock.Type.HANGING -> hanging;
            case AbstractFancyLightBlock.Type.WALL -> wall;
        }, uvLock);
    }

    public static LootTable.Builder createStandardTable(LootPoolSingletonContainer.Builder<?> builder) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder).when(ExplosionCondition.survivesExplosion()));
    }

    public static LootTable.Builder createDefaultTable(Block block) {
        return DatagenUtil.createStandardTable(LootItem.lootTableItem((ItemLike)block));
    }

    public static LootTable.Builder createNameableTable(Block block) {
        return DatagenUtil.createStandardTable(LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
    }

    public static LootTable.Builder createFancyArmorStandTable(Block block) {
        return DatagenUtil.createStandardTable(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)))).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
    }

    public static LootTable.Builder createGrandfatherClockTable(Block block) {
        return DatagenUtil.createStandardTable((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER))));
    }

    public static <T> void addAll(Registry<T> registry, Collection<? extends T> collection, TagsProvider.TagAppender<T> tag) {
        collection.stream().map(e -> ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)registry.getKey(e))).forEach(arg_0 -> tag.add(arg_0));
    }

    public static <T> void addAllOptional(Registry<T> registry, Collection<? extends T> collection, TagsProvider.TagAppender<T> tag) {
        collection.stream().map(arg_0 -> registry.getKey(arg_0)).forEach(arg_0 -> tag.addOptional(arg_0));
    }
}

