/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util;

import com.github.minecraftschurlimods.bibliocraft.client.screen.ClipboardScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.RedstoneBookScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.StockroomCatalogScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;

public final class ClientUtil {
    public static void openClipboardScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new ClipboardScreen(stack));
    }

    public static void openClockScreen(BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new ClockScreen(pos));
    }

    public static void openRedstoneBookScreen() {
        Minecraft.getInstance().setScreen((Screen)new RedstoneBookScreen());
    }

    public static void openStockroomCatalogScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new StockroomCatalogScreen(stack));
    }

    public static void setupCenteredBER(PoseStack stack, BlockEntity blockEntity) {
        stack.translate(0.5, 0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            stack.mulPose(Axis.YP.rotationDegrees(switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case Direction.SOUTH -> 0.0f;
                case Direction.EAST -> 90.0f;
                default -> 180.0f;
                case Direction.WEST -> 270.0f;
            }));
        }
    }

    public static void renderFixedItem(ItemStack item, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        ClientUtil.renderItem(item, stack, buffer, light, overlay, ItemDisplayContext.FIXED);
    }

    public static void renderGuiItem(ItemStack item, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        ClientUtil.renderItem(item, stack, buffer, light, overlay, ItemDisplayContext.GUI);
    }

    public static void renderItem(ItemStack item, PoseStack stack, MultiBufferSource buffer, int light, int overlay, ItemDisplayContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer renderer = minecraft.getItemRenderer();
        renderer.render(item, context, context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.THIRD_PERSON_LEFT_HAND, stack, buffer, light, overlay, renderer.getModel(item, (Level)minecraft.level, null, 0));
    }

    public static void renderBakedModel(BakedModel model, PoseStack stack, MultiBufferSource buffer, Level level, BlockPos pos, BlockState state, RandomSource random, ModelData modelData) {
        ModelBlockRenderer renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        int color = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)level, pos, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
        for (RenderType type : model.getRenderTypes(state, random, modelData)) {
            renderer.renderModel(stack.last(), buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)type, (boolean)false)), state, model, red, green, blue, light, OverlayTexture.NO_OVERLAY, modelData, type);
        }
    }
}

