/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.init;

import com.github.minecraftschurlimods.bibliocraft.content.bookcase.BookcaseBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.clipboard.ClipboardBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.cookiejar.CookieJarBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.dinnerplate.DinnerPlateBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.discrack.DiscRackBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.displaycase.DisplayCaseBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.fancyarmorstand.FancyArmorStandBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.label.LabelBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.potionshelf.PotionShelfBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.shelf.ShelfBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.swordpedestal.SwordPedestalBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.table.TableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.toolrack.ToolRackBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlocks;
import com.github.minecraftschurlimods.bibliocraft.init.BCRegistries;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface BCBlockEntities {
    public static final Supplier<BlockEntityType<BookcaseBlockEntity>> BOOKCASE = BCBlockEntities.register("bookcase", BookcaseBlockEntity::new, BCBlocks.BOOKCASE.holders());
    public static final Supplier<BlockEntityType<ClipboardBlockEntity>> CLIPBOARD = BCBlockEntities.register("clipboard", ClipboardBlockEntity::new, new Supplier[]{BCBlocks.CLIPBOARD});
    public static final Supplier<BlockEntityType<ClockBlockEntity>> CLOCK = BCBlockEntities.register("clock", ClockBlockEntity::new, BCUtil.mergeRaw(BCBlocks.FANCY_CLOCK.holders(), BCBlocks.WALL_FANCY_CLOCK.holders(), BCBlocks.GRANDFATHER_CLOCK.holders()));
    public static final Supplier<BlockEntityType<CookieJarBlockEntity>> COOKIE_JAR = BCBlockEntities.register("cookie_jar", CookieJarBlockEntity::new, new Supplier[]{BCBlocks.COOKIE_JAR});
    public static final Supplier<BlockEntityType<DinnerPlateBlockEntity>> DINNER_PLATE = BCBlockEntities.register("dinner_plate", DinnerPlateBlockEntity::new, new Supplier[]{BCBlocks.DINNER_PLATE});
    public static final Supplier<BlockEntityType<DiscRackBlockEntity>> DISC_RACK = BCBlockEntities.register("disc_rack", DiscRackBlockEntity::new, new Supplier[]{BCBlocks.DISC_RACK, BCBlocks.WALL_DISC_RACK});
    public static final Supplier<BlockEntityType<DisplayCaseBlockEntity>> DISPLAY_CASE = BCBlockEntities.register("display_case", DisplayCaseBlockEntity::new, BCUtil.mergeRaw(BCBlocks.DISPLAY_CASE.holders(), BCBlocks.WALL_DISPLAY_CASE.holders()));
    public static final Supplier<BlockEntityType<FancyArmorStandBlockEntity>> FANCY_ARMOR_STAND = BCBlockEntities.register("fancy_armor_stand", FancyArmorStandBlockEntity::new, BCUtil.merge(BCBlocks.FANCY_ARMOR_STAND.holders(), BCBlocks.IRON_FANCY_ARMOR_STAND));
    public static final Supplier<BlockEntityType<FancyCrafterBlockEntity>> FANCY_CRAFTER = BCBlockEntities.register("fancy_crafter", FancyCrafterBlockEntity::new, BCBlocks.FANCY_CRAFTER.holders());
    public static final Supplier<BlockEntityType<LabelBlockEntity>> LABEL = BCBlockEntities.register("label", LabelBlockEntity::new, BCBlocks.LABEL.holders());
    public static final Supplier<BlockEntityType<PotionShelfBlockEntity>> POTION_SHELF = BCBlockEntities.register("potion_shelf", PotionShelfBlockEntity::new, BCBlocks.POTION_SHELF.holders());
    public static final Supplier<BlockEntityType<ShelfBlockEntity>> SHELF = BCBlockEntities.register("shelf", ShelfBlockEntity::new, BCBlocks.SHELF.holders());
    public static final Supplier<BlockEntityType<SwordPedestalBlockEntity>> SWORD_PEDESTAL = BCBlockEntities.register("sword_pedestal", SwordPedestalBlockEntity::new, new Supplier[]{BCBlocks.SWORD_PEDESTAL});
    public static final Supplier<BlockEntityType<TableBlockEntity>> TABLE = BCBlockEntities.register("table", TableBlockEntity::new, BCBlocks.TABLE.holders());
    public static final Supplier<BlockEntityType<ToolRackBlockEntity>> TOOL_RACK = BCBlockEntities.register("tool_rack", ToolRackBlockEntity::new, BCBlocks.TOOL_RACK.holders());

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> supplier, Collection<? extends Supplier<? extends Block>> blocks) {
        return BCRegistries.BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])blocks.stream().map(Supplier::get).toList().toArray(new Block[0])).build(null));
    }

    @SafeVarargs
    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> supplier, Supplier<? extends Block> ... blocks) {
        return BCBlockEntities.register(name, supplier, List.of(blocks));
    }

    public static void init() {
    }
}

