/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.table;

import com.github.minecraftschurlimods.bibliocraft.content.table.TableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCFacingEntityBlock;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends BCFacingEntityBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    private static final VoxelShape NONE_SHAPE = ShapeUtil.combine(Shapes.box((double)0.0625, (double)0.875, (double)0.0, (double)0.9375, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.875, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375), Shapes.box((double)0.9375, (double)0.875, (double)0.0625, (double)1.0, (double)1.0, (double)0.9375), Shapes.box((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.875, (double)0.5625), Shapes.box((double)0.0625, (double)0.0, (double)0.4375, (double)0.3125, (double)0.09375, (double)0.5625), Shapes.box((double)0.1875, (double)0.09375, (double)0.4375, (double)0.4375, (double)0.1875, (double)0.5625), Shapes.box((double)0.6875, (double)0.0, (double)0.4375, (double)0.9375, (double)0.09375, (double)0.5625), Shapes.box((double)0.5625, (double)0.09375, (double)0.4375, (double)0.8125, (double)0.1875, (double)0.5625), Shapes.box((double)0.4375, (double)0.0, (double)0.0625, (double)0.5625, (double)0.09375, (double)0.3125), Shapes.box((double)0.4375, (double)0.09375, (double)0.1875, (double)0.5625, (double)0.1875, (double)0.4375), Shapes.box((double)0.4375, (double)0.0, (double)0.6875, (double)0.5625, (double)0.09375, (double)0.9375), Shapes.box((double)0.4375, (double)0.09375, (double)0.5625, (double)0.5625, (double)0.1875, (double)0.8125));
    private static final VoxelShape ONE_SHAPE_NORTH = ShapeUtil.combine(Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)0.9375), Shapes.box((double)0.0625, (double)0.875, (double)0.9375, (double)0.9375, (double)1.0, (double)1.0), Shapes.box((double)0.1875, (double)0.1875, (double)0.6875, (double)0.3125, (double)0.875, (double)0.8125), Shapes.box((double)0.21875, (double)0.125, (double)0.71875, (double)0.28125, (double)0.1875, (double)0.78125), Shapes.box((double)0.1875, (double)0.0, (double)0.6875, (double)0.3125, (double)0.125, (double)0.8125), Shapes.box((double)0.6875, (double)0.1875, (double)0.6875, (double)0.8125, (double)0.875, (double)0.8125), Shapes.box((double)0.71875, (double)0.125, (double)0.71875, (double)0.78125, (double)0.1875, (double)0.78125), Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.125, (double)0.8125));
    private static final VoxelShape ONE_SHAPE_EAST = ShapeUtil.rotate(ONE_SHAPE_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape ONE_SHAPE_SOUTH = ShapeUtil.rotate(ONE_SHAPE_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape ONE_SHAPE_WEST = ShapeUtil.rotate(ONE_SHAPE_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape STRAIGHT_SHAPE = Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape CURVE_SHAPE_NORTH = ShapeUtil.combine(Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)0.9375), Shapes.box((double)0.0, (double)0.875, (double)0.9375, (double)0.9375, (double)1.0, (double)1.0), Shapes.box((double)0.6875, (double)0.1875, (double)0.6875, (double)0.8125, (double)0.875, (double)0.8125), Shapes.box((double)0.71875, (double)0.125, (double)0.71875, (double)0.78125, (double)0.1875, (double)0.78125), Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.125, (double)0.8125));
    private static final VoxelShape CURVE_SHAPE_EAST = ShapeUtil.rotate(CURVE_SHAPE_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape CURVE_SHAPE_SOUTH = ShapeUtil.rotate(CURVE_SHAPE_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape CURVE_SHAPE_WEST = ShapeUtil.rotate(CURVE_SHAPE_NORTH, Rotation.COUNTERCLOCKWISE_90);

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)((Object)Type.NONE)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TableBlockEntity(pos, state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (((Type)((Object)state.getValue(TYPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NONE_SHAPE;
            case 1 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield ONE_SHAPE_SOUTH;
                    }
                    case WEST: {
                        yield ONE_SHAPE_WEST;
                    }
                    case EAST: {
                        yield ONE_SHAPE_EAST;
                    }
                }
                yield ONE_SHAPE_NORTH;
            }
            case 2, 4, 5 -> STRAIGHT_SHAPE;
            case 3 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield CURVE_SHAPE_SOUTH;
                    }
                    case WEST: {
                        yield CURVE_SHAPE_WEST;
                    }
                    case EAST: {
                        yield CURVE_SHAPE_EAST;
                    }
                }
                yield CURVE_SHAPE_NORTH;
            }
        };
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return this.getNewState((LevelAccessor)level, pos, Objects.requireNonNull(super.getStateForPlacement(context)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.getNewState(level, pos, this.defaultBlockState());
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem bi;
        Item item;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TableBlockEntity)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        TableBlockEntity table = (TableBlockEntity)blockEntity;
        Direction direction = hit.getDirection();
        if (direction == Direction.DOWN) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        boolean useCarpet = direction != Direction.UP && ((item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof WoolCarpetBlock || stack.isEmpty() && !table.getItem(1).isEmpty());
        ItemStack originalStack = table.getItem(useCarpet ? 1 : 0);
        if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)originalStack)) {
            return ItemInteractionResult.FAIL;
        }
        table.setItem(useCarpet ? 1 : 0, stack.copyWithCount(1));
        stack.shrink(1);
        if (!originalStack.isEmpty()) {
            if (stack.isEmpty()) {
                player.setItemInHand(hand, originalStack);
            } else {
                player.getInventory().add(originalStack);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    private BlockState getNewState(LevelAccessor level, BlockPos pos, BlockState state) {
        boolean north = level.getBlockState(pos.north()).getBlock() instanceof TableBlock;
        boolean east = level.getBlockState(pos.east()).getBlock() instanceof TableBlock;
        boolean south = level.getBlockState(pos.south()).getBlock() instanceof TableBlock;
        boolean west = level.getBlockState(pos.west()).getBlock() instanceof TableBlock;
        if (north && east && south && west) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.ALL));
        }
        if (north && south && west) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.THREE))).setValue((Property)FACING, (Comparable)Direction.WEST);
        }
        if (east && west && north) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.THREE))).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (south && north && east) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.THREE))).setValue((Property)FACING, (Comparable)Direction.EAST);
        }
        if (west && east && south) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.THREE))).setValue((Property)FACING, (Comparable)Direction.SOUTH);
        }
        if (north && south) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.STRAIGHT))).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (east && west) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.STRAIGHT))).setValue((Property)FACING, (Comparable)Direction.EAST);
        }
        if (north && east) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.CURVE))).setValue((Property)FACING, (Comparable)Direction.EAST);
        }
        if (east && south) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.CURVE))).setValue((Property)FACING, (Comparable)Direction.SOUTH);
        }
        if (south && west) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.CURVE))).setValue((Property)FACING, (Comparable)Direction.WEST);
        }
        if (west && north) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.CURVE))).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (north) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.ONE))).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (east) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.ONE))).setValue((Property)FACING, (Comparable)Direction.EAST);
        }
        if (south) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.ONE))).setValue((Property)FACING, (Comparable)Direction.SOUTH);
        }
        if (west) {
            return (BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)Type.ONE))).setValue((Property)FACING, (Comparable)Direction.WEST);
        }
        return state;
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        super.onBlockStateChange(level, pos, oldState, newState);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TableBlockEntity) {
            blockEntity.requestModelDataUpdate();
        }
    }

    public static enum Type implements StringRepresentable
    {
        NONE,
        ONE,
        STRAIGHT,
        CURVE,
        THREE,
        ALL;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

