/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog;

import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public interface StockroomCatalogSorting {
    public String getTranslationKey();

    public static enum Container implements StockroomCatalogSorting,
    StringRepresentable
    {
        ALPHABETICAL_ASC,
        ALPHABETICAL_DESC,
        DISTANCE_ASC,
        DISTANCE_DESC;

        public static final StreamCodec<ByteBuf, Container> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public String getTranslationKey() {
            return "gui.bibliocraft.stockroom_catalog.sorting.container." + this.getSerializedName();
        }

        static {
            STREAM_CODEC = BCUtil.enumStreamCodec(Container::values, Enum::ordinal);
        }
    }

    public static enum Item implements StockroomCatalogSorting,
    StringRepresentable
    {
        ALPHABETICAL_ASC,
        ALPHABETICAL_DESC,
        COUNT_ASC,
        COUNT_DESC;

        public static final StreamCodec<ByteBuf, Item> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public String getTranslationKey() {
            return "gui.bibliocraft.stockroom_catalog.sorting.item." + this.getSerializedName();
        }

        static {
            STREAM_CODEC = BCUtil.enumStreamCodec(Item::values, Enum::ordinal);
        }
    }
}

