/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog;

import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogContent;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogItemEntry;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogSorting;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class StockroomCatalogItem
extends Item {
    private static final Comparator<BlockPos> COMPARE_DISTANCE = Comparator.comparingDouble(e -> Objects.requireNonNull(Minecraft.getInstance().player).position().distanceTo(BCUtil.toVec3((Vec3i)e)));
    private static final Comparator<BlockPos> COMPARE_ALPHABETICAL = Comparator.comparing(e -> BCUtil.getNameAtPos((Level)Objects.requireNonNull(Minecraft.getInstance().level), e).getString());
    private static final Comparator<StockroomCatalogItemEntry> COMPARE_NAME = Comparator.comparing(e -> e.item().getDisplayName().getString());
    private static final Comparator<StockroomCatalogItemEntry> COMPARE_COUNT = Comparator.comparingInt(StockroomCatalogItemEntry::count);

    public StockroomCatalogItem(Item.Properties properties) {
        super(properties);
    }

    public static List<BlockPos> calculatePositions(ItemStack stack, Level level, Player player, StockroomCatalogSorting.Container containerSorting) {
        Stream<BlockPos> stream = ((StockroomCatalogContent)stack.getOrDefault(BCDataComponents.STOCKROOM_CATALOG_CONTENT, (Object)StockroomCatalogContent.DEFAULT)).positions().stream().filter(e -> e.dimension() == level.dimension()).map(GlobalPos::pos).filter(arg_0 -> ((Level)level).hasChunkAt(arg_0)).filter(e -> level.getCapability(Capabilities.ItemHandler.BLOCK, e, null) != null);
        Stream<BlockPos> stream2 = stream.sorted(switch (containerSorting) {
            default -> throw new MatchException(null, null);
            case StockroomCatalogSorting.Container.ALPHABETICAL_ASC, StockroomCatalogSorting.Container.DISTANCE_ASC -> COMPARE_DISTANCE;
            case StockroomCatalogSorting.Container.ALPHABETICAL_DESC, StockroomCatalogSorting.Container.DISTANCE_DESC -> BCUtil.reverseComparator(COMPARE_DISTANCE);
        });
        return stream2.sorted(switch (containerSorting) {
            case StockroomCatalogSorting.Container.ALPHABETICAL_ASC -> COMPARE_ALPHABETICAL;
            case StockroomCatalogSorting.Container.ALPHABETICAL_DESC -> BCUtil.reverseComparator(COMPARE_ALPHABETICAL);
            default -> Comparator.comparingInt($ -> 0);
        }).toList();
    }

    public static List<StockroomCatalogItemEntry> calculateItems(List<BlockPos> positions, Level level, StockroomCatalogSorting.Item itemSorting) {
        LinkedHashMap<ItemStack, StockroomCatalogItemEntry> tempItems = new LinkedHashMap<ItemStack, StockroomCatalogItemEntry>();
        for (BlockPos pos : positions) {
            IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
            if (cap == null) continue;
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack originalStack = cap.getStackInSlot(i);
                if (originalStack.isEmpty()) continue;
                ItemStack stack = originalStack.copy();
                int count = stack.getCount();
                stack.setCount(1);
                Optional<ItemStack> optional = tempItems.keySet().stream().filter(e -> ItemStack.isSameItemSameComponents((ItemStack)e, (ItemStack)stack)).findFirst();
                StockroomCatalogItemEntry entry = optional.map(itemStack -> ((StockroomCatalogItemEntry)tempItems.get(itemStack)).add(count)).orElseGet(() -> new StockroomCatalogItemEntry(originalStack));
                tempItems.put(optional.orElse(stack), entry.add(pos));
            }
        }
        Stream stream = tempItems.sequencedValues().stream();
        Stream<StockroomCatalogItemEntry> stream2 = stream.sorted(switch (itemSorting) {
            default -> throw new MatchException(null, null);
            case StockroomCatalogSorting.Item.ALPHABETICAL_ASC -> COMPARE_COUNT;
            case StockroomCatalogSorting.Item.ALPHABETICAL_DESC -> BCUtil.reverseComparator(COMPARE_COUNT);
            case StockroomCatalogSorting.Item.COUNT_ASC -> COMPARE_NAME;
            case StockroomCatalogSorting.Item.COUNT_DESC -> BCUtil.reverseComparator(COMPARE_NAME);
        });
        return stream2.sorted(switch (itemSorting) {
            default -> throw new MatchException(null, null);
            case StockroomCatalogSorting.Item.ALPHABETICAL_ASC -> COMPARE_NAME;
            case StockroomCatalogSorting.Item.ALPHABETICAL_DESC -> BCUtil.reverseComparator(COMPARE_NAME);
            case StockroomCatalogSorting.Item.COUNT_ASC -> COMPARE_COUNT;
            case StockroomCatalogSorting.Item.COUNT_DESC -> BCUtil.reverseComparator(COMPARE_COUNT);
        }).toList();
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && context.isSecondaryUseActive()) {
            GlobalPos globalPos;
            BlockPos pos = context.getClickedPos();
            Level level = context.getLevel();
            BlockState state = level.getBlockState(pos);
            ItemStack stack = context.getItemInHand();
            StockroomCatalogContent list = (StockroomCatalogContent)stack.getOrDefault(BCDataComponents.STOCKROOM_CATALOG_CONTENT, (Object)StockroomCatalogContent.DEFAULT);
            boolean hasNeighbor = state.hasProperty((Property)ChestBlock.TYPE) && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE;
            GlobalPos neighborPos = hasNeighbor ? new GlobalPos(level.dimension(), pos.offset(ChestBlock.getConnectedDirection((BlockState)state).getNormal())) : null;
            boolean hasPositionAtNeighbor = hasNeighbor && list.positions().contains(neighborPos);
            GlobalPos globalPos2 = globalPos = hasPositionAtNeighbor ? neighborPos : new GlobalPos(level.dimension(), pos);
            if (list.positions().contains(globalPos)) {
                stack.update(BCDataComponents.STOCKROOM_CATALOG_CONTENT, (Object)StockroomCatalogContent.DEFAULT, component -> component.remove(globalPos));
                player.displayClientMessage((Component)Component.translatable((String)"item.bibliocraft.stockroom_catalog.remove_container", (Object[])new Object[]{BCUtil.getNameAtPos(level, pos)}), true);
                return InteractionResult.SUCCESS;
            }
            IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)context.getClickedFace());
            if (cap != null) {
                stack.update(BCDataComponents.STOCKROOM_CATALOG_CONTENT, (Object)StockroomCatalogContent.DEFAULT, component -> component.add(globalPos));
                player.displayClientMessage((Component)Component.translatable((String)"item.bibliocraft.stockroom_catalog.add_container", (Object[])new Object[]{BCUtil.getNameAtPos(level, pos)}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            ClientUtil.openStockroomCatalogScreen(stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

