/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.seat;

import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackBlock;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackType;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatEntity;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCFacingBlock;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatBlock
extends BCWaterloggedBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    private static final VoxelShape SHAPE = ShapeUtil.combine(Shapes.box((double)0.0625, (double)0.625, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.9375), Shapes.box((double)0.125, (double)0.8125, (double)0.125, (double)0.875, (double)0.875, (double)0.875), Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.3125, (double)0.625, (double)0.3125), Shapes.box((double)0.6875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.3125), Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.625, (double)0.8125), Shapes.box((double)0.1875, (double)0.0, (double)0.6875, (double)0.3125, (double)0.625, (double)0.8125), Shapes.box((double)0.21875, (double)0.28125, (double)0.3125, (double)0.28125, (double)0.34375, (double)0.6875), Shapes.box((double)0.71875, (double)0.28125, (double)0.3125, (double)0.78125, (double)0.34375, (double)0.6875), Shapes.box((double)0.3125, (double)0.28125, (double)0.21875, (double)0.6875, (double)0.34375, (double)0.28125), Shapes.box((double)0.3125, (double)0.28125, (double)0.71875, (double)0.6875, (double)0.34375, (double)0.78125));
    private static final VoxelShape SHAPE_SMALL_NORTH = ShapeUtil.combine(SHAPE, Shapes.box((double)0.1875, (double)0.8125, (double)0.84375, (double)0.8125, (double)0.9375, (double)0.90625), Shapes.box((double)0.125, (double)0.921875, (double)0.8125, (double)0.875, (double)1.0, (double)0.9375));
    private static final VoxelShape SHAPE_SMALL_EAST = ShapeUtil.rotate(SHAPE_SMALL_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_SMALL_SOUTH = ShapeUtil.rotate(SHAPE_SMALL_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_SMALL_WEST = ShapeUtil.rotate(SHAPE_SMALL_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_RAISED_NORTH = ShapeUtil.combine(SHAPE, Shapes.box((double)0.1875, (double)0.8125, (double)0.75, (double)0.3125, (double)1.0, (double)0.875), Shapes.box((double)0.6875, (double)0.8125, (double)0.75, (double)0.8125, (double)1.0, (double)0.875));
    private static final VoxelShape SHAPE_RAISED_EAST = ShapeUtil.rotate(SHAPE_RAISED_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_RAISED_SOUTH = ShapeUtil.rotate(SHAPE_RAISED_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_RAISED_WEST = ShapeUtil.rotate(SHAPE_RAISED_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_FLAT_NORTH = ShapeUtil.combine(SHAPE, Shapes.box((double)0.125, (double)0.8125, (double)0.8125, (double)0.875, (double)1.0, (double)0.9375));
    private static final VoxelShape SHAPE_FLAT_EAST = ShapeUtil.rotate(SHAPE_FLAT_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_FLAT_SOUTH = ShapeUtil.rotate(SHAPE_FLAT_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_FLAT_WEST = ShapeUtil.rotate(SHAPE_FLAT_NORTH, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_FANCY_NORTH = ShapeUtil.combine(SHAPE_FLAT_NORTH, Shapes.box((double)0.875, (double)0.6875, (double)0.125, (double)1.0, (double)1.0, (double)0.9375), Shapes.box((double)0.875, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)0.125), Shapes.box((double)0.875, (double)0.75, (double)0.0625, (double)1.0, (double)0.875, (double)0.125), Shapes.box((double)0.0, (double)0.6875, (double)0.125, (double)0.125, (double)1.0, (double)0.9375), Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)0.125, (double)1.0, (double)0.125), Shapes.box((double)0.0, (double)0.75, (double)0.0625, (double)0.125, (double)0.875, (double)0.125));
    private static final VoxelShape SHAPE_FANCY_EAST = ShapeUtil.rotate(SHAPE_FANCY_NORTH, Rotation.CLOCKWISE_90);
    private static final VoxelShape SHAPE_FANCY_SOUTH = ShapeUtil.rotate(SHAPE_FANCY_NORTH, Rotation.CLOCKWISE_180);
    private static final VoxelShape SHAPE_FANCY_WEST = ShapeUtil.rotate(SHAPE_FANCY_NORTH, Rotation.COUNTERCLOCKWISE_90);

    public SeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue() || player.getVehicle() != null || !level.getBlockState(pos.above()).isAir() && !(level.getBlockState(pos.above()).getBlock() instanceof SeatBackBlock)) {
            return super.useWithoutItem(state, level, pos, player, hit);
        }
        if (!level.isClientSide()) {
            SeatEntity entity = new SeatEntity(level);
            entity.setPos(Vec3.atBottomCenterOf((Vec3i)pos));
            level.addFreshEntity((Entity)entity);
            player.startRiding((Entity)entity);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.getValue((Property)OCCUPIED) != false ? 15 : 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockState back = level.getBlockState(pos.above());
        if (!(back.getBlock() instanceof SeatBackBlock)) {
            return SHAPE;
        }
        return switch ((SeatBackType)((Object)back.getValue(SeatBackBlock.TYPE))) {
            default -> throw new MatchException(null, null);
            case SeatBackType.SMALL -> {
                switch ((Direction)back.getValue((Property)BCFacingBlock.FACING)) {
                    case NORTH: {
                        yield SHAPE_SMALL_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_SMALL_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_SMALL_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_SMALL_WEST;
                    }
                }
                yield SHAPE;
            }
            case SeatBackType.RAISED -> {
                switch ((Direction)back.getValue((Property)BCFacingBlock.FACING)) {
                    case NORTH: {
                        yield SHAPE_RAISED_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_RAISED_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_RAISED_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_RAISED_WEST;
                    }
                }
                yield SHAPE;
            }
            case SeatBackType.FLAT, SeatBackType.TALL -> {
                switch ((Direction)back.getValue((Property)BCFacingBlock.FACING)) {
                    case NORTH: {
                        yield SHAPE_FLAT_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_FLAT_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_FLAT_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_FLAT_WEST;
                    }
                }
                yield SHAPE;
            }
            case SeatBackType.FANCY -> {
                switch ((Direction)back.getValue((Property)BCFacingBlock.FACING)) {
                    case NORTH: {
                        yield SHAPE_FANCY_NORTH;
                    }
                    case EAST: {
                        yield SHAPE_FANCY_EAST;
                    }
                    case SOUTH: {
                        yield SHAPE_FANCY_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_FANCY_WEST;
                    }
                }
                yield SHAPE;
            }
        };
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos above = pos.above();
        BlockState back = level.getBlockState(above);
        if (back.getBlock() instanceof SeatBackBlock) {
            Block.dropResources((BlockState)back, (Level)level, (BlockPos)above);
            level.setBlockAndUpdate(above, Blocks.AIR.defaultBlockState());
            level.levelEvent(player, 2001, above, Block.getId((BlockState)back));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OCCUPIED});
    }
}

