/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clock;

import com.github.minecraftschurlimods.bibliocraft.content.clock.AbstractClockBlock;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.github.minecraftschurlimods.bibliocraft.content.clock.GrandfatherClockBlock;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.init.BCSoundEvents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClockBlockEntity
extends BlockEntity {
    private static final String TICK_SOUND_KEY = "tick";
    private static final String TRIGGERS_KEY = "triggers";
    private final List<ClockTrigger> triggers = new ArrayList<ClockTrigger>();
    private final Multimap<Integer, ClockTrigger> triggersMap = HashMultimap.create();
    public boolean tickSound = true;

    public ClockBlockEntity(BlockPos pos, BlockState state) {
        super(BCBlockEntities.CLOCK.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ClockBlockEntity blockEntity) {
        int time;
        if (((Boolean)state.getValue((Property)AbstractClockBlock.POWERED)).booleanValue()) {
            ClockBlockEntity.setPowered(level, pos, false);
        }
        if (blockEntity.triggersMap.containsKey((Object)(time = (int)(level.getDayTime() % 24000L)))) {
            Collection trigger = blockEntity.triggersMap.get((Object)time);
            if (trigger.stream().anyMatch(ClockTrigger::sound)) {
                level.playSound(null, pos, (SoundEvent)BCSoundEvents.CLOCK_CHIME.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (trigger.stream().anyMatch(ClockTrigger::redstone)) {
                ClockBlockEntity.setPowered(level, pos, true);
            }
        }
        if (blockEntity.tickSound && level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT) && time % 20 == 0) {
            level.playSound(null, pos, time % 40 == 0 ? (SoundEvent)BCSoundEvents.CLOCK_TICK.value() : (SoundEvent)BCSoundEvents.CLOCK_TOCK.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void setPowered(Level level, BlockPos pos, boolean powered) {
        level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)AbstractClockBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        if (level.getBlockState(pos.below()).getBlock() instanceof GrandfatherClockBlock) {
            level.setBlock(pos.below(), (BlockState)level.getBlockState(pos.below()).setValue((Property)AbstractClockBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public List<ClockTrigger> getTriggers() {
        return Collections.unmodifiableList(this.triggers);
    }

    public void setFromPacket(ClockSyncPacket packet) {
        this.tickSound = packet.tickSound();
        this.addTriggers(packet.triggers());
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void addTrigger(ClockTrigger trigger) {
        this.triggers.add(trigger);
        this.triggers.sort(ClockTrigger::compareTo);
        this.triggersMap.put((Object)trigger.getInGameTime(), (Object)trigger);
    }

    private void addTriggers(Collection<ClockTrigger> triggers) {
        this.triggers.clear();
        this.triggersMap.clear();
        for (ClockTrigger trigger : triggers) {
            this.triggers.add(trigger);
            this.triggersMap.put((Object)trigger.getInGameTime(), (Object)trigger);
        }
        this.triggers.sort(ClockTrigger::compareTo);
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.tickSound = tag.getBoolean(TICK_SOUND_KEY);
        ArrayList<ClockTrigger> list = new ArrayList<ClockTrigger>();
        for (Tag trigger : tag.getList(TRIGGERS_KEY, 10)) {
            list.add(BCUtil.decodeNbt(ClockTrigger.CODEC, trigger));
        }
        this.addTriggers(list);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean(TICK_SOUND_KEY, this.tickSound);
        ListTag list = new ListTag();
        for (ClockTrigger trigger : this.triggers) {
            list.add((Object)BCUtil.encodeNbt(ClockTrigger.CODEC, trigger));
        }
        tag.put(TRIGGERS_KEY, (Tag)list);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }
}

